/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.merging;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jnbt.NBTInputStream;
import org.jnbt.Tag;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.ParallelProgressManager;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.ScaledDimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.AbstractWorldExporter;
import org.pepsoft.worldpainter.exporting.BlockBasedExportSettings;
import org.pepsoft.worldpainter.exporting.BlockPropertiesCalculator;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.FlatteningDimension;
import org.pepsoft.worldpainter.exporting.JavaWorldExporter;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldPainterChunkFactory;
import org.pepsoft.worldpainter.exporting.WorldRegion;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.merging.InvalidMapException;
import org.pepsoft.worldpainter.platforms.PlatformUtils;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.FileInUseException;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaWorldMerger
extends JavaWorldExporter {
    private final File worldDir;
    private final ThreadLocal<Map<Material, Integer>> materialCountsRef = ThreadLocal.withInitial(HashMap::new);
    private boolean replaceChunks;
    private boolean mergeBlocksUnderground;
    private boolean clearTrees;
    private boolean clearResources;
    private boolean fillCaves;
    private boolean clearVegetation;
    private boolean clearManMadeAboveGround;
    private boolean clearManMadeBelowGround;
    private boolean mergeBlocksAboveGround;
    private boolean mergeBiomesAboveGround;
    private boolean mergeBiomesUnderground;
    private String warnings;
    private int surfaceMergeDepth = 1;
    private volatile boolean aborted = true;
    private static final Logger logger = LoggerFactory.getLogger(JavaWorldMerger.class);
    private static final Object TIMING_FILE_LOCK = new Object();
    private static final String EOL = System.getProperty("line.separator");
    private static final boolean[][] UNDERGROUND_MERGE_MATRIX = new boolean[][]{{false, false, true, true, false, false}, {false, false, false, true, false, false}, {false, false, false, true, false, false}, {false, false, false, false, false, false}, {true, true, true, true, false, false}, {true, true, true, true, true, false}};

    public JavaWorldMerger(World2 world, WorldExportSettings exportSettings, File mapDir, Platform platform) {
        super(world, exportSettings, platform);
        if (mapDir == null) {
            throw new NullPointerException();
        }
        if (!mapDir.isDirectory()) {
            throw new IllegalArgumentException(mapDir + " does not exist or is not a directory");
        }
        if (!new File(mapDir, "level.dat").isFile()) {
            throw new IllegalArgumentException(mapDir + " does not contain a level.dat file");
        }
        this.worldDir = mapDir;
    }

    public File getMapDir() {
        return this.worldDir;
    }

    public boolean isReplaceChunks() {
        return this.replaceChunks;
    }

    public void setReplaceChunks(boolean replaceChunks) {
        this.replaceChunks = replaceChunks;
    }

    public boolean isMergeBlocksAboveGround() {
        return this.mergeBlocksAboveGround;
    }

    public void setMergeBlocksAboveGround(boolean mergeBlocksAboveGround) {
        this.mergeBlocksAboveGround = mergeBlocksAboveGround;
    }

    public boolean isMergeBlocksUnderground() {
        return this.mergeBlocksUnderground;
    }

    public void setMergeBlocksUnderground(boolean mergeBlocksUnderground) {
        this.mergeBlocksUnderground = mergeBlocksUnderground;
    }

    public boolean isMergeBiomesAboveGround() {
        return this.mergeBiomesAboveGround;
    }

    public void setMergeBiomesAboveGround(boolean mergeBiomesAboveGround) {
        this.mergeBiomesAboveGround = mergeBiomesAboveGround;
    }

    public boolean isMergeBiomesUnderground() {
        return this.mergeBiomesUnderground;
    }

    public void setMergeBiomesUnderground(boolean mergeBiomesUnderground) {
        this.mergeBiomesUnderground = mergeBiomesUnderground;
    }

    public int getSurfaceMergeDepth() {
        return this.surfaceMergeDepth;
    }

    public void setSurfaceMergeDepth(int surfaceMergeDepth) {
        this.surfaceMergeDepth = surfaceMergeDepth;
    }

    public boolean isClearTrees() {
        return this.clearTrees;
    }

    public void setClearTrees(boolean clearTrees) {
        this.clearTrees = clearTrees;
    }

    public boolean isClearResources() {
        return this.clearResources;
    }

    public void setClearResources(boolean clearResources) {
        this.clearResources = clearResources;
    }

    public boolean isFillCaves() {
        return this.fillCaves;
    }

    public void setFillCaves(boolean fillCaves) {
        this.fillCaves = fillCaves;
    }

    public boolean isClearVegetation() {
        return this.clearVegetation;
    }

    public void setClearVegetation(boolean clearVegetation) {
        this.clearVegetation = clearVegetation;
    }

    public boolean isClearManMadeAboveGround() {
        return this.clearManMadeAboveGround;
    }

    public void setClearManMadeAboveGround(boolean clearManMadeAboveGround) {
        this.clearManMadeAboveGround = clearManMadeAboveGround;
    }

    public boolean isClearManMadeBelowGround() {
        return this.clearManMadeBelowGround;
    }

    public void setClearManMadeBelowGround(boolean clearManMadeBelowGround) {
        this.clearManMadeBelowGround = clearManMadeBelowGround;
    }

    public JavaLevel performSanityChecks() throws IOException {
        if (!(this.replaceChunks || this.mergeBiomesAboveGround || this.mergeBiomesUnderground || this.mergeBlocksAboveGround || this.mergeBlocksUnderground || this.clearTrees || this.clearResources || this.clearVegetation || this.clearManMadeAboveGround || this.clearManMadeBelowGround || this.fillCaves)) {
            throw new IllegalArgumentException("Nothing to do");
        }
        if (this.replaceChunks && (this.mergeBiomesAboveGround || this.mergeBiomesUnderground || this.mergeBlocksAboveGround || this.mergeBlocksUnderground || this.clearTrees || this.clearResources || this.clearVegetation || this.clearManMadeAboveGround || this.clearManMadeBelowGround || this.fillCaves)) {
            throw new IllegalArgumentException("replaceChunks is mutually exclusive with other merge options");
        }
        JavaLevel level = JavaLevel.load(new File(this.worldDir, "level.dat"));
        int version = level.getVersion();
        if (version != 19132 && version != 19133) {
            throw new IllegalArgumentException("Version of existing map not supported: 0x" + Integer.toHexString(version));
        }
        if (this.mergeBiomesAboveGround && !this.platform.capabilities.contains((Object)Platform.Capability.BIOMES) && !this.platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D) && !this.platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES)) {
            throw new IllegalArgumentException(this.platform.displayName + " maps do not support biomes");
        }
        if (this.mergeBiomesUnderground && !this.platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D) && !this.platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES)) {
            throw new IllegalArgumentException(this.platform.displayName + " maps do not support 3D biomes");
        }
        if (this.mergeBlocksAboveGround || this.mergeBlocksUnderground || this.mergeBiomesUnderground) {
            if (level.getMinHeight() != this.world.getMinHeight()) {
                throw new IllegalArgumentException("Existing map has different min height (" + level.getMinHeight() + ") than WorldPainter world (" + this.world.getMinHeight() + ")");
            }
            if (level.getMaxHeight() != this.world.getMaxHeight()) {
                throw new IllegalArgumentException("Existing map has different max height (" + level.getMaxHeight() + ") than WorldPainter world (" + this.world.getMaxHeight() + ")");
            }
            for (Dimension dimension : this.world.getDimensions()) {
                int mapDimMaxHeight;
                int mapDimMinHeight;
                int dim = dimension.getAnchor().dim;
                if (dim < 0 || this.worldExportSettings.getDimensionsToExport() != null && !this.worldExportSettings.getDimensionsToExport().contains(dim)) continue;
                switch (dim) {
                    case 0: {
                        mapDimMinHeight = level.getMinHeight();
                        mapDimMaxHeight = level.getMaxHeight();
                        break;
                    }
                    case 1: {
                        mapDimMinHeight = 0;
                        mapDimMaxHeight = 256;
                        break;
                    }
                    case 2: {
                        mapDimMinHeight = 0;
                        mapDimMaxHeight = 256;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Dimension " + dimension.getName() + " not supported for Merging");
                    }
                }
                if (mapDimMinHeight != dimension.getMinHeight()) {
                    throw new IllegalArgumentException("Dimension " + dimension.getName() + " has different min height (" + dimension.getMinHeight() + ") than existing map (" + mapDimMinHeight + ")");
                }
                if (mapDimMaxHeight == dimension.getMaxHeight()) continue;
                throw new IllegalArgumentException("Dimension " + dimension.getName() + " has different max height (" + dimension.getMaxHeight() + ") than existing map (" + mapDimMaxHeight + ")");
            }
        }
        return level;
    }

    public void merge(File backupDir, ProgressReceiver progressReceiver) throws IOException, ProgressReceiver.OperationCancelled {
        logger.info("Merging world " + this.world.getName() + " with map at " + this.worldDir);
        JavaLevel level = this.performSanityChecks();
        MDCUtils.doWithMdcContext(() -> {
            Configuration config;
            File[] files;
            long start = System.currentTimeMillis();
            if (!this.worldDir.renameTo(backupDir)) {
                throw new FileInUseException("Could not move " + this.worldDir + " to " + backupDir);
            }
            if (!this.worldDir.mkdirs()) {
                throw new IOException("Could not create " + this.worldDir);
            }
            Set<Integer> selectedDimensions = this.worldExportSettings.getDimensionsToExport();
            if (selectedDimensions == null || selectedDimensions.contains(0)) {
                Dimension surfaceDimension = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
                level.setSeed(surfaceDimension.getMinecraftSeed());
                Point point = this.world.getSpawnPoint();
                level.setSpawnX(point.x);
                level.setSpawnY(Math.max(this.getIntHeightAt(0, point.x, point.y), this.getWaterLevelAt(0, point.x, point.y)) + 1);
                level.setSpawnZ(point.y);
            }
            for (File file : files = backupDir.listFiles()) {
                if (file.getName().equalsIgnoreCase("level.dat") || file.getName().equalsIgnoreCase("level.dat_old") || file.getName().equalsIgnoreCase("session.lock") || (selectedDimensions == null || selectedDimensions.contains(0)) && file.getName().equalsIgnoreCase("region") || (selectedDimensions == null || selectedDimensions.contains(0)) && file.getName().equalsIgnoreCase("entities") || file.getName().equalsIgnoreCase("maxheight.txt") || file.getName().equalsIgnoreCase("Height.txt") || (selectedDimensions == null || selectedDimensions.contains(1)) && file.getName().equalsIgnoreCase("DIM-1") || (selectedDimensions == null || selectedDimensions.contains(2)) && file.getName().equalsIgnoreCase("DIM1")) continue;
                if (file.isFile()) {
                    FileUtils.copyFileToDir((File)file, (File)this.worldDir);
                    continue;
                }
                if (file.isDirectory()) {
                    FileUtils.copyDir((File)file, (File)new File(this.worldDir, file.getName()));
                    continue;
                }
                logger.warn("Not copying " + file + "; not a regular file or directory");
            }
            level.save(this.worldDir);
            if (selectedDimensions == null ? this.world.isDimensionPresent(Dimension.Anchor.NORMAL_DETAIL) : selectedDimensions.contains(0)) {
                this.mergeDimension(this.worldDir, backupDir, this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL), progressReceiver);
            }
            if (selectedDimensions == null ? this.world.isDimensionPresent(Dimension.Anchor.NETHER_DETAIL) : selectedDimensions.contains(1)) {
                this.mergeDimension(this.worldDir, backupDir, this.world.getDimension(Dimension.Anchor.NETHER_DETAIL), progressReceiver);
            }
            if (selectedDimensions == null ? this.world.isDimensionPresent(Dimension.Anchor.END_DETAIL) : selectedDimensions.contains(2)) {
                this.mergeDimension(this.worldDir, backupDir, this.world.getDimension(Dimension.Anchor.END_DETAIL), progressReceiver);
            }
            File file = new File(this.worldDir, "session.lock");
            try (DataOutputStream sessionOut = new DataOutputStream(new FileOutputStream(file));){
                sessionOut.writeLong(System.currentTimeMillis());
            }
            if (selectedDimensions == null) {
                this.world.addHistoryEntry(11, new Serializable[]{level.getName(), this.worldDir});
            } else {
                String dimNames = selectedDimensions.stream().map(dim -> {
                    switch (dim) {
                        case 0: {
                            return "Surface";
                        }
                        case 1: {
                            return "Nether";
                        }
                        case 2: {
                            return "End";
                        }
                    }
                    return Integer.toString(dim);
                }).collect(Collectors.joining(", "));
                this.world.addHistoryEntry(12, new Serializable[]{level.getName(), this.worldDir, dimNames});
            }
            File levelDatFile = new File(this.worldDir, "level.dat");
            if (!this.worldDir.equals(levelDatFile)) {
                this.world.setMergedWith(levelDatFile);
            }
            if ((config = Configuration.getInstance()) != null) {
                EventVO event = new EventVO("action.mergeWorld").duration(System.currentTimeMillis() - start);
                event.setAttribute(EventVO.ATTRIBUTE_TIMESTAMP, (Serializable)new Date(start));
                event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_HEIGHT, (Serializable)Integer.valueOf(this.world.getMaxHeight()));
                event.setAttribute(Constants.ATTRIBUTE_KEY_PLATFORM, (Serializable)((Object)this.platform.displayName));
                event.setAttribute(Constants.ATTRIBUTE_KEY_PLATFORM_ID, (Serializable)((Object)this.platform.id));
                event.setAttribute(Constants.ATTRIBUTE_KEY_MAP_FEATURES, (Serializable)Boolean.valueOf(this.world.isMapFeatures()));
                event.setAttribute(Constants.ATTRIBUTE_KEY_GAME_TYPE_NAME, (Serializable)((Object)this.world.getGameType().name()));
                event.setAttribute(Constants.ATTRIBUTE_KEY_ALLOW_CHEATS, (Serializable)Boolean.valueOf(this.world.isAllowCheats()));
                event.setAttribute(Constants.ATTRIBUTE_KEY_GENERATOR, (Serializable)((Object)this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL).getGenerator().getType().name()));
                if (selectedDimensions == null || selectedDimensions.contains(0)) {
                    Dimension surfaceDimension = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
                    event.setAttribute(Constants.ATTRIBUTE_KEY_TILES, (Serializable)Integer.valueOf(surfaceDimension.getTileCount()));
                    this.logLayers(surfaceDimension, event, "");
                }
                if (this.world.getImportedFrom() == null) {
                    event.setAttribute(Constants.ATTRIBUTE_KEY_IMPORTED_WORLD, (Serializable)Boolean.valueOf(false));
                }
                config.logEvent(event);
            }
            this.aborted = false;
            return null;
        }, (Object[])new Object[]{"world.name", this.world.getName(), "platform.id", this.platform.id, "world.minHeight", this.world.getMinHeight(), "world.maxHeight", this.world.getMaxHeight(), "mapDir", this.worldDir, "level.platform.id", level.getPlatform().id, "level.maxHeight", level.getMaxHeight()});
    }

    public String getWarnings() {
        return this.warnings;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private void mergeDimension(File worldDir, File backupWorldDir, Dimension dimension, ProgressReceiver progressReceiver) {
        MDCUtils.doWithMdcContext(() -> {
            File backupDimensionDir;
            File dimensionDir;
            if (progressReceiver != null) {
                progressReceiver.setMessage("merging " + dimension.getName() + " dimension");
            }
            Dimension.Anchor anchor = dimension.getAnchor();
            int dim = anchor.dim;
            switch (dim) {
                case 0: {
                    dimensionDir = worldDir;
                    backupDimensionDir = backupWorldDir;
                    break;
                }
                case 1: {
                    dimensionDir = new File(worldDir, "DIM-1");
                    backupDimensionDir = new File(backupWorldDir, "DIM-1");
                    break;
                }
                case 2: {
                    dimensionDir = new File(worldDir, "DIM1");
                    backupDimensionDir = new File(backupWorldDir, "DIM1");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Dimension " + dim + " not supported");
                }
            }
            Set<DataType> dataTypes = this.platformProvider.getDataTypes(this.platform);
            for (DataType dataType : dataTypes) {
                File regionDir = new File(dimensionDir, dataType.name().toLowerCase());
                if (regionDir.exists() || regionDir.mkdirs()) continue;
                throw new RuntimeException("Could not create directory " + regionDir);
            }
            Dimension master = dimension.getWorld().getDimension(new Dimension.Anchor(dim, Dimension.Role.MASTER, false, 0));
            Dimension combined = master != null ? new FlatteningDimension(dimension, new ScaledDimension(master, 16.0f)) : dimension;
            Set<Point> selectedTiles = this.worldExportSettings.getTilesToExport();
            Map savedSettings = this.world.getDimensions().stream().filter(d -> d.getAnchor().dim == dim).collect(Collectors.toMap(Function.identity(), d -> this.setupDimensionForExport((Dimension)d, selectedTiles)));
            try {
                HashMap<Point, List<Fixup>> hashMap;
                int lowestRegionX;
                int highestRegionX;
                int lowestRegionZ;
                int highestRegionZ;
                Map<Point, Map<Point, Tile>> tilesByRegion = this.getTilesByRegion(combined);
                File backupRegionDir = new File(backupDimensionDir, "region");
                HashSet<Object> allRegionCoords = new HashSet<Object>();
                File[] existingRegionFiles = this.platformProvider.getRegionFiles(this.platform, backupRegionDir, DataType.REGION);
                HashMap<Point, File> existingRegions = new HashMap<Point, File>();
                if (existingRegionFiles != null) {
                    for (File file : existingRegionFiles) {
                        if (file.length() == 0L) continue;
                        String[] parts = file.getName().split("\\.");
                        int regionX = Integer.parseInt(parts[1]);
                        int regionZ = Integer.parseInt(parts[2]);
                        existingRegions.put(new Point(regionX, regionZ), file);
                    }
                    allRegionCoords.addAll(existingRegions.keySet());
                }
                allRegionCoords.addAll(tilesByRegion.keySet());
                if (allRegionCoords.isEmpty()) {
                    highestRegionZ = 0;
                    lowestRegionZ = 0;
                    highestRegionX = 0;
                    lowestRegionX = 0;
                } else {
                    lowestRegionX = allRegionCoords.stream().mapToInt(p -> p.x).min().getAsInt();
                    highestRegionX = allRegionCoords.stream().mapToInt(p -> p.x).max().getAsInt();
                    lowestRegionZ = allRegionCoords.stream().mapToInt(p -> p.y).min().getAsInt();
                    highestRegionZ = allRegionCoords.stream().mapToInt(p -> p.y).max().getAsInt();
                }
                HashMap<Point, Map> additionalRegions = new HashMap<Point, Map>();
                for (DataType dataType : dataTypes) {
                    if (dataType == DataType.REGION || (existingRegionFiles = this.platformProvider.getRegionFiles(this.platform, backupRegionDir, dataType)) == null) continue;
                    for (File file : existingRegionFiles) {
                        if (file.length() == 0L) continue;
                        String[] parts = file.getName().split("\\.");
                        Point point = new Point(Integer.parseInt((String)parts[1]), Integer.parseInt((String)parts[2]));
                        additionalRegions.computeIfAbsent(point, p -> new HashMap()).put(dataType, file);
                    }
                }
                ArrayList<Object> sortedRegions = new ArrayList<Object>(allRegionCoords.size());
                if (lowestRegionZ == highestRegionZ) {
                    sortedRegions.addAll(allRegionCoords);
                } else {
                    for (int x = lowestRegionX; x <= highestRegionX; ++x) {
                        for (int z = lowestRegionZ; z <= lowestRegionZ + 1; ++z) {
                            Point regionCoords = new Point(x, z);
                            if (!allRegionCoords.contains(regionCoords)) continue;
                            sortedRegions.add(regionCoords);
                        }
                    }
                    for (int z = lowestRegionZ + 2; z <= highestRegionZ; ++z) {
                        for (int x = lowestRegionX; x <= highestRegionX; ++x) {
                            Point regionCoords = new Point(x, z);
                            if (!allRegionCoords.contains(regionCoords)) continue;
                            sortedRegions.add(regionCoords);
                        }
                    }
                }
                HashMap<Point, List<Fixup>> fixups = new HashMap<Point, List<Fixup>>();
                HashSet exportedRegions = new HashSet();
                ExecutorService executor = this.createExecutorService("merging", allRegionCoords.size() + additionalRegions.size());
                ParallelProgressManager parallelProgressManager = progressReceiver != null ? new ParallelProgressManager(progressReceiver, sortedRegions.size() + additionalRegions.size()) : null;
                AtomicBoolean abort = new AtomicBoolean();
                try {
                    for (Point point : sortedRegions) {
                        if (existingRegions.containsKey(point)) {
                            if (tilesByRegion.containsKey(point)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Region " + point + " will be merged");
                                }
                                Map<Point, Tile> tiles = tilesByRegion.get(point);
                                executor.execute(() -> {
                                    block21: {
                                        ProgressReceiver progressReceiver1;
                                        if (abort.get()) {
                                            return;
                                        }
                                        ProgressReceiver progressReceiver = progressReceiver1 = parallelProgressManager != null ? parallelProgressManager.createProgressReceiver() : null;
                                        if (progressReceiver1 != null) {
                                            try {
                                                progressReceiver1.checkForCancellation();
                                            }
                                            catch (ProgressReceiver.OperationCancelled e) {
                                                abort.set(true);
                                                return;
                                            }
                                        }
                                        try {
                                            Object regionWarnings;
                                            Map<Layer, LayerExporter> exporters = this.getExportersForRegion(combined, regionCoords);
                                            WorldPainterChunkFactory chunkFactory = new WorldPainterChunkFactory(combined, exporters, this.platform, combined.getMaxHeight());
                                            ArrayList<Fixup> regionFixups = new ArrayList<Fixup>();
                                            WorldRegion minecraftWorld = new WorldRegion(regionCoords.x, regionCoords.y, combined.getMinHeight(), combined.getMaxHeight(), this.platform);
                                            try {
                                                regionWarnings = this.mergeRegion(minecraftWorld, backupRegionDir, combined, regionCoords, tiles, selectedTiles != null, exporters, chunkFactory, regionFixups, (ProgressReceiver)(progressReceiver1 != null ? new SubProgressReceiver(progressReceiver1, 0.0f, 0.9f) : null));
                                                if (regionWarnings != null) {
                                                    JavaWorldMerger javaWorldMerger = this;
                                                    synchronized (javaWorldMerger) {
                                                        this.warnings = this.warnings == null ? regionWarnings : this.warnings + (String)regionWarnings;
                                                    }
                                                }
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug("Merged region " + regionCoords.x + "," + regionCoords.y);
                                                }
                                            }
                                            finally {
                                                minecraftWorld.save(worldDir, dim);
                                            }
                                            regionWarnings = fixups;
                                            synchronized (regionWarnings) {
                                                if (!regionFixups.isEmpty()) {
                                                    fixups.put(new Point(regionCoords.x, regionCoords.y), regionFixups);
                                                }
                                                exportedRegions.add(regionCoords);
                                            }
                                            try {
                                                this.performFixupsIfNecessary(worldDir, combined, allRegionCoords, fixups, exportedRegions, progressReceiver1);
                                            }
                                            catch (InvalidMapException e) {
                                                throw JavaWorldMerger.createInvalidMapException(e.getMessage(), backupWorldDir);
                                            }
                                        }
                                        catch (Throwable t) {
                                            logger.error("{} while merging region {},{} (message: \"{}\")", new Object[]{t.getClass().getSimpleName(), regionCoords.x, regionCoords.y, t.getMessage(), t});
                                            abort.set(true);
                                            if (progressReceiver1 == null) break block21;
                                            progressReceiver1.exceptionThrown(t);
                                        }
                                    }
                                });
                                continue;
                            }
                            HashMap regions2 = new HashMap();
                            regions2.put(DataType.REGION, existingRegions.get(point));
                            if (additionalRegions.containsKey(point)) {
                                regions2.putAll((Map)additionalRegions.get(point));
                            }
                            executor.execute(() -> {
                                block6: {
                                    if (abort.get()) {
                                        return;
                                    }
                                    if (progressReceiver != null) {
                                        try {
                                            progressReceiver.checkForCancellation();
                                        }
                                        catch (ProgressReceiver.OperationCancelled e) {
                                            abort.set(true);
                                            return;
                                        }
                                    }
                                    try {
                                        this.copyRegionsUnchanged(fixups, exportedRegions, regionCoords, regions2, dimensionDir, parallelProgressManager != null ? parallelProgressManager.createProgressReceiver() : null);
                                    }
                                    catch (Throwable t) {
                                        logger.error("{} while copying region {},{} (message: \"{}\")", new Object[]{t.getClass().getSimpleName(), regionCoords.x, regionCoords.y, t.getMessage(), t});
                                        abort.set(true);
                                        if (progressReceiver == null) break block6;
                                        progressReceiver.exceptionThrown(t);
                                    }
                                }
                            });
                            continue;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Region " + point + " does not exist in existing map and will be created as new");
                        }
                        executor.execute(() -> {
                            block18: {
                                ProgressReceiver progressReceiver1;
                                if (abort.get()) {
                                    return;
                                }
                                ProgressReceiver progressReceiver = progressReceiver1 = parallelProgressManager != null ? parallelProgressManager.createProgressReceiver() : null;
                                if (progressReceiver1 != null) {
                                    try {
                                        progressReceiver1.checkForCancellation();
                                    }
                                    catch (ProgressReceiver.OperationCancelled e) {
                                        abort.set(true);
                                        return;
                                    }
                                }
                                try {
                                    Map<Layer, LayerExporter> exporters = this.getExportersForRegion(combined, regionCoords);
                                    WorldPainterChunkFactory chunkFactory = new WorldPainterChunkFactory(combined, exporters, this.platform, combined.getMaxHeight());
                                    WorldRegion minecraftWorld = new WorldRegion(regionCoords.x, regionCoords.y, combined.getMinHeight(), combined.getMaxHeight(), this.platform);
                                    AbstractWorldExporter.ExportResults exportResults = null;
                                    try {
                                        exportResults = this.exportRegion(minecraftWorld, combined, null, regionCoords, selectedTiles != null, exporters, null, chunkFactory, null, (ProgressReceiver)(progressReceiver1 != null ? new SubProgressReceiver(progressReceiver1, 0.9f, 0.1f) : null));
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("Generated region " + regionCoords.x + "," + regionCoords.y);
                                        }
                                    }
                                    finally {
                                        if (exportResults != null && exportResults.chunksGenerated) {
                                            minecraftWorld.save(worldDir, dim);
                                        }
                                    }
                                    Map map = fixups;
                                    synchronized (map) {
                                        if (exportResults.fixups != null && !exportResults.fixups.isEmpty()) {
                                            fixups.put(new Point(regionCoords.x, regionCoords.y), exportResults.fixups);
                                        }
                                        exportedRegions.add(regionCoords);
                                    }
                                    try {
                                        this.performFixupsIfNecessary(worldDir, combined, allRegionCoords, fixups, exportedRegions, progressReceiver1);
                                    }
                                    catch (InvalidMapException e) {
                                        throw JavaWorldMerger.createInvalidMapException(e.getMessage(), backupWorldDir);
                                    }
                                }
                                catch (Throwable t) {
                                    logger.error("{} while exporting region {},{} (message: \"{}\")", new Object[]{t.getClass().getSimpleName(), regionCoords.x, regionCoords.y, t.getMessage(), t});
                                    abort.set(true);
                                    if (progressReceiver1 == null) break block18;
                                    progressReceiver1.exceptionThrown(t);
                                }
                            }
                        });
                    }
                    additionalRegions.forEach((coords, regions) -> {
                        if (!allRegionCoords.contains(coords)) {
                            executor.execute(() -> {
                                block6: {
                                    if (abort.get()) {
                                        return;
                                    }
                                    if (progressReceiver != null) {
                                        try {
                                            progressReceiver.checkForCancellation();
                                        }
                                        catch (ProgressReceiver.OperationCancelled e) {
                                            abort.set(true);
                                            return;
                                        }
                                    }
                                    try {
                                        this.copyRegionsUnchanged((Map<Point, List<Fixup>>)fixups, exportedRegions, (Point)coords, (Map<DataType, File>)regions, dimensionDir, parallelProgressManager != null ? parallelProgressManager.createProgressReceiver() : null);
                                    }
                                    catch (Throwable t) {
                                        logger.error("{} while copying region {},{} (message: \"{}\")", new Object[]{t.getClass().getSimpleName(), coords.x, coords.y, t.getMessage(), t});
                                        abort.set(true);
                                        if (progressReceiver == null) break block6;
                                        progressReceiver.exceptionThrown(t);
                                    }
                                }
                            });
                        }
                    });
                }
                finally {
                    executor.shutdown();
                    try {
                        executor.awaitTermination(1000L, TimeUnit.DAYS);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Thread interrupted while waiting for all tasks to finish", e);
                    }
                }
                if (!abort.get()) {
                    hashMap = fixups;
                    synchronized (hashMap) {
                        if (!fixups.isEmpty()) {
                            if (progressReceiver != null) {
                                progressReceiver.setMessage("doing remaining fixups for " + dimension.getName());
                                progressReceiver.reset();
                            }
                            try {
                                this.performFixups(worldDir, dimension, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.9f, 0.1f) : null), fixups);
                            }
                            catch (InvalidMapException invalidMapException) {
                                throw JavaWorldMerger.createInvalidMapException(invalidMapException.getMessage(), backupWorldDir);
                            }
                        }
                    }
                }
                if (progressReceiver != null) {
                    progressReceiver.setProgress(1.0f);
                }
                hashMap = null;
                return hashMap;
            }
            finally {
                savedSettings.forEach(this::restoreDimensionAfterExport);
            }
        }, (Object[])new Object[]{"dimension.anchor", dimension.getAnchor(), "dimension.minHeight", dimension.getMinHeight(), "dimension.maxHeight", dimension.getMaxHeight()});
    }

    private Map<Point, Map<Point, Tile>> getTilesByRegion(Dimension dimension) {
        Set<Point> selectedTiles = this.worldExportSettings.getTilesToExport();
        boolean tileSelection = selectedTiles != null;
        HashMap<Point, Map<Point, Tile>> tilesByRegion = new HashMap<Point, Map<Point, Tile>>();
        if (tileSelection) {
            assert (this.worldExportSettings.getDimensionsToExport().size() == 1);
            assert (this.worldExportSettings.getDimensionsToExport().contains(dimension.getAnchor().dim));
            for (Point point : selectedTiles) {
                Tile tile = dimension.getTile(point);
                boolean nonReadOnlyChunksFound = false;
                block1: for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        if (tile.getBitLayerValue(ReadOnly.INSTANCE, chunkX, chunkY)) continue;
                        nonReadOnlyChunksFound = true;
                        break block1;
                    }
                }
                if (!nonReadOnlyChunksFound) continue;
                int regionX = point.x >> 2;
                int regionZ = point.y >> 2;
                Point regionCoords = new Point(regionX, regionZ);
                Map tilesForRegion = tilesByRegion.computeIfAbsent(regionCoords, k -> new HashMap());
                tilesForRegion.put(point, tile);
            }
        } else {
            for (Tile tile : dimension.getTiles()) {
                boolean nonReadOnlyChunksFound = false;
                block4: for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        if (tile.getBitLayerValue(ReadOnly.INSTANCE, chunkX, chunkY)) continue;
                        nonReadOnlyChunksFound = true;
                        break block4;
                    }
                }
                if (!nonReadOnlyChunksFound) continue;
                int regionX = tile.getX() >> 2;
                int regionZ = tile.getY() >> 2;
                Point regionCoords = new Point(regionX, regionZ);
                Map tilesForRegion = tilesByRegion.computeIfAbsent(regionCoords, k -> new HashMap());
                tilesForRegion.put(new Point(tile.getX(), tile.getY()), tile);
            }
        }
        return tilesByRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRegionsUnchanged(Map<Point, List<Fixup>> fixups, Set<Point> exportedRegions, Point coords, Map<DataType, File> regions, File dimensionDir, ProgressReceiver progressReceiver) throws IOException, ProgressReceiver.OperationCancelled {
        if (logger.isDebugEnabled()) {
            logger.debug("Region " + coords + " does not exist in new world and will be copied from existing map");
        }
        if (progressReceiver != null) {
            progressReceiver.setMessage("Copying region " + coords.x + "," + coords.y + " unchanged");
        }
        int fileCount = regions.size();
        int fileNo = 0;
        for (Map.Entry<DataType, File> entry : regions.entrySet()) {
            DataType type = entry.getKey();
            File file = entry.getValue();
            FileUtils.copyFileToDir((File)file, (File)new File(dimensionDir, type.name().toLowerCase()), progressReceiver != null ? (fileCount == 1 ? progressReceiver : new SubProgressReceiver(progressReceiver, "Copying region " + coords.x + "," + coords.y + " of type " + (Object)((Object)type) + " unchanged", (float)fileNo / (float)fileCount, 1.0f / (float)fileCount)) : null);
            ++fileNo;
        }
        Map<Point, List<Fixup>> map = fixups;
        synchronized (map) {
            exportedRegions.add(coords);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Copied region " + coords.x + "," + coords.y);
        }
    }

    private String mergeRegion(MinecraftWorld minecraftWorld, File oldRegionDir, Dimension dimension, Point regionCoords, Map<Point, Tile> tiles, boolean tileSelection, Map<Layer, LayerExporter> exporters, ChunkFactory chunkFactory, List<Fixup> fixups, ProgressReceiver progressReceiver) {
        return (String)MDCUtils.doWithMdcContext(() -> {
            String warnings;
            if (progressReceiver != null) {
                progressReceiver.setMessage("Merging region " + regionCoords.x + "," + regionCoords.y + " of " + dimension.getName());
            }
            HashSet<Layer> allLayers = new HashSet<Layer>();
            for (Tile tile : tiles.values()) {
                allLayers.addAll(tile.getLayers());
            }
            Set<Layer> minimumLayers = dimension.getMinimumLayers();
            allLayers.addAll(minimumLayers);
            allLayers.removeIf(layer -> layer instanceof CustomLayer && !((CustomLayer)layer).isExport());
            this.applyWorldExportSettings(allLayers);
            ArrayList<Layer> secondaryPassLayers = new ArrayList<Layer>();
            for (Layer layer2 : allLayers) {
                Class<? extends LayerExporter> exporterType = layer2.getExporterType();
                if (exporterType == null || !SecondPassLayerExporter.class.isAssignableFrom(exporterType)) continue;
                secondaryPassLayers.add(layer2);
            }
            Collections.sort(secondaryPassLayers);
            long t1 = System.currentTimeMillis();
            if (this.firstPass((MinecraftWorld)minecraftWorld, (Dimension)dimension, (Point)regionCoords, (Map<Point, Tile>)tiles, (boolean)tileSelection, (Map<Layer, LayerExporter>)exporters, (ChunkFactory)chunkFactory, (boolean)false, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver((ProgressReceiver)progressReceiver, (float)0.0f, (float)0.3f) : null)).chunksGenerated) {
                long t4;
                long t2 = System.currentTimeMillis();
                List<Fixup> myFixups = this.secondPass(secondaryPassLayers, dimension, minecraftWorld, exporters, tiles.values(), regionCoords, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.3f, 0.1f) : null));
                if (myFixups != null && !myFixups.isEmpty()) {
                    List list = fixups;
                    synchronized (list) {
                        fixups.addAll(myFixups);
                    }
                }
                long t3 = System.currentTimeMillis();
                warnings = this.thirdPass(minecraftWorld, oldRegionDir, dimension, regionCoords, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.4f, 0.25f) : null));
                long t5 = t4 = System.currentTimeMillis();
                if (this.mergeBlocksAboveGround || this.mergeBlocksUnderground || this.clearTrees || this.clearVegetation || this.clearManMadeAboveGround || this.clearResources || this.fillCaves || this.clearManMadeBelowGround) {
                    BlockBasedExportSettings exportSettings = (BlockBasedExportSettings)(dimension.getExportSettings() instanceof BlockBasedExportSettings ? dimension.getExportSettings() : this.platformProvider.getDefaultExportSettings(this.platform));
                    PlatformManager.getInstance().getPostProcessor(this.platform).postProcess(minecraftWorld, new Rectangle(regionCoords.x << 9, regionCoords.y << 9, 512, 512), (ExportSettings)exportSettings, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.65f, 0.1f) : null));
                    t5 = System.currentTimeMillis();
                    if (BlockPropertiesCalculator.isBlockPropertiesPassNeeded(this.platform, this.worldExportSettings, exportSettings)) {
                        this.blockPropertiesPass(minecraftWorld, regionCoords, exportSettings, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.75f, 0.25f) : null));
                    }
                }
                long t6 = System.currentTimeMillis();
                if ("true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.devMode"))) {
                    String timingMessage = t2 - t1 + ", " + (t3 - t2) + ", " + (t4 - t3) + ", " + (t5 - t4) + ", " + (t6 - t5) + ", " + (t6 - t1);
                    Object object = TIMING_FILE_LOCK;
                    synchronized (object) {
                        try (PrintWriter out = new PrintWriter(new FileOutputStream("mergetimings.csv", true));){
                            out.println(timingMessage);
                        }
                    }
                }
            } else {
                warnings = this.copyAllChunksInRegion(minecraftWorld, oldRegionDir, dimension, regionCoords, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.3f, 0.7f) : null));
            }
            if (progressReceiver != null) {
                progressReceiver.setProgress(1.0f);
            }
            return warnings;
        }, (Object[])new Object[]{"region.coords", regionCoords});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String thirdPass(MinecraftWorld minecraftWorld, File oldRegionDir, Dimension dimension, Point regionCoords, ProgressReceiver progressReceiver) throws IOException, ProgressReceiver.OperationCancelled {
        if (progressReceiver != null) {
            progressReceiver.setMessage("Merging changes into existing chunks");
        }
        HashMap<DataType, RegionFile> regionFiles = new HashMap<DataType, RegionFile>();
        Set<DataType> dataTypes = this.platformProvider.getDataTypes(this.platform);
        for (DataType dataType2 : dataTypes) {
            RegionFile regionFile2 = this.platformProvider.getRegionFile(this.platform, oldRegionDir, dataType2, regionCoords, true);
            if (regionFile2 == null) continue;
            regionFiles.put(dataType2, regionFile2);
        }
        if (!regionFiles.containsKey((Object)DataType.REGION)) {
            throw new IllegalStateException("No region files of type REGION found for coordinates " + regionCoords + " in " + oldRegionDir.getParent());
        }
        StringBuilder reportBuilder = new StringBuilder();
        try {
            int lowestChunkX = regionCoords.x << 5;
            int highestChunkX = (regionCoords.x << 5) + 31;
            int lowestChunkY = regionCoords.y << 5;
            int highestChunkY = (regionCoords.y << 5) + 31;
            int minHeight = dimension.getMinHeight();
            int maxHeight = dimension.getMaxHeight();
            int chunkNo = 0;
            for (int chunkX = lowestChunkX; chunkX <= highestChunkX; ++chunkX) {
                for (int chunkY = lowestChunkY; chunkY <= highestChunkY; ++chunkY) {
                    ++chunkNo;
                    if (progressReceiver != null) {
                        progressReceiver.setProgress((float)chunkNo / 1156.0f);
                    }
                    Chunk newChunk = dimension.getTile(chunkX >> 3, chunkY >> 3) == null ? null : minecraftWorld.getChunk(chunkX, chunkY);
                    if (this.replaceChunks && newChunk != null) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Using chunk from new world at " + chunkX + "," + chunkY);
                        continue;
                    }
                    int chunkXInRegion = chunkX & 0x1F;
                    int chunkYInRegion = chunkY & 0x1F;
                    Chunk existingChunk = null;
                    if (((RegionFile)regionFiles.get((Object)DataType.REGION)).containsChunk(chunkXInRegion, chunkYInRegion)) {
                        HashMap<DataType, Tag> tags = new HashMap<DataType, Tag>();
                        regionFiles.forEach((dataType, regionFile) -> {
                            block18: {
                                try {
                                    DataInputStream chunkData = ((RegionFile)regionFiles.get(dataType)).getChunkDataInputStream(chunkXInRegion, chunkYInRegion);
                                    if (chunkData == null && dataType == DataType.REGION) {
                                        reportBuilder.append("Missing chunk data in existing map for chunk " + chunkXInRegion + ", " + chunkYInRegion + " in " + regionFile + "; skipping chunk" + EOL);
                                        logger.warn("Missing chunk data in existing map for chunk " + chunkXInRegion + ", " + chunkYInRegion + " in " + regionFile + "; skipping chunk");
                                        return;
                                    }
                                    if (chunkData == null) break block18;
                                    try (NBTInputStream in = new NBTInputStream((InputStream)chunkData);){
                                        tags.put((DataType)((Object)dataType), in.readTag());
                                    }
                                }
                                catch (IOException e) {
                                    reportBuilder.append("I/O error while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                    logger.error("I/O error while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)e);
                                }
                                catch (IllegalArgumentException e) {
                                    reportBuilder.append("Illegal argument exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                    logger.error("Illegal argument exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)e);
                                }
                                catch (ClassCastException e) {
                                    reportBuilder.append("Class cast exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                    logger.error("Class cast exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)e);
                                }
                                catch (RegionFile.InvalidRegionFileException e) {
                                    reportBuilder.append("Invalid region file while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                    logger.error("Invalid region file while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)((Object)e));
                                }
                            }
                        });
                        if (!tags.containsKey((Object)DataType.REGION)) continue;
                        existingChunk = this.platformProvider.createChunk(this.platform, tags, minHeight, maxHeight);
                    }
                    if (existingChunk == null) continue;
                    Set<Platform> chunkNativePlatforms = PlatformUtils.determineNativePlatforms(existingChunk);
                    if (chunkNativePlatforms != null && !chunkNativePlatforms.contains(this.platform)) {
                        throw JavaWorldMerger.createInvalidMapException("At least one of the existing chunks to be merged is in a different format (" + chunkNativePlatforms.stream().map(p -> p.displayName).collect(Collectors.joining(" or ")) + ")", oldRegionDir.getParentFile());
                    }
                    if (existingChunk.getMinHeight() > dimension.getMinHeight()) {
                        throw JavaWorldMerger.createInvalidMapException("At least one of the existing chunks to be merged has a higher minimum build height (" + existingChunk.getMinHeight() + ") than the dimension being merged (" + dimension.getMinHeight() + ")", oldRegionDir.getParentFile());
                    }
                    if (existingChunk.getMaxHeight() < dimension.getMaxHeight()) {
                        throw JavaWorldMerger.createInvalidMapException("At least one of the existing chunks to be merged has a lower maximum build height (" + existingChunk.getMaxHeight() + ") than the dimension being merged (" + dimension.getMaxHeight() + ")", oldRegionDir.getParentFile());
                    }
                    if (newChunk != null) {
                        this.processExistingChunk(existingChunk);
                        try {
                            this.mergeChunk(existingChunk, newChunk, dimension);
                            minecraftWorld.addChunk(existingChunk);
                        }
                        catch (NullPointerException e) {
                            reportBuilder.append("Null pointer exception while merging chunks @ " + chunkXInRegion + ", " + chunkYInRegion + " in region " + regionCoords + "; skipping chunk" + EOL);
                            logger.error("Null pointer exception while merging chunks @ " + chunkXInRegion + ", " + chunkYInRegion + " in region " + regionCoords + "; skipping chunk", (Throwable)e);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            reportBuilder.append("Array index out of bounds while merging chunks @ " + chunkXInRegion + ", " + chunkYInRegion + " in region " + regionCoords + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                            logger.error("Array index out of bounds while merging chunks @ " + chunkXInRegion + ", " + chunkYInRegion + " in region " + regionCoords + "; skipping chunk", (Throwable)e);
                        }
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using chunk from existing map at " + chunkX + "," + chunkY);
                    }
                    minecraftWorld.addChunk(existingChunk);
                }
            }
        }
        finally {
            for (RegionFile regionFile3 : regionFiles.values()) {
                regionFile3.close();
            }
        }
        if (progressReceiver != null) {
            progressReceiver.setProgress(1.0f);
        }
        return reportBuilder.length() != 0 ? reportBuilder.toString() : null;
    }

    private static InvalidMapException createInvalidMapException(String reason, File backupDir) {
        return new InvalidMapException(reason + "\nPlease use the Optimize function in Minecraft to convert the map fully to the current format.\n\nThe partially processed map is now probably corrupted.\nYou should replace it from the backup at " + backupDir + ".");
    }

    private void processExistingChunk(Chunk existingChunk) {
        if (!(this.clearTrees || this.fillCaves || this.clearResources || this.clearVegetation || this.clearManMadeAboveGround || this.clearManMadeBelowGround)) {
            return;
        }
        int minHeight = existingChunk.getMinHeight();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                boolean aboveGround = true;
                for (int y = existingChunk.getHighestNonAirBlock(x, z); y >= minHeight; --y) {
                    Material newMaterial;
                    Material existingBlock = existingChunk.getMaterial(x, y, z);
                    if (aboveGround) {
                        if (this.clearTrees && existingBlock.treeRelated || this.clearVegetation && existingBlock.vegetation || this.clearManMadeAboveGround && !existingBlock.natural) {
                            this.clearBlock(existingChunk, x, z, y, existingBlock);
                        } else if (existingBlock.terrain) {
                            aboveGround = false;
                        }
                    }
                    if (aboveGround) continue;
                    if (this.clearManMadeBelowGround && !existingBlock.natural) {
                        newMaterial = this.findMostPrevalentSolidSurroundingMaterial(existingChunk, x, z, y);
                        if (newMaterial == Material.AIR) {
                            this.clearBlock(existingChunk, x, z, y, existingBlock);
                        } else {
                            existingChunk.setMaterial(x, y, z, newMaterial);
                            existingChunk.setSkyLightLevel(x, y, z, 0);
                            existingChunk.setBlockLightLevel(x, y, z, 0);
                        }
                        existingBlock = existingChunk.getMaterial(x, y, z);
                    }
                    if (this.fillCaves && existingBlock.veryInsubstantial) {
                        newMaterial = this.findMostPrevalentSolidSurroundingMaterial(existingChunk, x, z, y);
                        if (newMaterial == Material.AIR) {
                            existingChunk.setMaterial(x, y, z, Material.STONE);
                        } else {
                            existingChunk.setMaterial(x, y, z, newMaterial);
                        }
                        existingChunk.setSkyLightLevel(x, y, z, 0);
                        existingChunk.setBlockLightLevel(x, y, z, 0);
                        continue;
                    }
                    if (!this.clearResources || !existingBlock.resource) continue;
                    if (existingBlock.isNamedOneOf("minecraft:nether_quartz_ore", "minecraft:nether_gold_ore", "minecraft:ancient_debris")) {
                        existingChunk.setMaterial(x, y, z, Material.NETHERRACK);
                        continue;
                    }
                    if (Material.DEEPSLATE_ORES.contains(existingBlock)) {
                        existingChunk.setMaterial(x, y, z, Material.DEEPSLATE_Y);
                        continue;
                    }
                    existingChunk.setMaterial(x, y, z, Material.STONE);
                }
            }
        }
    }

    private void clearBlock(Chunk chunk, int x, int y, int height, Material existingMaterial) {
        int minZ = chunk.getMinHeight();
        int maxZ = chunk.getMaxHeight() - 1;
        if (existingMaterial.watery || existingMaterial.is(Material.WATERLOGGED)) {
            chunk.setMaterial(x, height, y, Material.STATIONARY_WATER);
        } else if (existingMaterial.isNamed("minecraft:muddy_mangrove_roots")) {
            chunk.setMaterial(x, height, y, Material.MUD);
        } else {
            int skyLightLevelAbove;
            chunk.setMaterial(x, height, y, Material.AIR);
            int n = skyLightLevelAbove = height < maxZ ? chunk.getSkyLightLevel(x, height + 1, y) : 15;
            if (skyLightLevelAbove == 15) {
                chunk.setSkyLightLevel(x, height, y, 15);
            } else {
                int skyLightLevelBelow = height > minZ ? chunk.getSkyLightLevel(x, height - 1, y) : 0;
                chunk.setSkyLightLevel(x, height, y, Math.max(Math.max(skyLightLevelAbove, skyLightLevelBelow) - 1, 0));
            }
        }
        int blockLightLevelAbove = height < maxZ ? chunk.getSkyLightLevel(x, height + 1, y) : 0;
        int blockLightLevelBelow = height > minZ ? chunk.getBlockLightLevel(x, height - 1, y) : 0;
        chunk.setBlockLightLevel(x, height, y, Math.max(Math.max(blockLightLevelAbove, blockLightLevelBelow) - 1, 0));
    }

    private Material findMostPrevalentSolidSurroundingMaterial(Chunk existingChunk, int x, int y, int z) {
        Map<Material, Integer> materialCounts = this.materialCountsRef.get();
        materialCounts.clear();
        int mostPrevalentMaterialCount = 0;
        Material mostPrevalentMaterial = Material.AIR;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int newCount;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    int xx = x + dx;
                    int yy = y + dy;
                    int zz = z + dz;
                    if (xx < 0 || xx > 15 || yy < 0 || yy > 15 || zz < 0 || zz >= existingChunk.getMaxHeight()) continue;
                    Material material = existingChunk.getMaterial(xx, zz, yy);
                    if (!material.solid || material.resource || !material.opaque || (newCount = materialCounts.merge(material, 1, Integer::sum).intValue()) <= mostPrevalentMaterialCount) continue;
                    mostPrevalentMaterialCount = newCount;
                    mostPrevalentMaterial = material;
                }
            }
        }
        return mostPrevalentMaterial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyAllChunksInRegion(MinecraftWorld minecraftWorld, File oldRegionDir, Dimension dimension, Point regionCoords, ProgressReceiver progressReceiver) throws IOException, ProgressReceiver.OperationCancelled {
        if (progressReceiver != null) {
            progressReceiver.setMessage("Copying chunks unchanged");
        }
        HashMap<DataType, RegionFile> regionFiles = new HashMap<DataType, RegionFile>();
        Set<DataType> dataTypes = this.platformProvider.getDataTypes(this.platform);
        for (DataType dataType2 : dataTypes) {
            RegionFile regionFile2 = this.platformProvider.getRegionFile(this.platform, oldRegionDir, dataType2, regionCoords, true);
            if (regionFile2 == null) continue;
            regionFiles.put(dataType2, regionFile2);
        }
        if (!regionFiles.containsKey((Object)DataType.REGION)) {
            throw new IllegalStateException("No region files of type REGION found for coordinates " + regionCoords + " in " + oldRegionDir.getParent());
        }
        StringBuilder reportBuilder = new StringBuilder();
        try {
            int lowestChunkX = regionCoords.x << 5;
            int highestChunkX = (regionCoords.x << 5) + 31;
            int lowestChunkY = regionCoords.y << 5;
            int highestChunkY = (regionCoords.y << 5) + 31;
            int minHeight = dimension.getMinHeight();
            int maxHeight = dimension.getMaxHeight();
            int chunkNo = 0;
            for (int chunkX = lowestChunkX; chunkX <= highestChunkX; ++chunkX) {
                for (int chunkY = lowestChunkY; chunkY <= highestChunkY; ++chunkY) {
                    ++chunkNo;
                    if (progressReceiver != null) {
                        progressReceiver.setProgress((float)chunkNo / 1024.0f);
                    }
                    int chunkXInRegion = chunkX & 0x1F;
                    int chunkYInRegion = chunkY & 0x1F;
                    if (!((RegionFile)regionFiles.get((Object)DataType.REGION)).containsChunk(chunkXInRegion, chunkYInRegion)) continue;
                    HashMap<DataType, Tag> tags = new HashMap<DataType, Tag>();
                    regionFiles.forEach((dataType, regionFile) -> {
                        block18: {
                            try {
                                DataInputStream chunkData = ((RegionFile)regionFiles.get(dataType)).getChunkDataInputStream(chunkXInRegion, chunkYInRegion);
                                if (chunkData == null && dataType == DataType.REGION) {
                                    reportBuilder.append("Missing chunk data in existing map for chunk " + chunkXInRegion + ", " + chunkYInRegion + " in " + regionFile + "; skipping chunk" + EOL);
                                    logger.warn("Missing chunk data in existing map for chunk " + chunkXInRegion + ", " + chunkYInRegion + " in " + regionFile + "; skipping chunk");
                                    return;
                                }
                                if (chunkData == null) break block18;
                                try (NBTInputStream in = new NBTInputStream((InputStream)chunkData);){
                                    tags.put((DataType)((Object)dataType), in.readTag());
                                }
                            }
                            catch (IOException e) {
                                reportBuilder.append("I/O error while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                logger.error("I/O error while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)e);
                            }
                            catch (IllegalArgumentException e) {
                                reportBuilder.append("Illegal argument exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                logger.error("Illegal argument exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)e);
                            }
                            catch (ClassCastException e) {
                                reportBuilder.append("Class cast exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                logger.error("Class cast exception while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)e);
                            }
                            catch (RegionFile.InvalidRegionFileException e) {
                                reportBuilder.append("Invalid region file while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                                logger.error("Invalid region file while reading chunk in existing map " + chunkXInRegion + ", " + chunkYInRegion + " from file " + regionFile + "; skipping chunk", (Throwable)((Object)e));
                            }
                        }
                    });
                    if (!tags.containsKey((Object)DataType.REGION)) continue;
                    minecraftWorld.addChunk(this.platformProvider.createChunk(this.platform, tags, minHeight, maxHeight));
                }
            }
        }
        finally {
            for (RegionFile regionFile3 : regionFiles.values()) {
                regionFile3.close();
            }
        }
        if (progressReceiver != null) {
            progressReceiver.setProgress(1.0f);
        }
        return reportBuilder.length() != 0 ? reportBuilder.toString() : null;
    }

    private void mergeChunk(Chunk existingChunk, Chunk newChunk, Dimension dimension) {
        boolean copyBiomes;
        if (logger.isDebugEnabled()) {
            logger.debug("Merging chunks at " + existingChunk.getxPos() + "," + existingChunk.getzPos());
        }
        int minHeight = existingChunk.getMinHeight();
        int oldMaxY = existingChunk.getHighestNonAirBlock();
        int newMaxY = newChunk.getHighestNonAirBlock();
        int maxHeight = existingChunk.getMaxHeight();
        int chunkX = existingChunk.getxPos() << 4;
        int chunkZ = existingChunk.getzPos() << 4;
        boolean copy2DBiomes = existingChunk.isBiomesSupported() && newChunk.isBiomesAvailable();
        boolean copy3DBiomes = existingChunk.is3DBiomesSupported() && newChunk.is3DBiomesAvailable();
        boolean copyNamedBiomes = existingChunk.isNamedBiomesSupported() && newChunk.isNamedBiomesAvailable();
        boolean mergeBiomesUnderground = this.mergeBiomesUnderground || !this.platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D) && !this.platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES) && this.mergeBiomesAboveGround;
        boolean bl = copyBiomes = !(!this.mergeBiomesAboveGround && !mergeBiomesUnderground || !copy3DBiomes && !copyNamedBiomes);
        if (this.populateSupported && dimension.getBitLayerValueAt(Populate.INSTANCE, chunkX, chunkZ)) {
            existingChunk.setTerrainPopulated(false);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int maxY;
                double[] pos;
                int blockZ;
                int blockX;
                int y2;
                int mergeLimit;
                int dy;
                boolean biomeCopyColumn;
                if (this.mergeBiomesAboveGround && copy2DBiomes) {
                    existingChunk.setBiome(x, z, newChunk.getBiome(x, z));
                }
                boolean bl2 = biomeCopyColumn = copyBiomes && x % 4 == 1 && z % 4 == 1;
                if (dimension.getBitLayerValueAt(Void.INSTANCE, chunkX | x, chunkZ | z)) {
                    for (int y3 = existingChunk.getHighestNonAirBlock(x, z); y3 >= minHeight; --y3) {
                        existingChunk.setMaterial(x, y3, z, Material.AIR);
                        existingChunk.setBlockLightLevel(x, y3, z, 0);
                        existingChunk.setSkyLightLevel(x, y3, z, 15);
                        if (!biomeCopyColumn) continue;
                        if (copy3DBiomes) {
                            existingChunk.set3DBiome(x >> 2, y3 >> 2, z >> 2, newChunk.get3DBiome(x >> 2, y3 >> 2, z >> 2));
                            continue;
                        }
                        existingChunk.setNamedBiome(x >> 2, y3 >> 2, z >> 2, newChunk.getNamedBiome(x >> 2, y3 >> 2, z >> 2));
                    }
                    continue;
                }
                int newHeight = dimension.getIntHeightAt(chunkX | x, chunkZ | z);
                boolean frost = dimension.getBitLayerValueAt(Frost.INSTANCE, chunkX | x, chunkZ | z);
                int oldHeight = minHeight - 1;
                for (int y4 = oldMaxY; y4 >= minHeight; --y4) {
                    if (!existingChunk.getMaterial((int)x, (int)y4, (int)z).terrain) continue;
                    oldHeight = y4;
                    break;
                }
                if ((dy = newHeight - oldHeight) > 0) {
                    mergeLimit = Math.min(newHeight - this.surfaceMergeDepth, oldHeight);
                    if (this.mergeBlocksAboveGround) {
                        for (y2 = Math.min(Math.max(oldMaxY + dy, newMaxY), maxHeight - 1); y2 >= newHeight + 1; --y2) {
                            this.mergeAboveGroundBlock(existingChunk, newChunk, x, y2, z, dy, frost);
                        }
                        for (y2 = newHeight; y2 >= mergeLimit + 1; --y2) {
                            this.mergeSurfaceBlock(existingChunk, newChunk, x, y2, z, dy, minHeight, y2 < oldHeight);
                        }
                    }
                    if (this.mergeBlocksUnderground) {
                        for (y2 = mergeLimit; y2 >= minHeight; --y2) {
                            this.mergeUndergroundBlock(existingChunk, newChunk, x, y2, z);
                        }
                    }
                    existingChunk.setHeight(x, z, Math.min(Math.max(existingChunk.getHeight(x, z) + dy, newChunk.getHeight(x, z)), maxHeight - 1));
                    blockX = chunkX + x;
                    blockZ = chunkZ + z;
                    for (Entity entity : existingChunk.getEntities()) {
                        pos = entity.getPos();
                        if (!(pos[0] >= (double)blockX) || !(pos[0] < (double)(blockX + 1)) || !(pos[2] >= (double)blockZ) || !(pos[2] < (double)(blockZ + 1)) || !(pos[1] > (double)oldHeight)) continue;
                        pos[1] = Math.min(pos[1] + (double)dy, (double)(maxHeight - 1));
                        entity.setPos(pos);
                    }
                } else if (dy < 0) {
                    mergeLimit = Math.max(newHeight - this.surfaceMergeDepth, minHeight - 1);
                    if (this.mergeBlocksUnderground) {
                        for (y2 = minHeight; y2 <= mergeLimit; ++y2) {
                            this.mergeUndergroundBlock(existingChunk, newChunk, x, y2, z);
                        }
                    }
                    if (this.mergeBlocksAboveGround) {
                        for (y2 = mergeLimit + 1; y2 <= newHeight; ++y2) {
                            this.mergeSurfaceBlock(existingChunk, newChunk, x, y2, z, dy, minHeight, y2 < newHeight);
                        }
                        maxY = Math.min(Math.max(oldMaxY, newMaxY), maxHeight - 1);
                        for (y = newHeight + 1; y <= maxY; ++y) {
                            this.mergeAboveGroundBlock(existingChunk, newChunk, x, y, z, dy, frost);
                        }
                    }
                    existingChunk.setHeight(x, z, Math.min(Math.max(existingChunk.getHeight(x, z) + dy, newChunk.getHeight(x, z)), maxHeight - 1));
                    blockX = chunkX + x;
                    blockZ = chunkZ + z;
                    for (Entity entity : existingChunk.getEntities()) {
                        pos = entity.getPos();
                        if (!(pos[0] >= (double)blockX) || !(pos[0] < (double)(blockX + 1)) || !(pos[2] >= (double)blockZ) || !(pos[2] < (double)(blockZ + 1)) || !(pos[1] > (double)newHeight)) continue;
                        pos[1] = Math.min(Math.max(pos[1] + (double)dy, (double)newHeight), (double)(maxHeight - 1));
                        entity.setPos(pos);
                    }
                } else {
                    mergeLimit = Math.max(newHeight - this.surfaceMergeDepth, minHeight - 1);
                    if (this.mergeBlocksUnderground) {
                        for (y2 = minHeight; y2 <= mergeLimit; ++y2) {
                            this.mergeUndergroundBlock(existingChunk, newChunk, x, y2, z);
                        }
                    }
                    if (this.mergeBlocksAboveGround) {
                        for (y2 = mergeLimit + 1; y2 <= newHeight; ++y2) {
                            this.mergeSurfaceBlock(existingChunk, newChunk, x, y2, z, 0, minHeight, y2 < newHeight);
                        }
                        maxY = Math.min(Math.max(oldMaxY, newMaxY), maxHeight - 1);
                        for (y = newHeight + 1; y <= maxY; ++y) {
                            this.mergeAboveGroundBlock(existingChunk, newChunk, x, y, z, 0, frost);
                        }
                    }
                }
                if (!biomeCopyColumn) continue;
                int biomesMaxY = Math.min(Math.max(Math.max(oldMaxY, newMaxY) + 64, 319), maxHeight - 1) >> 2;
                int biomesNewHeight = newHeight - this.surfaceMergeDepth >> 2;
                for (y = minHeight >> 2; y <= biomesMaxY; ++y) {
                    if (!(y >= biomesNewHeight ? this.mergeBiomesAboveGround : mergeBiomesUnderground)) continue;
                    if (copy3DBiomes) {
                        existingChunk.set3DBiome(x >> 2, y, z >> 2, newChunk.get3DBiome(x >> 2, y, z >> 2));
                        continue;
                    }
                    existingChunk.setNamedBiome(x >> 2, y, z >> 2, newChunk.getNamedBiome(x >> 2, y, z >> 2));
                }
            }
        }
        existingChunk.getEntities().addAll(newChunk.getEntities());
    }

    private void mergeSurfaceBlock(Chunk existingChunk, Chunk newChunk, int x, int y, int z, int dy, int minHeight, boolean preserveCaves) {
        Material existingMaterial;
        Material material = existingMaterial = y - dy >= minHeight ? existingChunk.getMaterial(x, y - dy, z) : null;
        if (!preserveCaves || existingMaterial == null || !existingMaterial.veryInsubstantial && existingMaterial.natural) {
            Material newMaterial = newChunk.getMaterial(x, y, z);
            if (existingMaterial != null && (newMaterial == Material.DIRT && existingMaterial.isNamed("minecraft:farmland") || newMaterial == Material.DIRT && existingMaterial == Material.ROOTED_DIRT || newMaterial == Material.STONE && (existingMaterial == Material.INFESTED_STONE || Material.STONE_ORES.contains(existingMaterial)) || newMaterial.isNamed("minecraft:deepslate") && (existingMaterial.isNamed("minecraft:infested_deepslate") || Material.DEEPSLATE_ORES.contains(existingMaterial)) || newMaterial == Material.ICE && existingMaterial.isNamed("minecraft:frosted_ice") || newMaterial == Material.MUD && existingMaterial.isNamed("minecraft:muddy_mangrove_roots"))) {
                newMaterial = existingMaterial;
            }
            existingChunk.setMaterial(x, y, z, newMaterial);
            existingChunk.setSkyLightLevel(x, y, z, newChunk.getSkyLightLevel(x, y, z));
            existingChunk.setBlockLightLevel(x, y, z, newChunk.getBlockLightLevel(x, y, z));
            if (newMaterial.tileEntity) {
                this.moveEntityTileData(existingChunk, newChunk, x, y, z, 0);
            }
        }
    }

    private void mergeUndergroundBlock(Chunk existingChunk, Chunk newChunk, int x, int y, int z) {
        Material newMaterial = newChunk.getMaterial(x, y, z);
        if (!UNDERGROUND_MERGE_MATRIX[newMaterial.category][existingChunk.getMaterial((int)x, (int)y, (int)z).category]) {
            existingChunk.setMaterial(x, y, z, newMaterial);
            existingChunk.setSkyLightLevel(x, y, z, newChunk.getSkyLightLevel(x, y, z));
            existingChunk.setBlockLightLevel(x, y, z, newChunk.getBlockLightLevel(x, y, z));
            if (newMaterial.tileEntity) {
                this.moveEntityTileData(existingChunk, newChunk, x, y, z, 0);
            }
        }
    }

    private void mergeAboveGroundBlock(Chunk existingChunk, Chunk newChunk, int x, int y, int z, int dy, boolean frost) {
        boolean newMaterialIsWatery;
        Material newMaterial;
        Material existingMaterial;
        if (y - dy < existingChunk.getMinHeight() || y - dy >= existingChunk.getMaxHeight()) {
            existingMaterial = Material.AIR;
            if (dy != 0) {
                existingChunk.setMaterial(x, y, z, existingMaterial);
                existingChunk.setSkyLightLevel(x, y, z, y - dy < existingChunk.getMinHeight() ? 0 : 15);
                existingChunk.setBlockLightLevel(x, y, z, 0);
                if (x % 4 == 1 && z % 4 == 1 && (dy < -2 || dy > 1)) {
                    if (existingChunk.is3DBiomesAvailable()) {
                        existingChunk.set3DBiome(x >> 2, y >> 2, z >> 2, y - dy < existingChunk.getMinHeight() ? existingChunk.get3DBiome(x >> 2, existingChunk.getMinHeight() >> 2, z >> 2) : existingChunk.get3DBiome(x >> 2, (existingChunk.getMaxHeight() >> 2) - 1, z >> 2));
                    } else if (existingChunk.isNamedBiomesAvailable()) {
                        existingChunk.setNamedBiome(x >> 2, y >> 2, z >> 2, y - dy < existingChunk.getMinHeight() ? existingChunk.getNamedBiome(x >> 2, existingChunk.getMinHeight() >> 2, z >> 2) : existingChunk.getNamedBiome(x >> 2, (existingChunk.getMaxHeight() >> 2) - 1, z >> 2));
                    }
                }
            }
        } else {
            existingMaterial = existingChunk.getMaterial(x, y - dy, z);
            if (dy != 0) {
                existingChunk.setMaterial(x, y, z, existingMaterial);
                existingChunk.setSkyLightLevel(x, y, z, existingChunk.getSkyLightLevel(x, y - dy, z));
                existingChunk.setBlockLightLevel(x, y, z, existingChunk.getBlockLightLevel(x, y - dy, z));
                if (existingMaterial.tileEntity) {
                    this.moveEntityTileData(existingChunk, existingChunk, x, y, z, dy);
                }
                if (dy < 0) {
                    existingChunk.setMaterial(x, y - dy, z, Material.AIR);
                    existingChunk.setSkyLightLevel(x, y - dy, z, y - dy + 1 < existingChunk.getMaxHeight() ? existingChunk.getSkyLightLevel(x, y - dy + 1, z) : 15);
                    existingChunk.setBlockLightLevel(x, y - dy, z, 0);
                }
                if (x % 4 == 1 && z % 4 == 1 && (dy < -2 || dy > 1)) {
                    int dyBiome = dy + 2 >> 2;
                    int biomeMinHeight = existingChunk.getMinHeight() >> 2;
                    int biomeMaxHeight = existingChunk.getMaxHeight() >> 2;
                    if (existingChunk.is3DBiomesAvailable()) {
                        existingChunk.set3DBiome(x >> 2, y >> 2, z >> 2, existingChunk.get3DBiome(x >> 2, MathUtils.clamp((int)biomeMinHeight, (int)((y >> 2) - dyBiome), (int)(biomeMaxHeight - 1)), z >> 2));
                    } else if (existingChunk.isNamedBiomesAvailable()) {
                        existingChunk.setNamedBiome(x >> 2, y >> 2, z >> 2, existingChunk.getNamedBiome(x >> 2, MathUtils.clamp((int)biomeMinHeight, (int)((y >> 2) - dyBiome), (int)(biomeMaxHeight - 1)), z >> 2));
                    }
                }
            }
        }
        if ((newMaterial = newChunk.getMaterial(x, y, z)) == existingMaterial) {
            return;
        }
        boolean existingMaterialIsWatery = existingMaterial.isNamed("minecraft:water") || existingMaterial.is(Material.WATERLOGGED) || existingMaterial.watery;
        boolean bl = newMaterialIsWatery = newMaterial.isNamed("minecraft:water") || newMaterial.is(Material.WATERLOGGED) || newMaterial.watery;
        if (existingMaterial.isNamedOneOf("minecraft:water", "minecraft:ice", "minecraft:lava") || existingMaterial == Material.AIR || !newMaterial.veryInsubstantial || existingMaterial.insubstantial && newMaterial.insubstantial || !frost && existingMaterial.isNamed("minecraft:snow") || newMaterialIsWatery && existingMaterial.veryInsubstantial && !existingMaterial.hasProperty(Material.WATERLOGGED) && !existingMaterial.watery || newMaterial.isNamed("minecraft:lava") && existingMaterial.veryInsubstantial || existingMaterial.watery && !newMaterialIsWatery) {
            if (existingMaterial.isNamed("minecraft:snow") && newMaterial.isNamed("minecraft:snow")) {
                existingChunk.setMaterial(x, y, z, Material.SNOW.withProperty(Material.LAYERS, Math.max(existingMaterial.getProperty(Material.LAYERS), newMaterial.getProperty(Material.LAYERS))));
            } else {
                existingChunk.setMaterial(x, y, z, newMaterial);
                if (newMaterial.tileEntity) {
                    this.moveEntityTileData(existingChunk, newChunk, x, y, z, 0);
                }
            }
            existingChunk.setSkyLightLevel(x, y, z, newChunk.getSkyLightLevel(x, y, z));
            existingChunk.setBlockLightLevel(x, y, z, newChunk.getBlockLightLevel(x, y, z));
            existingMaterial = newMaterial;
            existingMaterialIsWatery = newMaterialIsWatery;
        }
        if (existingMaterial.hasProperty(Material.WATERLOGGED) && newMaterialIsWatery != existingMaterialIsWatery) {
            if (newMaterialIsWatery) {
                existingChunk.setMaterial(x, y, z, existingMaterial.withProperty(Material.WATERLOGGED, true));
            } else {
                existingChunk.setMaterial(x, y, z, existingMaterial.withProperty(Material.WATERLOGGED, false));
            }
        }
    }
}

