/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.trees;

import java.awt.Rectangle;
import java.util.List;
import java.util.Random;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.SwampLand;
import org.pepsoft.worldpainter.layers.TreeLayer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.TreesExporter;

public class SwampLandExporter
extends TreesExporter<TreeLayer> {
    public SwampLandExporter(Dimension dimension, Platform platform, ExporterSettings settings, SwampLand layer) {
        super(dimension, platform, settings, layer);
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld world) {
        List<Fixup> fixups = super.addFeatures(area, exportedArea, world);
        TreesExporter.TreeLayerSettings settings = (TreesExporter.TreeLayerSettings)this.settings;
        int minimumLevel = settings.getMinimumLevel();
        for (int chunkX = area.x; chunkX < area.x + area.width; chunkX += 16) {
            for (int chunkY = area.y; chunkY < area.y + area.height; chunkY += 16) {
                long seed = this.dimension.getSeed() + (long)(chunkX >> 4) * 65537L + (long)(chunkY >> 4) * 4099L + (long)((TreeLayer)this.layer).hashCode() + 1L;
                Random random = new Random(seed);
                for (int x = chunkX; x < chunkX + 16; ++x) {
                    for (int y = chunkY; y < chunkY + 16; ++y) {
                        int strength;
                        int waterLevel;
                        int terrainLevel = this.dimension.getIntHeightAt(x, y);
                        if (terrainLevel == Integer.MIN_VALUE || (waterLevel = this.dimension.getWaterLevelAt(x, y)) <= terrainLevel || waterLevel >= this.maxZ || (strength = Math.max(minimumLevel, this.dimension.getLayerValueAt(this.layer, x, y))) <= 0 || random.nextInt(3840) > strength * strength) continue;
                        Material material = world.getMaterialAt(x, y, waterLevel);
                        Material materialAbove = world.getMaterialAt(x, y, waterLevel + 1);
                        if (!material.isNamed("minecraft:water") || materialAbove != Material.AIR) continue;
                        world.setMaterialAt(x, y, waterLevel + 1, Material.LILY_PAD);
                    }
                }
            }
        }
        return fixups;
    }
}

