/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.renderers;

import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.layers.renderers.ColourSchemeRenderer;
import org.pepsoft.worldpainter.layers.renderers.NibbleLayerRenderer;

public class GardenCategoryRenderer
implements NibbleLayerRenderer,
ColourSchemeRenderer {
    private ColourScheme colourScheme;
    private int cobblestoneColour;
    private int grassColour;
    private int dirtColour;
    private int bricksColour;
    private int torchColour;
    private int woodColour;
    private int waterColour;
    private int objectColour;
    private int treeColour;

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
        this.cobblestoneColour = colourScheme.getColour(Material.COBBLESTONE);
        this.grassColour = colourScheme.getColour(Material.GRASS_BLOCK);
        this.dirtColour = colourScheme.getColour(Material.DIRT);
        this.bricksColour = colourScheme.getColour(Material.BRICKS);
        this.woodColour = colourScheme.getColour(Material.WOODEN_PLANK_OAK);
        this.waterColour = colourScheme.getColour(Material.WATER);
        this.objectColour = colourScheme.getColour(Material.WOOL_MAGENTA);
        this.treeColour = colourScheme.getColour(Material.LEAVES_OAK);
    }

    @Override
    public int getPixelColour(int x, int y, int underlyingColour, int value) {
        switch (value) {
            case 0: {
                return underlyingColour;
            }
            case 1: {
                return this.cobblestoneColour;
            }
            case 3: {
                if ((x + y) % 2 == 0) {
                    return this.grassColour;
                }
                return this.dirtColour;
            }
            case 2: {
                return this.bricksColour;
            }
            case 4: {
                return this.woodColour;
            }
            case 5: {
                return this.waterColour;
            }
            case 6: {
                return this.treeColour;
            }
            case 7: {
                return this.objectColour;
            }
        }
        throw new IllegalArgumentException(Integer.toString(value));
    }
}

