/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.renderers;

import org.pepsoft.util.ColourUtils;
import org.pepsoft.worldpainter.layers.renderers.NibbleLayerRenderer;

public class ColouredPatternRenderer
implements NibbleLayerRenderer {
    private final int colour;
    private final int dx;
    private final int dy;
    private final boolean[][] pattern;

    public ColouredPatternRenderer(int colour, boolean[][] pattern) {
        this(colour, pattern, 0, 0);
    }

    public ColouredPatternRenderer(int colour, boolean[][] pattern, int dx, int dy) {
        this.colour = colour;
        this.pattern = pattern;
        this.dx = dx;
        this.dy = dy;
        if (pattern.length != 8) {
            throw new IllegalArgumentException("pattern");
        }
        for (boolean[] row : pattern) {
            if (row.length == 8) continue;
            throw new IllegalArgumentException("pattern");
        }
    }

    @Override
    public int getPixelColour(int x, int y, int underlyingColour, int value) {
        if (value > 0 && this.pattern[y + this.dy & 7][x + this.dx & 7]) {
            int intensity = value * 255 / 15;
            return ColourUtils.mix((int)this.colour, (int)underlyingColour, (int)intensity);
        }
        return underlyingColour;
    }
}

