/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.pockets;

import java.awt.image.BufferedImage;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;

public class UndergroundPocketsLayerExporter
extends AbstractLayerExporter<UndergroundPocketsLayer>
implements FirstPassLayerExporter {
    private final PerlinNoise noiseGenerator = new PerlinNoise(0L);
    private final float[] biasedThresholds = new float[15];
    private final long seedOffset;
    private final double scale;

    public UndergroundPocketsLayerExporter(Dimension dimension, Platform platform, UndergroundPocketsLayer layer) {
        super(dimension, platform, null, layer);
        this.seedOffset = layer.getMaterial() != null ? (long)layer.getMaterial().hashCode() : (long)layer.getTerrain().hashCode();
        for (int i = 1; i <= 15; ++i) {
            this.biasedThresholds[i - 1] = PerlinNoise.getLevelForPromillage((float)MathUtils.clamp((float)0.0f, (float)((float)((double)layer.getFrequency() * Math.pow(0.9, 8 - i))), (float)1000.0f));
        }
        this.scale = (double)4.099f * ((double)layer.getScale() / 100.0);
    }

    @Override
    public void render(Tile tile, Chunk chunk) {
        MixedMaterial material = ((UndergroundPocketsLayer)this.layer).getMaterial();
        Terrain terrain = ((UndergroundPocketsLayer)this.layer).getTerrain();
        boolean useMaterial = material != null;
        int minLevel = ((UndergroundPocketsLayer)this.layer).getMinLevel();
        int maxLevel = ((UndergroundPocketsLayer)this.layer).getMaxLevel();
        boolean coverSteepTerrain = this.dimension.isCoverSteepTerrain();
        int xOffset = (chunk.getxPos() & 7) << 4;
        int zOffset = (chunk.getzPos() & 7) << 4;
        long seed = this.dimension.getSeed();
        if (this.noiseGenerator.getSeed() != seed + this.seedOffset) {
            this.noiseGenerator.setSeed(seed + this.seedOffset);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int value;
                int localX = xOffset + x;
                int localY = zOffset + z;
                if (tile.getBitLayerValue(Void.INSTANCE, localX, localY) || (value = tile.getLayerValue(this.layer, localX, localY)) <= 0) continue;
                float biasedThreshold = this.biasedThresholds[value - 1];
                int terrainheight = tile.getIntHeight(localX, localY);
                int worldX = tile.getX() << 7 | localX;
                int worldY = tile.getY() << 7 | localY;
                int minY = Math.max(this.minHeight + 1, minLevel);
                int maxY = Math.min(terrainheight - this.dimension.getTopLayerDepth(worldX, worldY, terrainheight), maxLevel);
                if (coverSteepTerrain) {
                    maxY = Math.min(maxY, Math.min(Math.min(this.dimension.getIntHeightAt(worldX - 1, worldY, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX + 1, worldY, Integer.MAX_VALUE)), Math.min(this.dimension.getIntHeightAt(worldX, worldY - 1, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX, worldY + 1, Integer.MAX_VALUE))));
                }
                if (biasedThreshold <= -0.5f) {
                    for (y = maxY; y >= minY; --y) {
                        if (useMaterial) {
                            chunk.setMaterial(x, y, z, material.getMaterial(seed, worldX, worldY, y));
                            continue;
                        }
                        chunk.setMaterial(x, y, z, terrain.getMaterial(this.platform, seed, worldX, worldY, y, terrainheight));
                    }
                    continue;
                }
                for (y = maxY; y >= minY; --y) {
                    double dx = (double)worldX / this.scale;
                    double dy = (double)worldY / this.scale;
                    double dz = (double)y / this.scale;
                    if (!(this.noiseGenerator.getPerlinNoise(dx, dy, dz) >= biasedThreshold)) continue;
                    if (useMaterial) {
                        chunk.setMaterial(x, y, z, material.getMaterial(seed, worldX, worldY, y));
                        continue;
                    }
                    chunk.setMaterial(x, y, z, terrain.getMaterial(this.platform, seed, worldX, worldY, y, terrainheight));
                }
            }
        }
    }

    public static BufferedImage createPreview(UndergroundPocketsLayer layer, int width, int height) {
        PerlinNoise noiseGenerator = new PerlinNoise(0L);
        float[] biasedThresholds = new float[15];
        for (int i = 1; i <= 15; ++i) {
            biasedThresholds[i - 1] = PerlinNoise.getLevelForPromillage((float)MathUtils.clamp((float)0.0f, (float)((float)((double)layer.getFrequency() * Math.pow(0.9, 8 - i))), (float)1000.0f));
        }
        float threshold = biasedThresholds[8];
        double scale = (double)4.099f * ((double)layer.getScale() / 100.0);
        BufferedImage preview = new BufferedImage(width, height, 10);
        if (threshold > -0.5f) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    double dx = (double)x / scale;
                    double dz = (double)z / scale;
                    if (!(noiseGenerator.getPerlinNoise(dx, 0.0, dz) < threshold)) continue;
                    preview.setRGB(x, height - z - 1, 0xFFFFFF);
                }
            }
        }
        return preview;
    }

    public static BufferedImage createPreview(UndergroundPocketsLayer layer, int width, int height, ColourScheme colourScheme, Terrain subsurfaceMaterial, Platform platform) {
        boolean useMaterial;
        PerlinNoise noiseGenerator = new PerlinNoise(0L);
        float[] biasedThresholds = new float[15];
        for (int i = 1; i <= 15; ++i) {
            biasedThresholds[i - 1] = PerlinNoise.getLevelForPromillage((float)MathUtils.clamp((float)0.0f, (float)((float)((double)layer.getFrequency() * Math.pow(0.9, 8 - i))), (float)1000.0f));
        }
        float threshold = biasedThresholds[8];
        double scale = (double)4.099f * ((double)layer.getScale() / 100.0);
        BufferedImage preview = new BufferedImage(width, height, 1);
        MixedMaterial material = layer.getMaterial();
        Terrain terrain = layer.getTerrain();
        boolean bl = useMaterial = material != null;
        if (threshold <= -0.5f) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    if (useMaterial) {
                        preview.setRGB(x, height - z - 1, colourScheme.getColour(material.getMaterial(0L, x, 0, z)));
                        continue;
                    }
                    preview.setRGB(x, height - z - 1, colourScheme.getColour(terrain.getMaterial(platform, 0L, x, 0, z, height - 1)));
                }
            }
        } else {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    double dx = (double)x / scale;
                    double dz = (double)z / scale;
                    if (noiseGenerator.getPerlinNoise(dx, 0.0, dz) >= threshold) {
                        if (useMaterial) {
                            preview.setRGB(x, height - z - 1, colourScheme.getColour(material.getMaterial(0L, x, 0, z)));
                            continue;
                        }
                        preview.setRGB(x, height - z - 1, colourScheme.getColour(terrain.getMaterial(platform, 0L, x, 0, z, height - 1)));
                        continue;
                    }
                    preview.setRGB(x, height - z - 1, colourScheme.getColour(subsurfaceMaterial.getMaterial(platform, 0L, x, 0, z, height - 1)));
                }
            }
        }
        return preview;
    }
}

