/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class AnnotationsExporter
extends AbstractLayerExporter<Annotations>
implements SecondPassLayerExporter {
    public AnnotationsExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings != null ? settings : new AnnotationsSettings(), Annotations.INSTANCE);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return Collections.singleton(SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        AnnotationsSettings settings = (AnnotationsSettings)this.settings;
        if (!settings.isExport()) {
            return null;
        }
        int maxHeight = minecraftWorld.getMaxHeight() - 1;
        for (int x = area.x; x < area.x + area.width; ++x) {
            for (int y = area.y; y < area.y + area.height; ++y) {
                int value = this.dimension.getLayerValueAt(Annotations.INSTANCE, x, y);
                if (value <= 0) continue;
                int height = this.dimension.getIntHeightAt(x, y);
                Material existingMaterial = minecraftWorld.getMaterialAt(x, y, height + 1);
                if (height >= maxHeight || !existingMaterial.veryInsubstantial && existingMaterial != Material.ICE) continue;
                minecraftWorld.setMaterialAt(x, y, height + 1, Material.get(35, value - (value < 8 ? 1 : 0)));
            }
        }
        return null;
    }

    public static class AnnotationsSettings
    implements ExporterSettings {
        private boolean export;
        private String defaultFont = "SansSerif";
        private int defaultSize = 18;

        @Override
        public boolean isApplyEverywhere() {
            return false;
        }

        @Override
        public Annotations getLayer() {
            return Annotations.INSTANCE;
        }

        public boolean isExport() {
            return this.export;
        }

        public void setExport(boolean export) {
            this.export = export;
        }

        public String getDefaultFont() {
            return this.defaultFont;
        }

        public void setDefaultFont(String defaultFont) {
            this.defaultFont = defaultFont;
        }

        public int getDefaultSize() {
            return this.defaultSize;
        }

        public void setDefaultSize(int defaultSize) {
            this.defaultSize = defaultSize;
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + (this.export ? 1 : 0);
            hash = 41 * hash + (this.defaultFont != null ? this.defaultFont.hashCode() : 0);
            hash = 41 * hash + this.defaultSize;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationsSettings other = (AnnotationsSettings)obj;
            if (this.export != other.export) {
                return false;
            }
            if (this.defaultFont == null ? other.defaultFont != null : !this.defaultFont.equals(other.defaultFont)) {
                return false;
            }
            return this.defaultSize == other.defaultSize;
        }

        @Override
        public ExporterSettings clone() {
            try {
                return (ExporterSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

