/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3i;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.StringTag;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.objects.WPObject;

public class Structure
extends AbstractObject
implements Bo2ObjectProvider {
    private final CompoundTag root;
    private final Map<Point3i, Material> blocks;
    private String name;
    private Map<String, Serializable> attributes;
    private final List<Entity> entities;
    private final List<TileEntity> tileEntities;
    public static final AttributeKey<Boolean> ATTRIBUTE_IGNORE_AIR = new AttributeKey("Structure.ignoreAir", (Object)true);
    private static final long serialVersionUID = 1L;

    private Structure(CompoundTag root, String name, Map<Point3i, Material> blocks, List<Entity> entities, List<TileEntity> tileEntities) {
        this.root = root;
        this.name = name;
        this.blocks = blocks;
        this.entities = entities;
        this.tileEntities = tileEntities;
    }

    @Override
    public WPObject getObject() {
        return this;
    }

    @Override
    public List<WPObject> getAllObjects() {
        return Collections.singletonList(this);
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point3i getDimensions() {
        List size = ((ListTag)this.root.getTag("size")).getValue();
        return new Point3i(((IntTag)size.get(0)).getValue(), ((IntTag)size.get(2)).getValue(), ((IntTag)size.get(1)).getValue());
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.blocks.get(new Point3i(x, y, z));
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        if (this.getAttribute(ATTRIBUTE_IGNORE_AIR).booleanValue()) {
            Material material = this.blocks.get(new Point3i(x, y, z));
            return material != null && material != Material.AIR;
        }
        return this.blocks.containsKey(new Point3i(x, y, z));
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(key.key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    @Override
    public Structure clone() {
        Structure clone = (Structure)super.clone();
        if (this.attributes != null) {
            clone.attributes = new HashMap<String, Serializable>(this.attributes);
        }
        return clone;
    }

    public static Structure load(File file) throws IOException {
        String name = file.getName();
        if (name.toLowerCase().endsWith(".nbt")) {
            name = name.substring(0, name.length() - 4).trim();
        }
        Structure structure = Structure.load(name, new FileInputStream(file));
        structure.setAttribute(ATTRIBUTE_FILE, file);
        return structure;
    }

    public static Structure load(String objectName, InputStream inputStream) throws IOException {
        CompoundTag root;
        try (NBTInputStream in = new NBTInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(inputStream)));){
            root = (CompoundTag)in.readTag();
        }
        ListTag paletteTag = (ListTag)root.getTag("palette");
        if (paletteTag == null) {
            throw new IllegalArgumentException("palette tag missing from object " + objectName + " (root tag contents: " + root.getValue() + ")");
        }
        Material[] palette = new Material[paletteTag.getValue().size()];
        for (int i = 0; i < palette.length; ++i) {
            CompoundTag entryTag = (CompoundTag)paletteTag.getValue().get(i);
            String name = ((StringTag)entryTag.getTag("Name")).getValue();
            CompoundTag propertiesTag = (CompoundTag)entryTag.getTag("Properties");
            Map<String, String> properties = propertiesTag != null ? propertiesTag.getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StringTag)entry.getValue()).getValue())) : null;
            palette[i] = Material.get(name, properties);
        }
        HashMap<Point3i, Material> blocks = new HashMap<Point3i, Material>();
        ListTag blocksTag = (ListTag)root.getTag("blocks");
        if (blocksTag == null) {
            throw new IllegalArgumentException("blocks tag missing from object " + objectName + " (root tag contents: " + root.getValue() + ")");
        }
        ArrayList<TileEntity> tileEntities = new ArrayList<TileEntity>();
        for (CompoundTag blockTag : blocksTag.getValue()) {
            List posTags = ((ListTag)blockTag.getTag("pos")).getValue();
            int x = ((IntTag)posTags.get(0)).getValue();
            int y = ((IntTag)posTags.get(2)).getValue();
            int z = ((IntTag)posTags.get(1)).getValue();
            blocks.put(new Point3i(x, y, z), palette[((IntTag)blockTag.getTag("state")).getValue()]);
            CompoundTag nbtTag = (CompoundTag)blockTag.getTag("nbt");
            if (nbtTag == null) continue;
            TileEntity tileEntity = TileEntity.fromNBT(nbtTag);
            tileEntity.setX(x);
            tileEntity.setY(z);
            tileEntity.setZ(y);
            tileEntities.add(tileEntity);
        }
        ListTag entitiesTag = (ListTag)root.getTag("entities");
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (entitiesTag != null) {
            for (CompoundTag entityTag : entitiesTag.getValue()) {
                double[] relPos = null;
                if (entityTag.getTag("pos") instanceof ListTag) {
                    relPos = ((ListTag)entityTag.getTag("pos")).getValue().stream().mapToDouble(DoubleTag::getValue).toArray();
                }
                if (entityTag.getTag("nbt") instanceof CompoundTag) {
                    entityTag = (CompoundTag)entityTag.getTag("nbt");
                }
                entities.add(Entity.fromNBT(entityTag, relPos));
            }
        }
        root.setTag("palette", null);
        root.setTag("blocks", null);
        root.setTag("entities", null);
        return new Structure(root, objectName, blocks, (List<Entity>)(!entities.isEmpty() ? ImmutableList.copyOf(entities) : null), (List<TileEntity>)(!tileEntities.isEmpty() ? ImmutableList.copyOf(tileEntities) : null));
    }
}

