/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3i;
import org.jetbrains.annotations.NotNull;
import org.jnbt.ByteArrayTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.util.DynamicList;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.objects.WPObject;

public final class Schem
extends AbstractNBTItem
implements WPObject {
    private final int width;
    private final int height;
    private final int length;
    private final Material[] palette;
    private final int[] blocks;
    private final List<TileEntity> tileEntities;
    private final List<Entity> entities;
    private String name;
    private Map<String, Serializable> attributes;
    private static final String TAG_WIDTH = "Width";
    private static final String TAG_HEIGHT = "Height";
    private static final String TAG_LENGTH = "Length";
    private static final String TAG_OFFSET = "Offset";
    private static final String TAG_PALETTE = "Palette";
    private static final String TAG_METADATA = "Metadata";
    private static final String TAG_NAME = "Name";
    private static final String TAG_BLOCK_DATA = "BlockData";
    private static final String TAG_BLOCK_ENTITIES = "BlockEntities";
    private static final long serialVersionUID = 1L;

    public Schem(CompoundTag tag, String fallBackName) {
        super(tag);
        int[] schemOffset;
        Point3i offset;
        Object bytes;
        Tag entitiesTag;
        Tag tileEntitiesTag;
        Tag blockDataTag;
        Map paletteMap;
        int version = this.getInt("Version");
        StringTag nameTag = this.getMap(TAG_METADATA) != null ? (StringTag)this.getMap(TAG_METADATA).get(TAG_NAME) : null;
        this.name = nameTag != null ? nameTag.getValue() : fallBackName;
        this.width = this.getShort(TAG_WIDTH);
        this.height = this.getShort(TAG_HEIGHT);
        this.length = this.getShort(TAG_LENGTH);
        switch (version) {
            case 1: {
                paletteMap = this.getMap(TAG_PALETTE);
                blockDataTag = this.getTag(TAG_BLOCK_DATA);
                tileEntitiesTag = this.getTag("TileEntities");
                entitiesTag = null;
                this.removeTag(TAG_PALETTE);
                this.removeTag(TAG_BLOCK_DATA);
                this.removeTag("TileEntities");
                break;
            }
            case 2: {
                paletteMap = this.getMap(TAG_PALETTE);
                blockDataTag = this.getTag(TAG_BLOCK_DATA);
                tileEntitiesTag = this.getTag(TAG_BLOCK_ENTITIES);
                entitiesTag = this.getTag("Entities");
                this.removeTag(TAG_PALETTE);
                this.removeTag(TAG_BLOCK_DATA);
                this.removeTag(TAG_BLOCK_ENTITIES);
                this.removeTag("Entities");
                break;
            }
            case 3: {
                CompoundTag blocksTag = (CompoundTag)this.getTag("Blocks");
                paletteMap = ((CompoundTag)blocksTag.getTag(TAG_PALETTE)).getValue();
                blockDataTag = blocksTag.getTag("Data");
                tileEntitiesTag = blocksTag.getTag(TAG_BLOCK_ENTITIES);
                entitiesTag = this.getTag("Entities");
                this.removeTag("Blocks");
                this.removeTag("Entities");
                break;
            }
            default: {
                throw new IllegalArgumentException("Schem version " + version + " not supported");
            }
        }
        DynamicList paletteList = new DynamicList();
        paletteMap.forEach((arg_0, arg_1) -> this.lambda$new$0((List)paletteList, arg_0, arg_1));
        this.palette = paletteList.toArray(new Material[paletteList.size()]);
        if (blockDataTag instanceof IntArrayTag) {
            this.blocks = ((IntArrayTag)blockDataTag).getValue();
        } else if (blockDataTag instanceof ByteArrayTag) {
            bytes = ((ByteArrayTag)blockDataTag).getValue();
            this.blocks = new int[this.width * this.height * this.length];
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])bytes);
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = this.readVarInt(bais);
            }
        } else {
            throw new IllegalArgumentException("Unsupported tag type for BlockData or Blocks/Data: " + blockDataTag.getClass().getSimpleName());
        }
        if (tileEntitiesTag instanceof ListTag) {
            this.tileEntities = new ArrayList<TileEntity>(((ListTag)tileEntitiesTag).getValue().size());
            bytes = ((ListTag)tileEntitiesTag).getValue().iterator();
            while (bytes.hasNext()) {
                CompoundTag tileEntityTag = (CompoundTag)bytes.next();
                this.tileEntities.add(this.getTileEntity(tileEntityTag));
            }
        } else {
            if (tileEntitiesTag != null) {
                throw new IllegalArgumentException("Unsupported tag type for TileEntities or Blocks/BlockEntities: " + tileEntitiesTag.getClass().getSimpleName());
            }
            this.tileEntities = null;
        }
        if (entitiesTag instanceof ListTag) {
            this.entities = new ArrayList<Entity>(((ListTag)entitiesTag).getValue().size());
            for (CompoundTag entityTag : ((ListTag)entitiesTag).getValue()) {
                this.entities.add(this.getEntity(entityTag, version));
            }
        } else {
            if (entitiesTag != null) {
                throw new IllegalArgumentException("Unsupported tag type for Entities: " + entitiesTag.getClass().getSimpleName());
            }
            this.entities = null;
        }
        if ((offset = (schemOffset = this.getIntArray(TAG_OFFSET)) != null && schemOffset[0] > -this.width && schemOffset[0] <= 0 && schemOffset[2] > -this.length && schemOffset[2] <= 0 && schemOffset[1] > -this.height && schemOffset[1] <= 0 ? new Point3i(schemOffset[0], schemOffset[2], schemOffset[1]) : this.guestimateOffset()) != null && (offset.x != 0 || offset.y != 0 || offset.z != 0)) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(Schem.ATTRIBUTE_OFFSET.key, (Serializable)offset);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point3i getDimensions() {
        return new Point3i(this.width, this.length, this.height);
    }

    @Override
    public Point3i getOffset() {
        return (Point3i)this.getAttribute(ATTRIBUTE_OFFSET);
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.palette[this.blocks[x + y * this.width + z * this.width * this.length]];
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        Material material = this.palette[this.blocks[x + y * this.width + z * this.width * this.length]];
        return material != Material.AIR;
    }

    @Override
    public Set<Material> getAllMaterials() {
        return new HashSet<Material>(Arrays.asList(this.palette));
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public void prepareForExport(Dimension dimension) {
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(key.key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    @Override
    public Schem clone() {
        Schem clone = (Schem)super.clone();
        if (this.attributes != null) {
            clone.attributes = new HashMap<String, Serializable>(this.attributes);
        }
        return clone;
    }

    public static Schem load(File file) throws IOException {
        Schem schem = Schem.load(new FileInputStream(file), file.getName().substring(0, file.getName().lastIndexOf(46)));
        schem.setAttribute(ATTRIBUTE_FILE, file);
        return schem;
    }

    public static Schem load(InputStream stream, String fallBackName) throws IOException {
        try (NBTInputStream in = new NBTInputStream((InputStream)new GZIPInputStream(stream));){
            Schem schem = new Schem((CompoundTag)in.readTag(), fallBackName);
            return schem;
        }
    }

    private Material decodeMaterial(String str) {
        Map<String, String> properties;
        String name;
        int p = str.indexOf(91);
        if (p != -1) {
            name = str.substring(0, p);
            properties = Arrays.stream(str.substring(p + 1, str.length() - 1).split(",")).map(String::trim).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)).trim(), s -> s.substring(s.indexOf(61) + 1).trim()));
        } else {
            name = str;
            properties = null;
        }
        if (name.indexOf(58) == -1) {
            name = "minecraft:" + name;
        }
        return Material.get(name, properties);
    }

    private int readVarInt(InputStream is) {
        try {
            int _byte;
            int i = 0;
            int byteCount = 0;
            do {
                _byte = is.read();
                i |= (_byte & 0x7F) << byteCount++ * 7;
                if (byteCount <= 5) continue;
                throw new MDCCapturingRuntimeException("VarInt too big");
            } while ((_byte & 0x80) == 128);
            return i;
        }
        catch (IOException e) {
            throw new MDCWrappingRuntimeException((Throwable)e);
        }
    }

    @NotNull
    private TileEntity getTileEntity(CompoundTag tileEntityTag) {
        String id = null;
        int x = 0;
        int y = 0;
        int z = 0;
        Iterator i = tileEntityTag.getValue().entrySet().iterator();
        while (i.hasNext()) {
            Tag extraTag = (Tag)i.next().getValue();
            if (extraTag.getName().equals("Id")) {
                id = ((StringTag)extraTag).getValue();
                i.remove();
                continue;
            }
            if (!extraTag.getName().equals("Pos")) continue;
            x = ((IntArrayTag)extraTag).getValue()[0];
            y = ((IntArrayTag)extraTag).getValue()[1];
            z = ((IntArrayTag)extraTag).getValue()[2];
            i.remove();
        }
        tileEntityTag.setTag("id", (Tag)new StringTag("id", id));
        tileEntityTag.setTag("x", (Tag)new IntTag("x", x));
        tileEntityTag.setTag("y", (Tag)new IntTag("y", y));
        tileEntityTag.setTag("z", (Tag)new IntTag("z", z));
        return TileEntity.fromNBT(tileEntityTag);
    }

    private Entity getEntity(CompoundTag entityTag, int version) {
        String id = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        CompoundTag dataTag = null;
        Iterator i = entityTag.getValue().entrySet().iterator();
        while (i.hasNext()) {
            Tag extraTag = (Tag)i.next().getValue();
            if (extraTag.getName().equals("Id")) {
                id = ((StringTag)extraTag).getValue();
                i.remove();
                continue;
            }
            if (extraTag.getName().equals("Pos")) {
                List posTags = ((ListTag)extraTag).getValue();
                x = ((DoubleTag)posTags.get(0)).getValue();
                y = ((DoubleTag)posTags.get(1)).getValue();
                z = ((DoubleTag)posTags.get(2)).getValue();
                i.remove();
                continue;
            }
            if (!extraTag.getName().equals("Data")) continue;
            dataTag = (CompoundTag)extraTag;
        }
        if (version >= 3) {
            dataTag.setTag("id", (Tag)new StringTag("id", id));
            return Entity.fromNBT(dataTag, new double[]{x, y, z});
        }
        entityTag.setTag("id", (Tag)new StringTag("id", id));
        return Entity.fromNBT(entityTag, new double[]{x, y, z});
    }

    private /* synthetic */ void lambda$new$0(List paletteList, String key, Tag value) {
        Material material = this.decodeMaterial(key);
        paletteList.set(((IntTag)value).getValue(), material);
    }
}

