/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.layers.bo2.Bo2BlockSpec;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.objects.WPObject;

public final class Bo2Object
extends AbstractObject
implements Bo2ObjectProvider {
    private String name;
    private final Map<String, String> properties;
    private final Map<Point3i, Bo2BlockSpec> blocks;
    private Point3i origin;
    private Point3i dimensions;
    private Map<String, Serializable> attributes;
    private int version = 2;
    public static final String KEY_SPAWN_WATER = "spawnWater";
    public static final String KEY_SPAWN_LAVA = "spawnLava";
    public static final String KEY_NEEDS_FOUNDATION = "needsFoundation";
    public static final String KEY_RANDOM_ROTATION = "randomRotation";
    private static final long serialVersionUID = 1L;

    private Bo2Object(String name, Map<String, String> properties, Map<Point3i, Bo2BlockSpec> blocks, Point3i origin, Point3i dimensions, Map<String, Serializable> attributes) {
        this.name = name;
        this.properties = properties;
        this.blocks = blocks;
        this.origin = origin;
        this.dimensions = dimensions;
        if (origin.x != 0 || origin.y != 0 || origin.z != 0) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo2Object.ATTRIBUTE_OFFSET.key, (Serializable)new Point3i(-origin.x, -origin.y, -origin.z));
        }
        if (properties.containsKey(KEY_RANDOM_ROTATION) && !Boolean.valueOf(properties.get(KEY_RANDOM_ROTATION)).booleanValue()) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo2Object.ATTRIBUTE_RANDOM_ROTATION.key, Boolean.valueOf(false));
        }
        if (properties.containsKey(KEY_NEEDS_FOUNDATION) && !Boolean.valueOf(properties.get(KEY_NEEDS_FOUNDATION)).booleanValue()) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo2Object.ATTRIBUTE_NEEDS_FOUNDATION.key, Boolean.valueOf(false));
        }
        if (properties.containsKey(KEY_SPAWN_LAVA) && Boolean.valueOf(properties.get(KEY_SPAWN_LAVA)).booleanValue()) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo2Object.ATTRIBUTE_SPAWN_IN_LAVA.key, Boolean.valueOf(true));
        }
        if (properties.containsKey(KEY_SPAWN_WATER) && Boolean.valueOf(properties.get(KEY_SPAWN_WATER)).booleanValue()) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo2Object.ATTRIBUTE_SPAWN_IN_WATER.key, Boolean.valueOf(true));
        }
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.blocks.get(new Point3i(x - this.origin.x, y - this.origin.y, z - this.origin.z)).getMaterial();
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return this.blocks.containsKey(new Point3i(x - this.origin.x, y - this.origin.y, z - this.origin.z));
    }

    @Override
    public Bo2Object getObject() {
        return this;
    }

    @Override
    public List<Entity> getEntities() {
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return null;
    }

    @Override
    public List<WPObject> getAllObjects() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(key.key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public boolean visitBlocks(WPObject.BlockVisitor visitor) {
        for (Map.Entry<Point3i, Bo2BlockSpec> entry : this.blocks.entrySet()) {
            Point3i coords = entry.getKey();
            if (visitor.visitBlock(this, coords.x + this.origin.x, coords.y + this.origin.y, coords.z + this.origin.z, entry.getValue().getMaterial())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Bo2Object clone() {
        Bo2Object clone = (Bo2Object)super.clone();
        clone.origin = (Point3i)this.origin.clone();
        clone.dimensions = (Point3i)this.dimensions.clone();
        if (this.attributes != null) {
            clone.attributes = new HashMap<String, Serializable>(this.attributes);
        }
        return clone;
    }

    public static Bo2Object load(File file) throws IOException {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p != -1) {
            name = name.substring(0, p);
        }
        return Bo2Object.load(name, file);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.version == 0) {
            if (this.origin.x != 0 || this.origin.y != 0 || this.origin.z != 0) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, Serializable>();
                }
                this.attributes.put(Bo2Object.ATTRIBUTE_OFFSET.key, (Serializable)new Point3i(-this.origin.x, -this.origin.y, -this.origin.z));
            }
            if (this.properties.containsKey(KEY_RANDOM_ROTATION) && !Boolean.valueOf(this.properties.get(KEY_RANDOM_ROTATION)).booleanValue()) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, Serializable>();
                }
                this.attributes.put(Bo2Object.ATTRIBUTE_RANDOM_ROTATION.key, Boolean.valueOf(false));
            }
            if (this.properties.containsKey(KEY_NEEDS_FOUNDATION) && !Boolean.valueOf(this.properties.get(KEY_NEEDS_FOUNDATION)).booleanValue()) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, Serializable>();
                }
                this.attributes.put(Bo2Object.ATTRIBUTE_NEEDS_FOUNDATION.key, Boolean.valueOf(false));
            }
            if (this.properties.containsKey(KEY_SPAWN_LAVA) && Boolean.valueOf(this.properties.get(KEY_SPAWN_LAVA)).booleanValue()) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, Serializable>();
                }
                this.attributes.put(Bo2Object.ATTRIBUTE_SPAWN_IN_LAVA.key, Boolean.valueOf(true));
            }
            if (this.properties.containsKey(KEY_SPAWN_WATER) && Boolean.valueOf(this.properties.get(KEY_SPAWN_WATER)).booleanValue()) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, Serializable>();
                }
                this.attributes.put(Bo2Object.ATTRIBUTE_SPAWN_IN_WATER.key, Boolean.valueOf(true));
            }
            this.version = 1;
        }
        if (this.version == 1) {
            if (!this.attributes.containsKey(Bo2Object.ATTRIBUTE_LEAF_DECAY_MODE.key)) {
                this.attributes.put(Bo2Object.ATTRIBUTE_LEAF_DECAY_MODE.key, Integer.valueOf(2));
            }
            this.version = 2;
        }
    }

    public static Bo2Object load(String objectName, File file) throws IOException {
        Bo2Object object = Bo2Object.load(objectName, new FileInputStream(file));
        object.setAttribute(ATTRIBUTE_FILE, file);
        return object;
    }

    public static Bo2Object load(String objectName, InputStream stream) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(stream, StandardCharsets.US_ASCII));){
            String line;
            HashMap<String, String> properties = new HashMap<String, String>();
            HashMap<Point3i, Bo2BlockSpec> blocks = new HashMap<Point3i, Bo2BlockSpec>();
            boolean readingMetaData = false;
            boolean readingData = false;
            int lowestX = Integer.MAX_VALUE;
            int highestX = Integer.MIN_VALUE;
            int lowestY = Integer.MAX_VALUE;
            int highestY = Integer.MIN_VALUE;
            int lowestZ = Integer.MAX_VALUE;
            int highestZ = Integer.MIN_VALUE;
            while ((line = in.readLine()) != null) {
                int p;
                if (line.trim().length() == 0) continue;
                if (readingMetaData) {
                    if (line.equals("[DATA]")) {
                        readingMetaData = false;
                        readingData = true;
                        continue;
                    }
                    p = line.indexOf(61);
                    if (p == -1) {
                        throw new IllegalArgumentException("Invalid metadata line encountered: \"" + line + "\"");
                    }
                    String name = line.substring(0, p).trim();
                    String value = line.substring(p + 1).trim();
                    properties.put(name, value);
                    continue;
                }
                if (readingData) {
                    int blockId;
                    p = line.indexOf(58);
                    String coordinates = line.substring(0, p);
                    String spec = line.substring(p + 1);
                    p = coordinates.indexOf(44);
                    int x = Integer.parseInt(coordinates.substring(0, p));
                    int p2 = coordinates.indexOf(44, p + 1);
                    int y = Integer.parseInt(coordinates.substring(p + 1, p2));
                    int z = Integer.parseInt(coordinates.substring(p2 + 1));
                    if (x < lowestX) {
                        lowestX = x;
                    }
                    if (x > highestX) {
                        highestX = x;
                    }
                    if (y < lowestY) {
                        lowestY = y;
                    }
                    if (y > highestY) {
                        highestY = y;
                    }
                    if (z < lowestZ) {
                        lowestZ = z;
                    }
                    if (z > highestZ) {
                        highestZ = z;
                    }
                    p = spec.indexOf(46);
                    int data = 0;
                    int[] branch = null;
                    if (p == -1) {
                        blockId = Integer.parseInt(spec);
                    } else {
                        blockId = Integer.parseInt(spec.substring(0, p));
                        p2 = spec.indexOf(35, p + 1);
                        if (p2 == -1) {
                            data = Integer.parseInt(spec.substring(p + 1));
                        } else {
                            data = Integer.parseInt(spec.substring(p + 1, p2));
                            p = spec.indexOf(64, p2 + 1);
                            branch = new int[]{Integer.parseInt(spec.substring(p2 + 1, p)), Integer.parseInt(spec.substring(p + 1))};
                        }
                    }
                    Point3i coords = new Point3i(x, y, z);
                    blocks.put(coords, new Bo2BlockSpec(coords, Material.get(blockId, data), branch));
                    continue;
                }
                if (!line.equals("[META]")) continue;
                readingMetaData = true;
            }
            if (blocks.isEmpty()) {
                throw new IOException("No blocks found in the file; is this a bo2 object?");
            }
            Bo2Object bo2Object = new Bo2Object(objectName, properties, blocks, new Point3i(-lowestX, -lowestY, -lowestZ), new Point3i(highestX - lowestX + 1, highestY - lowestY + 1, highestZ - lowestZ + 1), null);
            return bo2Object;
        }
    }
}

