/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.plugins.LayerProvider;
import org.pepsoft.worldpainter.plugins.WPPluginManager;

public final class LayerManager {
    private final List<Layer> layers;
    private final Map<String, Layer> layersByName = new HashMap<String, Layer>();
    private static final LayerManager INSTANCE = new LayerManager();

    private LayerManager() {
        this.layers = new ArrayList<Layer>();
        List<LayerProvider> layerProviders = WPPluginManager.getInstance().getPlugins(LayerProvider.class);
        for (LayerProvider layerProvider : layerProviders) {
            this.layers.addAll(layerProvider.getLayers());
        }
        for (Layer layer : this.layers) {
            this.layersByName.put(layer.getName(), layer);
        }
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public Layer getLayer(String name) {
        return this.layersByName.get(name);
    }

    public static LayerManager getInstance() {
        return INSTANCE;
    }
}

