/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public class TransformingHeightMap
extends DelegatingHeightMap {
    private final int offsetX;
    private final int offsetY;
    private final float scaleX;
    private final float scaleY;
    private final AffineTransform transform;
    private final boolean translateOnly;
    private final float rotation;
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_TRANSFORMING_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/transform.png");

    public TransformingHeightMap(String name, HeightMap baseHeightMap, float scaleX, float scaleY, int offsetX, int offsetY, float rotation) {
        super(new String[]{"baseHeightMap"});
        this.setName(name);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.rotation = rotation;
        if (scaleX == 1.0f && scaleY == 1.0f && rotation == 0.0f) {
            this.translateOnly = true;
            this.transform = null;
        } else {
            this.translateOnly = false;
            this.transform = new AffineTransform();
            if (scaleX != 1.0f || scaleY != 1.0f) {
                this.transform.scale(1.0f / scaleX, 1.0f / scaleY);
            }
            if (offsetX != 0 || offsetY != 0) {
                this.transform.translate(-offsetX, -offsetY);
            }
            if (rotation != 0.0f) {
                this.transform.rotate(-rotation);
            }
        }
        this.setHeightMap(0, baseHeightMap);
    }

    public HeightMap getBaseHeightMap() {
        return this.children[0];
    }

    public void setBaseHeightMap(HeightMap baseHeightMap) {
        this.replace(0, baseHeightMap);
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getRotation() {
        return this.rotation;
    }

    @Override
    public double doGetHeight(int x, int y) {
        if (this.translateOnly) {
            return this.children[0].getHeight(x - this.offsetX, y - this.offsetY);
        }
        Point2D.Float coords = new Point2D.Float(x, y);
        this.transform.transform(coords, coords);
        return this.children[0].getHeight(coords.x, coords.y);
    }

    @Override
    public double doGetHeight(float x, float y) {
        if (this.translateOnly) {
            return this.children[0].getHeight(x - (float)this.offsetX, y - (float)this.offsetY);
        }
        Point2D.Float coords = new Point2D.Float(x, y);
        this.transform.transform(coords, coords);
        return this.children[0].getHeight(coords.x, coords.y);
    }

    @Override
    public int doGetColour(int x, int y) {
        if (this.translateOnly) {
            return this.children[0].getColour(x - this.offsetX, y - this.offsetY);
        }
        Point2D.Float coords = new Point2D.Float(x, y);
        this.transform.transform(coords, coords);
        return this.children[0].getColour(Math.round(coords.x), Math.round(coords.y));
    }

    @Override
    public Rectangle getExtent() {
        Rectangle extent = this.children[0].getExtent();
        if (extent != null) {
            if (this.translateOnly) {
                return new Rectangle(extent.x + this.offsetX, extent.y + this.offsetY, extent.width, extent.height);
            }
            Point2D.Double p1 = new Point2D.Double(extent.getMinX(), extent.getMinY());
            Point2D.Double p2 = new Point2D.Double(extent.getMinX(), extent.getMaxY());
            Point2D.Double p3 = new Point2D.Double(extent.getMaxX(), extent.getMinY());
            Point2D.Double p4 = new Point2D.Double(extent.getMaxX(), extent.getMaxY());
            try {
                this.transform.inverseTransform(p1, p1);
                this.transform.inverseTransform(p2, p2);
                this.transform.inverseTransform(p3, p3);
                this.transform.inverseTransform(p4, p4);
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e);
            }
            double minX = Math.min(Math.min(((Point2D)p1).getX(), ((Point2D)p2).getX()), Math.min(((Point2D)p3).getX(), ((Point2D)p4).getX()));
            double maxX = Math.max(Math.max(((Point2D)p1).getX(), ((Point2D)p2).getX()), Math.max(((Point2D)p3).getX(), ((Point2D)p4).getX()));
            double minY = Math.min(Math.min(((Point2D)p1).getY(), ((Point2D)p2).getY()), Math.min(((Point2D)p3).getY(), ((Point2D)p4).getY()));
            double maxY = Math.max(Math.max(((Point2D)p1).getY(), ((Point2D)p2).getY()), Math.max(((Point2D)p3).getY(), ((Point2D)p4).getY()));
            return new Rectangle((int)minX, (int)minY, (int)Math.ceil(maxX - minX), (int)Math.ceil(maxY - minY));
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return ICON_TRANSFORMING_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return this.children[0].getRange();
    }

    public static TransformingHeightMapBuilder build() {
        return new TransformingHeightMapBuilder();
    }

    public static class TransformingHeightMapBuilder {
        private String name;
        private HeightMap baseHeightMap;
        private int offsetX;
        private int offsetY;
        private float scaleX = 1.0f;
        private float scaleY = 1.0f;
        private float rotation;

        public TransformingHeightMapBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public TransformingHeightMapBuilder withHeightMap(HeightMap baseHeightMap) {
            this.baseHeightMap = baseHeightMap;
            return this;
        }

        public TransformingHeightMapBuilder withOffset(int offsetX, int offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            return this;
        }

        public TransformingHeightMapBuilder withScale(float scale) {
            this.scaleX = scale;
            this.scaleY = scale;
            return this;
        }

        public TransformingHeightMapBuilder withScale(int scaleX, int scaleY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            return this;
        }

        public TransformingHeightMapBuilder withRotation(float rotation) {
            this.rotation = rotation;
            return this;
        }

        public TransformingHeightMap now() {
            return new TransformingHeightMap(this.name, this.baseHeightMap, this.scaleX, this.scaleY, this.offsetX, this.offsetY, this.rotation);
        }
    }
}

