/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.awt.Rectangle;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public class SlopeHeightMap
extends DelegatingHeightMap {
    private float verticalScaling;
    private static final long serialVersionUID = 1L;
    private static final double ROOT_EIGHT = Math.sqrt(8.0);
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;
    private static final Icon ICON_SLOPE_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/integral.png");
    private static final double[] RANGE = new double[]{0.0, 90.0};

    public SlopeHeightMap(HeightMap baseHeightMap) {
        this(baseHeightMap, 1.0f);
    }

    public SlopeHeightMap(HeightMap baseHeightMap, String name) {
        this(baseHeightMap, 1.0f, name);
    }

    public SlopeHeightMap(HeightMap baseHeightMap, float verticalScaling) {
        super(new String[]{"baseHeightMap"});
        this.setName(baseHeightMap.getName() != null ? "Slope of " + baseHeightMap.getName() : null);
        this.verticalScaling = verticalScaling;
        this.setHeightMap(0, baseHeightMap);
    }

    public SlopeHeightMap(HeightMap baseHeightMap, float verticalScaling, String name) {
        super(new String[]{"baseHeightMap"});
        this.setName(name);
        this.verticalScaling = verticalScaling;
        this.setHeightMap(0, baseHeightMap);
    }

    public HeightMap getBaseHeightMap() {
        return this.children[0];
    }

    public void setBaseHeightMap(HeightMap baseHeightMap) {
        this.replace(0, baseHeightMap);
    }

    public float getVerticalScaling() {
        return this.verticalScaling;
    }

    public void setVerticalScaling(float verticalScaling) {
        this.verticalScaling = verticalScaling;
    }

    @Override
    protected double doGetHeight(float x, float y) {
        HeightMap baseHeightMap = this.children[0];
        if (this.verticalScaling != 1.0f) {
            return Math.tan(Math.max(Math.max(Math.abs(baseHeightMap.getHeight(x + 1.0f, y) / (double)this.verticalScaling - baseHeightMap.getHeight(x - 1.0f, y) / (double)this.verticalScaling) / 2.0, Math.abs(baseHeightMap.getHeight(x + 1.0f, y + 1.0f) / (double)this.verticalScaling - baseHeightMap.getHeight(x - 1.0f, y - 1.0f) / (double)this.verticalScaling) / ROOT_EIGHT), Math.max(Math.abs(baseHeightMap.getHeight(x, y + 1.0f) / (double)this.verticalScaling - baseHeightMap.getHeight(x, y - 1.0f) / (double)this.verticalScaling) / 2.0, Math.abs(baseHeightMap.getHeight(x - 1.0f, y + 1.0f) / (double)this.verticalScaling - baseHeightMap.getHeight(x + 1.0f, y - 1.0f) / (double)this.verticalScaling) / ROOT_EIGHT))) * 57.29577951308232;
        }
        return Math.tan(Math.max(Math.max(Math.abs(baseHeightMap.getHeight(x + 1.0f, y) / (double)this.verticalScaling - baseHeightMap.getHeight(x - 1.0f, y)) / 2.0, Math.abs(baseHeightMap.getHeight(x + 1.0f, y + 1.0f) - baseHeightMap.getHeight(x - 1.0f, y - 1.0f)) / ROOT_EIGHT), Math.max(Math.abs(baseHeightMap.getHeight(x, y + 1.0f) - baseHeightMap.getHeight(x, y - 1.0f)) / 2.0, Math.abs(baseHeightMap.getHeight(x - 1.0f, y + 1.0f) - baseHeightMap.getHeight(x + 1.0f, y - 1.0f)) / ROOT_EIGHT))) * 57.29577951308232;
    }

    @Override
    public Rectangle getExtent() {
        return this.children[0].getExtent();
    }

    @Override
    public SlopeHeightMap clone() {
        return new SlopeHeightMap(this.children[0].clone(), this.name);
    }

    @Override
    public Icon getIcon() {
        return ICON_SLOPE_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return RANGE;
    }
}

