/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.CombiningHeightMap;

public class ProductHeightMap
extends CombiningHeightMap {
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_PRODUCT_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/times.png");

    public ProductHeightMap(HeightMap heightMap1, HeightMap heightMap2) {
        super(heightMap1, heightMap2);
    }

    public ProductHeightMap(String name, HeightMap heightMap1, HeightMap heightMap2) {
        super(name, heightMap1, heightMap2);
    }

    @Override
    public double doGetHeight(int x, int y) {
        double height1 = this.children[0].getHeight(x, y);
        return height1 == 0.0 ? 0.0 : height1 * this.children[1].getHeight(x, y);
    }

    @Override
    public double doGetHeight(float x, float y) {
        double height1 = this.children[0].getHeight(x, y);
        return height1 == 0.0 ? 0.0 : height1 * this.children[1].getHeight(x, y);
    }

    @Override
    public ProductHeightMap clone() {
        ProductHeightMap clone = new ProductHeightMap(this.name, this.children[0].clone(), this.children[1].clone());
        clone.setSeed(this.getSeed());
        return clone;
    }

    @Override
    public Icon getIcon() {
        return ICON_PRODUCT_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        double[] range0 = this.children[0].getRange();
        double[] range1 = this.children[1].getRange();
        return new double[]{range0[0] * range1[0], range0[1] * range1[1]};
    }
}

