/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public final class NinePatchHeightMap
extends AbstractHeightMap {
    private final int innerSizeX;
    private final int innerSizeY;
    private final int borderSize;
    private final int coastSize;
    private final int borderTotalX;
    private final int borderTotalY;
    private final int coastTotalX;
    private final int coastTotalY;
    private final double height;
    private final double halfHeight;
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_NINE_PATCH_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/nine_patch.png");

    public NinePatchHeightMap(int innerRadius, int coastSize, double height) {
        this(null, 0, innerRadius, coastSize, height);
    }

    public NinePatchHeightMap(int innerSize, int borderSize, int coastSize, double height) {
        this(null, innerSize, borderSize, coastSize, height);
    }

    public NinePatchHeightMap(String name, int innerRadius, int coastSize, double height) {
        this(name, 0, innerRadius, coastSize, height);
    }

    public NinePatchHeightMap(String name, int innerSize, int borderSize, int coastSize, double height) {
        super(name);
        if (innerSize < 0 || borderSize < 0 || coastSize < 0 || height <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (innerSize == 0 && borderSize == 0 && coastSize == 0) {
            throw new IllegalArgumentException();
        }
        this.innerSizeX = innerSize;
        this.innerSizeY = innerSize;
        this.borderSize = borderSize;
        this.coastSize = coastSize;
        this.height = height;
        this.halfHeight = this.height / 2.0;
        this.borderTotalX = this.innerSizeX + this.borderSize;
        this.borderTotalY = this.innerSizeY + this.borderSize;
        this.coastTotalX = this.borderTotalX + this.coastSize;
        this.coastTotalY = this.borderTotalY + this.coastSize;
    }

    public int getInnerSizeX() {
        return this.innerSizeX;
    }

    public int getInnerSizeY() {
        return this.innerSizeY;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public int getCoastSize() {
        return this.coastSize;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public double getHeight(float x, float y) {
        x = Math.abs(x);
        y = Math.abs(y);
        if (x < (float)this.innerSizeX) {
            if (y < (float)this.innerSizeY) {
                return this.height;
            }
            if (y < (float)this.borderTotalY) {
                return this.height;
            }
            if (y < (float)this.coastTotalY) {
                return Math.cos((double)((y - (float)this.borderTotalY) / (float)this.coastSize) * Math.PI) * this.halfHeight + this.halfHeight;
            }
            return 0.0;
        }
        if (x < (float)this.borderTotalX) {
            if (y < (float)this.innerSizeY) {
                return this.height;
            }
            if (y < (float)this.coastTotalY) {
                float distanceFromCorner = MathUtils.getDistance((float)(x - (float)this.innerSizeX), (float)(y - (float)this.innerSizeY));
                if (distanceFromCorner < (float)this.borderSize) {
                    return this.height;
                }
                if (distanceFromCorner - (float)this.borderSize < (float)this.coastSize) {
                    return Math.cos((double)((distanceFromCorner - (float)this.borderSize) / (float)this.coastSize) * Math.PI) * this.halfHeight + this.halfHeight;
                }
                return 0.0;
            }
            return 0.0;
        }
        if (x < (float)this.coastTotalX) {
            if (y < (float)this.innerSizeY) {
                return Math.cos((double)((x - (float)this.borderTotalX) / (float)this.coastSize) * Math.PI) * this.halfHeight + this.halfHeight;
            }
            if (y < (float)this.coastTotalY) {
                float distanceFromCorner = MathUtils.getDistance((float)(x - (float)this.innerSizeX), (float)(y - (float)this.innerSizeY));
                if (distanceFromCorner < (float)this.borderSize) {
                    return this.height;
                }
                if (distanceFromCorner - (float)this.borderSize < (float)this.coastSize) {
                    return Math.cos((double)((distanceFromCorner - (float)this.borderSize) / (float)this.coastSize) * Math.PI) * this.halfHeight + this.halfHeight;
                }
                return 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public Icon getIcon() {
        return ICON_NINE_PATCH_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return new double[]{0.0, this.height};
    }
}

