/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public final class ConstantHeightMap
extends AbstractHeightMap {
    private float height;
    private double dHeight;
    private int version = 1;
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_CONSTANT_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/x.png");

    public ConstantHeightMap(double height) {
        this.dHeight = height;
    }

    public ConstantHeightMap(String name, double height) {
        super(name);
        this.dHeight = height;
    }

    public double getHeight() {
        return this.dHeight;
    }

    @Override
    public double getHeight(int x, int y) {
        return this.dHeight;
    }

    @Override
    public double getHeight(float x, float y) {
        return this.dHeight;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public double getConstantValue() {
        return this.dHeight;
    }

    @Override
    public Icon getIcon() {
        return ICON_CONSTANT_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return new double[]{this.dHeight, this.dHeight};
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.version == 0) {
            this.dHeight = this.height;
            this.height = 0.0f;
            this.version = 1;
        }
    }
}

