/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.plants.Plants;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.BlockBasedPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldPainterChunkFactory
implements ChunkFactory {
    private final Platform platform;
    private final BlockBasedPlatformProvider platformProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int subSurfacePatternHeight;
    private final int maxY;
    private final int defaultBiome;
    private final Dimension dimension;
    private final Set<Layer> minimumLayers;
    private final PerlinNoise sugarCaneNoise = new PerlinNoise(0L);
    private final Map<Layer, LayerExporter> exporters;
    private final long seed;
    private final Terrain subsurfaceMaterial;
    private final boolean bedrock;
    private final boolean coverSteepTerrain;
    private final boolean topLayersRelativeToTerrain;
    private final boolean subSurfaceLayersRelativeToTerrain;
    private final boolean biomesSupported2D;
    private final boolean biomesSupported3D;
    private final boolean biomesSupportedNamed;
    private final boolean copyBiomes;
    private final Dimension.WallType roofType;
    private static final long SUGAR_CANE_SEED_OFFSET = 127411424L;
    private static final float SUGAR_CANE_CHANCE = PerlinNoise.getLevelForPromillage((int)325);
    private static final Logger logger = LoggerFactory.getLogger(WorldPainterChunkFactory.class);

    public WorldPainterChunkFactory(Dimension dimension, Map<Layer, LayerExporter> exporters, Platform platform, int maxHeightConstraint) {
        this.dimension = dimension;
        this.exporters = exporters;
        this.platform = platform;
        this.platformProvider = (BlockBasedPlatformProvider)PlatformManager.getInstance().getPlatformProvider(platform);
        this.minHeight = dimension.getMinHeight();
        this.maxHeight = Math.min(maxHeightConstraint, dimension.getMaxHeight());
        this.minimumLayers = dimension.getMinimumLayers();
        this.seed = dimension.getSeed();
        if (this.sugarCaneNoise.getSeed() != this.seed + 127411424L) {
            this.sugarCaneNoise.setSeed(this.seed + 127411424L);
        }
        this.subsurfaceMaterial = dimension.getSubsurfaceMaterial();
        this.roofType = dimension.getRoofType();
        this.bedrock = !dimension.isBottomless();
        this.coverSteepTerrain = dimension.isCoverSteepTerrain();
        this.topLayersRelativeToTerrain = dimension.getTopLayerAnchor() == Dimension.LayerAnchor.TERRAIN;
        this.subSurfaceLayersRelativeToTerrain = this.subsurfaceMaterial.isCustom() && Terrain.getCustomMaterial(this.subsurfaceMaterial.getCustomTerrainIndex()).getMode() == MixedMaterial.Mode.LAYERED && dimension.getSubsurfaceLayerAnchor() == Dimension.LayerAnchor.TERRAIN;
        this.subSurfacePatternHeight = this.subSurfaceLayersRelativeToTerrain ? Terrain.getCustomMaterial(this.subsurfaceMaterial.getCustomTerrainIndex()).getPatternHeight() : -1;
        this.maxY = this.maxHeight - 1;
        this.biomesSupported2D = platform.capabilities.contains((Object)Platform.Capability.BIOMES);
        this.biomesSupported3D = platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D);
        this.biomesSupportedNamed = platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES);
        this.copyBiomes = (this.biomesSupported2D || this.biomesSupported3D || this.biomesSupportedNamed) && !dimension.getAnchor().invert;
        switch (dimension.getAnchor().dim) {
            case 0: {
                this.defaultBiome = 1;
                break;
            }
            case 1: {
                this.defaultBiome = 8;
                break;
            }
            case 2: {
                this.defaultBiome = 9;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public ChunkFactory.ChunkCreationResult createChunk(int chunkX, int chunkZ) {
        Tile tile = this.dimension.getTile(chunkX >> 3, chunkZ >> 3);
        if (tile != null) {
            return this.createChunk(tile, chunkX, chunkZ);
        }
        return null;
    }

    public ChunkFactory.ChunkCreationResult createChunk(Tile tile, int chunkX, int chunkZ) {
        Chunk chunk;
        if (tile.getBitLayerValue(ReadOnly.INSTANCE, chunkX << 4 & 0x7F, chunkZ << 4 & 0x7F) || tile.getBitLayerValue(NotPresent.INSTANCE, chunkX << 4 & 0x7F, chunkZ << 4 & 0x7F)) {
            return null;
        }
        int tileX = tile.getX();
        int tileY = tile.getY();
        int xOffsetInTile = (chunkX & 7) << 4;
        int yOffsetInTile = (chunkZ & 7) << 4;
        Random random = new Random(this.seed + (long)(xOffsetInTile * 3) + (long)(yOffsetInTile * 5));
        boolean populate = this.platform.capabilities.contains((Object)Platform.Capability.POPULATE) && (this.dimension.isPopulate() || tile.getBitLayerValue(Populate.INSTANCE, xOffsetInTile, yOffsetInTile));
        BiomeUtils biomeUtils = new BiomeUtils(this.dimension);
        ChunkFactory.ChunkCreationResult result = new ChunkFactory.ChunkCreationResult();
        result.chunk = chunk = this.platformProvider.createChunk(this.platform, chunkX, chunkZ, this.minHeight, this.maxHeight);
        if (this.copyBiomes && (this.biomesSupported3D || this.biomesSupportedNamed)) {
            int chunkXInWorld = tileX << 7 | xOffsetInTile;
            int chunkZInWorld = tileY << 7 | yOffsetInTile;
            for (int x = 0; x < 16; x += 4) {
                for (int z = 0; z < 16; z += 4) {
                    int biome = this.dimension.getMostPrevalentBiome((chunkXInWorld | x) >> 2, (chunkZInWorld | z) >> 2, this.defaultBiome);
                    biomeUtils.set2DBiome(chunk, x, z, biome);
                }
            }
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xInTile = xOffsetInTile | x;
                int yInTile = yOffsetInTile | z;
                int worldX = tileX << 7 | xInTile;
                int worldY = tileY << 7 | yInTile;
                if (this.copyBiomes && this.biomesSupported2D) {
                    int biome = this.dimension.getLayerValueAt(Biome.INSTANCE, worldX, worldY);
                    if (biome == 255 && ((biome = this.dimension.getAutoBiome(tile, xInTile, yInTile)) < 0 || biome > 255)) {
                        biome = this.defaultBiome;
                    }
                    biomeUtils.set2DBiome(chunk, x, z, biome);
                }
                int intHeight = tile.getIntHeight(xInTile, yInTile);
                int waterLevel = tile.getWaterLevel(xInTile, yInTile);
                boolean underWater = waterLevel > intHeight;
                boolean _void = tile.getBitLayerValue(Void.INSTANCE, xInTile, yInTile);
                if (!_void) {
                    WPObject object;
                    boolean floodWithLava;
                    Terrain terrain = tile.getTerrain(xInTile, yInTile);
                    if (underWater) {
                        floodWithLava = tile.getBitLayerValue(FloodWithLava.INSTANCE, xInTile, yInTile);
                        ++result.stats.waterArea;
                    } else {
                        floodWithLava = false;
                        ++result.stats.landArea;
                    }
                    if (this.bedrock) {
                        chunk.setMaterial(x, this.minHeight, z, Material.BEDROCK);
                    }
                    this.applySubSurface(tile, chunk, xInTile, yInTile);
                    this.applyTopLayer(tile, chunk, xInTile, yInTile, false);
                    if (!underWater) {
                        object = null;
                        if ((terrain == Terrain.GRASS || terrain == Terrain.DESERT || terrain == Terrain.RED_DESERT || terrain == Terrain.BEACHES) && this.sugarCaneNoise.getPerlinNoise((double)((float)worldX / 4.099f), (double)((float)worldY / 4.099f), (double)((float)z / 4.099f)) * this.sugarCaneNoise.getPerlinNoise((double)((float)worldX / 16.411f), (double)((float)worldY / 16.411f), (double)((float)z / 16.411f)) > SUGAR_CANE_CHANCE && (this.isAdjacentWater(tile, intHeight, xInTile - 1, yInTile) || this.isAdjacentWater(tile, intHeight, xInTile + 1, yInTile) || this.isAdjacentWater(tile, intHeight, xInTile, yInTile - 1) || this.isAdjacentWater(tile, intHeight, xInTile, yInTile + 1))) {
                            int blockTypeBelow = chunk.getBlockType(x, intHeight, z);
                            if (random.nextInt(5) > 0 && (blockTypeBelow == 2 || blockTypeBelow == 3 || blockTypeBelow == 12 || blockTypeBelow == 83)) {
                                object = Plants.SUGAR_CANE.realise(random.nextInt(3) + 1, this.platform);
                            }
                        }
                        if (object == null) {
                            object = terrain.getSurfaceObject(this.platform, this.seed, worldX, worldY, 0);
                        }
                        if (object != null) {
                            this.renderObject(chunk, object, x, intHeight + 1, z);
                        }
                    } else if (!floodWithLava && (object = terrain.getSurfaceObject(this.platform, this.seed, worldX, worldY, waterLevel - intHeight)) != null) {
                        this.renderObject(chunk, object, x, intHeight + 1, z);
                    }
                }
                if (this.roofType != null) {
                    chunk.setMaterial(x, this.maxY, z, this.roofType == Dimension.WallType.BEDROCK ? Material.BEDROCK : Material.BARRIER);
                    chunk.setHeight(x, z, this.maxY);
                    continue;
                }
                if (_void) {
                    chunk.setHeight(x, z, this.minHeight);
                    continue;
                }
                if (underWater) {
                    chunk.setHeight(x, z, waterLevel < this.maxY ? waterLevel + 1 : this.maxY);
                    continue;
                }
                chunk.setHeight(x, z, intHeight < this.maxY ? intHeight + 1 : this.maxY);
            }
        }
        chunk.setTerrainPopulated(!populate);
        for (Layer layer : tile.getLayers(this.minimumLayers)) {
            LayerExporter layerExporter = this.exporters.get(layer);
            if (!(layerExporter instanceof FirstPassLayerExporter)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Exporting layer {} for chunk {},{}", new Object[]{layer, chunkX, chunkZ});
            }
            ((FirstPassLayerExporter)layerExporter).render(tile, chunk);
        }
        result.stats.surfaceArea = 256L;
        return result;
    }

    public void applyTopLayer(Tile tile, Chunk chunk, int xInTile, int yInTile, boolean onlyWhereSolid) {
        Terrain terrain = tile.getTerrain(xInTile, yInTile);
        int worldX = tile.getX() << 7 | xInTile;
        int worldY = tile.getY() << 7 | yInTile;
        int x = xInTile & 0xF;
        int z = yInTile & 0xF;
        float height = tile.getHeight(xInTile, yInTile);
        int intHeight = Math.round(height);
        int waterLevel = tile.getWaterLevel(xInTile, yInTile);
        int topLayerDepth = this.dimension.getTopLayerDepth(worldX, worldY, intHeight);
        boolean underWater = waterLevel > intHeight;
        int topLayerLayerOffset = this.topLayersRelativeToTerrain && terrain.isCustom() && Terrain.getCustomMaterial(terrain.getCustomTerrainIndex()).getMode() == MixedMaterial.Mode.LAYERED ? -(intHeight - Terrain.getCustomMaterial(terrain.getCustomTerrainIndex()).getPatternHeight() + 1) : 0;
        boolean floodWithLava = underWater ? tile.getBitLayerValue(FloodWithLava.INSTANCE, xInTile, yInTile) : false;
        int subsurfaceMaxHeight = intHeight - topLayerDepth;
        if (this.coverSteepTerrain) {
            subsurfaceMaxHeight = Math.min(subsurfaceMaxHeight, Math.min(Math.min(this.dimension.getIntHeightAt(worldX - 1, worldY, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX + 1, worldY, Integer.MAX_VALUE)), Math.min(this.dimension.getIntHeightAt(worldX, worldY - 1, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX, worldY + 1, Integer.MAX_VALUE))));
        }
        int columnRenderHeight = Math.min(Math.max(intHeight, waterLevel), this.maxY);
        for (int y = Math.max(subsurfaceMaxHeight + 1, this.minHeight + (this.bedrock ? 1 : 0)); y <= columnRenderHeight; ++y) {
            if (onlyWhereSolid && !chunk.getMaterial((int)x, (int)y, (int)z).solid) continue;
            if (y < intHeight) {
                chunk.setMaterial(x, y, z, terrain.getMaterial(this.platform, this.seed, worldX, worldY, y + topLayerLayerOffset, intHeight + topLayerLayerOffset));
                continue;
            }
            if (y == intHeight) {
                Material material = topLayerLayerOffset != 0 ? terrain.getMaterial(this.platform, this.seed, worldX, worldY, intHeight + topLayerLayerOffset, intHeight + topLayerLayerOffset) : terrain.getMaterial(this.platform, this.seed, worldX, worldY, height + (float)topLayerLayerOffset, intHeight + topLayerLayerOffset);
                int blockType = material.blockType;
                if ((blockType == 126 || blockType == 44 || blockType == 182) && !underWater && height > (float)intHeight) {
                    chunk.setMaterial(x, y, z, Material.get(blockType - 1, material.data));
                    continue;
                }
                chunk.setMaterial(x, y, z, material);
                continue;
            }
            if (y > waterLevel) continue;
            if (floodWithLava) {
                chunk.setMaterial(x, y, z, Material.STATIONARY_LAVA);
                continue;
            }
            chunk.setMaterial(x, y, z, Material.STATIONARY_WATER);
        }
    }

    public void applySubSurface(Tile tile, Chunk chunk, int xInTile, int yInTile) {
        int worldX = tile.getX() << 7 | xInTile;
        int worldY = tile.getY() << 7 | yInTile;
        int x = xInTile & 0xF;
        int z = yInTile & 0xF;
        int intHeight = tile.getIntHeight(xInTile, yInTile);
        int topLayerDepth = this.dimension.getTopLayerDepth(worldX, worldY, intHeight);
        int subSurfaceLayerOffset = this.subSurfaceLayersRelativeToTerrain ? -(intHeight - this.subSurfacePatternHeight + 1) : 0;
        int subsurfaceMaxHeight = intHeight - topLayerDepth;
        if (this.coverSteepTerrain) {
            subsurfaceMaxHeight = Math.min(subsurfaceMaxHeight, Math.min(Math.min(this.dimension.getIntHeightAt(worldX - 1, worldY, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX + 1, worldY, Integer.MAX_VALUE)), Math.min(this.dimension.getIntHeightAt(worldX, worldY - 1, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX, worldY + 1, Integer.MAX_VALUE))));
        }
        for (int y = this.minHeight + (this.bedrock ? 1 : 0); y <= subsurfaceMaxHeight; ++y) {
            chunk.setMaterial(x, y, z, this.subsurfaceMaterial.getMaterial(this.platform, this.seed, worldX, worldY, y + subSurfaceLayerOffset, intHeight + subSurfaceLayerOffset));
        }
    }

    private void renderObject(Chunk chunk, WPObject object, int x, int y, int z) {
        int height = object.getDimensions().z;
        if (y < this.minHeight || y + height >= this.maxHeight) {
            return;
        }
        for (int dy = 0; dy < height; ++dy) {
            if (y + dy < this.minHeight || y + dy >= this.maxHeight || !object.getMask(0, 0, dy)) continue;
            Material objectMaterial = object.getMaterial(0, 0, dy);
            Material existingMaterial = chunk.getMaterial(x, y + dy, z);
            if (existingMaterial.isNamed("minecraft:water")) {
                if (objectMaterial.containsWater()) {
                    chunk.setMaterial(x, y + dy, z, objectMaterial);
                    continue;
                }
                if (!objectMaterial.hasProperty(Material.WATERLOGGED)) continue;
                chunk.setMaterial(x, y + dy, z, objectMaterial.withProperty(Material.WATERLOGGED, true));
                continue;
            }
            chunk.setMaterial(x, y + dy, z, objectMaterial);
        }
    }

    private boolean isAdjacentWater(Tile tile, int height, int x, int y) {
        if (x < 0 || x >= 128 || y < 0 || y >= 128) {
            return false;
        }
        return tile.getWaterLevel(x, y) == height && !tile.getBitLayerValue(FloodWithLava.INSTANCE, x, y) && !tile.getBitLayerValue(Frost.INSTANCE, x, y) && tile.getIntHeight(x, y) < height;
    }
}

