/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class WallChunk {
    public static ChunkFactory.ChunkCreationResult create(int chunkX, int chunkZ, Dimension dimension, Platform platform) {
        int minHeight = dimension.getMinHeight();
        int maxHeight = dimension.getMaxHeight();
        BiomeUtils biomeUtils = new BiomeUtils();
        ChunkFactory.ChunkCreationResult result = new ChunkFactory.ChunkCreationResult();
        result.chunk = PlatformManager.getInstance().createChunk(platform, chunkX, chunkZ, minHeight, maxHeight);
        int maxY = maxHeight - 1;
        Material wallMaterial = dimension.getWallType() == Dimension.WallType.BEDROCK ? Material.BEDROCK : Material.BARRIER;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (platform.supportsBiomes()) {
                    biomeUtils.set2DBiome(result.chunk, x, z, 1);
                }
                for (int y = minHeight; y <= maxY; ++y) {
                    result.chunk.setMaterial(x, y, z, wallMaterial);
                }
                result.chunk.setHeight(x, z, maxY);
            }
        }
        result.chunk.setTerrainPopulated(true);
        result.stats.landArea = 0L;
        result.stats.surfaceArea = 256L;
        result.stats.waterArea = 0L;
        return result;
    }
}

