/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import com.google.common.collect.ImmutableSet;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jnbt.NBTInputStream;
import org.jnbt.NBTOutputStream;
import org.jnbt.Tag;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.NBTChunk;
import org.pepsoft.minecraft.NBTItem;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.mdc.MDCThreadPoolExecutor;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.platforms.JavaPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaChunkStore
implements ChunkStore {
    private final Platform platform;
    private final JavaPlatformProvider platformProvider;
    private final File regionDir;
    private final Map<RegionKey, RegionFile> regionFiles = new HashMap<RegionKey, RegionFile>();
    private final int minHeight;
    private final int maxHeight;
    private final Set<DataType> dataTypes;
    private static final Logger logger = LoggerFactory.getLogger(JavaChunkStore.class);

    public JavaChunkStore(Platform platform, File regionDir, int minHeight, int maxHeight) {
        this.platform = platform;
        this.regionDir = regionDir;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.platformProvider = (JavaPlatformProvider)PlatformManager.getInstance().getPlatformProvider(platform);
        if (!DefaultPlugin.DEFAULT_JAVA_PLATFORMS.contains(platform)) {
            throw new IllegalArgumentException("Unsupported platform " + platform);
        }
        this.dataTypes = ImmutableSet.copyOf(this.platformProvider.getDataTypes(platform));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visitRegions(RegionVisitor visitor, boolean readOnly, String operation, Set<DataType> dataTypes) throws IOException {
        block17: {
            this.flush();
            regionFilePattern = this.platform == DefaultPlugin.JAVA_MCREGION ? Pattern.compile("r\\.(-?\\d+)\\.(-?\\d+)\\.mcr") : Pattern.compile("r\\.(-?\\d+)\\.(-?\\d+)\\.mca");
            files = Objects.requireNonNull(this.regionDir.listFiles((FilenameFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;Ljava/lang/String;)Z, lambda$visitRegions$0(java.util.regex.Pattern boolean java.io.File java.lang.String ), (Ljava/io/File;Ljava/lang/String;)Z)((Pattern)regionFilePattern, (boolean)readOnly)));
            start = System.currentTimeMillis();
            if (!readOnly || files.length <= 1 || "1".equals(System.getProperty("org.pepsoft.worldpainter.threads"))) break block17;
            var9_8 = this.visitRegionsInParallel(files, regionFilePattern, visitor, operation);
            JavaChunkStore.logger.debug("Visiting {} regions for {} took {} ms", new Object[]{files.length, operation, System.currentTimeMillis() - start});
            return var9_8;
        }
        try {
            var9_9 = Objects.requireNonNull(files);
            var10_11 = var9_9.length;
            var11_12 = 0;
            while (true) {
                if (var11_12 >= var10_11) ** GOTO lbl-1000
                file = var9_9[var11_12];
                matcher = regionFilePattern.matcher(file.getName());
                if (!matcher.matches()) ** GOTO lbl69
                regionFilesToVisit = new HashMap<DataType, RegionFile>();
                coords = new Point(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
                var16_17 = dataTypes.iterator();
                ** GOTO lbl27
lbl-1000:
                // 1 sources

                {
                    var9_10 = true;
                    JavaChunkStore.logger.debug("Visiting {} regions for {} took {} ms", new Object[]{files.length, operation, System.currentTimeMillis() - start});
                    return var9_10;
lbl27:
                    // 4 sources

                    while (var16_17.hasNext()) {
                        var17_22 = var16_17.next();
                        var18_25 = new RegionKey(var17_22, coords);
                        if (this.regionFiles.containsKey(var18_25)) {
                            regionFilesToVisit.put(var17_22, this.regionFiles.get(var18_25));
                            continue;
                        }
                        regionFile = var17_22 == DataType.REGION ? new RegionFile(file, readOnly) : this.platformProvider.getRegionFile(this.platform, this.regionDir, var17_22, coords, readOnly);
                        if (regionFile == null) continue;
                        this.regionFiles.put(var18_25, regionFile);
                        regionFilesToVisit.put(var17_22, regionFile);
                    }
                    try {
                        if (!visitor.visitRegion(regionFilesToVisit)) {
                            var16_18 = false;
                            return var16_18;
                        }
                        ** try [egrp 3[TRYBLOCK] [6 : 519->735)] { 
                    }
                    catch (RuntimeException e) {
                        throw e;
                        catch (Exception e) {
                            throw new MDCCapturingRuntimeException("Checked exception visiting region file " + file, (Throwable)e);
                        }
                    }
                    finally {
                        var21_30 = regionFilesToVisit.entrySet().iterator();
                        while (true) {
                            if (!var21_30.hasNext()) {
                            }
                            entry = var21_30.next();
                            ((RegionFile)entry.getValue()).close();
                            this.regionFiles.remove(new RegionKey((DataType)entry.getKey(), coords));
                        }
                    }
lbl46:
                    // 2 sources

                    for (Map.Entry var17_24 : regionFilesToVisit.entrySet()) {
                        ((RegionFile)var17_24.getValue()).close();
                        this.regionFiles.remove(new RegionKey((DataType)var17_24.getKey(), coords));
                    }
                    ++var11_12;
                    continue;
                }
                break;
            }
        }
lbl72:
        // 3 sources

        catch (Throwable var23_32) {
            JavaChunkStore.logger.debug("Visiting {} regions for {} took {} ms", new Object[]{files.length, operation, System.currentTimeMillis() - start});
            throw var23_32;
        }
    }

    @Override
    public int getChunkCount() {
        AtomicInteger chunkCount = new AtomicInteger();
        try {
            this.visitRegions(regions -> {
                chunkCount.addAndGet(((RegionFile)regions.get((Object)DataType.REGION)).getChunkCount());
                return true;
            }, true, "counting chunks", Collections.singleton(DataType.REGION));
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while visiting regions of " + this.regionDir, e);
        }
        return chunkCount.get();
    }

    @Override
    public Set<MinecraftCoords> getChunkCoords() {
        Set<MinecraftCoords> coords = Collections.synchronizedSet(new HashSet());
        try {
            this.visitRegions(regions -> {
                RegionFile regionFile = (RegionFile)regions.get((Object)DataType.REGION);
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        if (!regionFile.containsChunk(x, z)) continue;
                        coords.add(new MinecraftCoords(regionFile.getX() * 32 + x, regionFile.getZ() * 32 + z));
                    }
                }
                return true;
            }, true, "collecting chunk coordinates", Collections.singleton(DataType.REGION));
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while visiting regions of " + this.regionDir, e);
        }
        return coords;
    }

    @Override
    public boolean visitChunks(ChunkStore.ChunkVisitor visitor) {
        return this.visitChunks(visitor, true, "visiting chunks", this.dataTypes);
    }

    @Override
    public boolean visitChunksForEditing(ChunkStore.ChunkVisitor visitor) {
        return this.visitChunks(visitor, false, "modifying chunks", this.dataTypes);
    }

    @Override
    public void saveChunk(Chunk chunk) {
        int x = chunk.getxPos();
        int z = chunk.getzPos();
        Map<DataType, ? extends Tag> tags = ((NBTItem)((Object)chunk)).toMultipleNBT();
        this.platformProvider.getDataTypes(this.platform).forEach(type -> {
            block16: {
                try {
                    if (tags.containsKey(type)) {
                        RegionFile regionFile = this.getOrCreateRegionFile(new Point(x >> 5, z >> 5), (DataType)((Object)type));
                        try (NBTOutputStream out = new NBTOutputStream((OutputStream)regionFile.getChunkDataOutputStream(x & 0x1F, z & 0x1F));){
                            out.writeTag((Tag)tags.get(type));
                            break block16;
                        }
                    }
                    RegionFile regionFile = this.getRegionFile(new Point(x >> 5, z >> 5), (DataType)((Object)type));
                    if (regionFile != null && regionFile.containsChunk(x & 0x1F, z & 0x1F)) {
                        regionFile.delete(x & 0x1F, z & 0x1F);
                    }
                }
                catch (IOException e) {
                    throw new MDCCapturingRuntimeException("I/O error saving chunk @" + x + "," + z + " to region of type " + (Object)type, (Throwable)e);
                }
            }
        });
    }

    @Override
    public void doInTransaction(Runnable task) {
        task.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Map<RegionKey, RegionFile> map = this.regionFiles;
        synchronized (map) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing " + this.regionFiles.size() + " region files");
                }
                for (RegionFile regionFile : this.regionFiles.values()) {
                    regionFile.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error while closing region files", e);
            }
            this.regionFiles.clear();
        }
    }

    @Override
    public boolean isChunkPresent(int x, int z) {
        try {
            RegionFile regionFile = this.getRegionFile(new Point(x >> 5, z >> 5), DataType.REGION);
            if (regionFile == null) {
                return false;
            }
            return regionFile.containsChunk(x & 0x1F, z & 0x1F);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error determining chunk presence", e);
        }
    }

    @Override
    public Chunk getChunk(int x, int z) {
        try {
            HashMap<DataType, Tag> tags = new HashMap<DataType, Tag>();
            for (DataType type : this.dataTypes) {
                DataInputStream chunkIn;
                RegionFile regionFile = this.getRegionFile(new Point(x >> 5, z >> 5), type);
                if (regionFile == null || (chunkIn = regionFile.getChunkDataInputStream(x & 0x1F, z & 0x1F)) == null) continue;
                NBTInputStream in = new NBTInputStream((InputStream)chunkIn);
                Throwable throwable = null;
                try {
                    tags.put(type, in.readTag());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            if (!tags.containsKey((Object)DataType.REGION)) {
                return null;
            }
            return this.platformProvider.createChunk(this.platform, tags, this.minHeight, this.maxHeight, false);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading chunk", e);
        }
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionFile getRegionFile(Point regionCoords, DataType type) throws IOException {
        Map<RegionKey, RegionFile> map = this.regionFiles;
        synchronized (map) {
            RegionKey key = new RegionKey(type, regionCoords);
            RegionFile regionFile = this.regionFiles.get(key);
            if (regionFile == null && (regionFile = this.platformProvider.getRegionFileIfExists(this.platform, this.regionDir, type, regionCoords, false)) != null) {
                this.regionFiles.put(key, regionFile);
            }
            return regionFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionFile getOrCreateRegionFile(Point regionCoords, DataType type) throws IOException {
        Map<RegionKey, RegionFile> map = this.regionFiles;
        synchronized (map) {
            RegionKey key = new RegionKey(type, regionCoords);
            RegionFile regionFile = this.regionFiles.get(key);
            if (regionFile == null) {
                regionFile = this.platformProvider.getRegionFile(this.platform, this.regionDir, type, regionCoords, false);
                this.regionFiles.put(key, regionFile);
            }
            return regionFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitRegionsInParallel(File[] files, Pattern regionFilePattern, RegionVisitor visitor, String operation) {
        int threadCount = ThreadUtils.chooseThreadCount(operation, files.length);
        ExecutorService executor = MDCThreadPoolExecutor.newFixedThreadPool((int)threadCount, (ThreadFactory)new ThreadFactory(){
            private final ThreadGroup threadGroup = new ThreadGroup("Chunk Visitors");
            private int nextID = 1;

            @Override
            public synchronized Thread newThread(Runnable r) {
                Thread thread = new Thread(this.threadGroup, r, "Chunk-Visitor-" + this.nextID++);
                thread.setPriority(1);
                return thread;
            }
        });
        Throwable[] exception = new Throwable[1];
        AtomicBoolean cancelled = new AtomicBoolean();
        try {
            for (File file : files) {
                if (file.length() == 0L) continue;
                executor.execute(() -> {
                    Throwable[] throwableArray = exception;
                    synchronized (exception) {
                        if (exception[0] != null || cancelled.get()) {
                            logger.debug("Skipping file {} because of previous exception, or because the visitor previously returned false", (Object)file);
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return;
                        }
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        try {
                            HashMap<DataType, RegionFile> regionFilesToVisit = new HashMap<DataType, RegionFile>();
                            Matcher matcher = regionFilePattern.matcher(file.getName());
                            matcher.find();
                            Point coords = new Point(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
                            Map<RegionKey, RegionFile> map = this.regionFiles;
                            synchronized (map) {
                                for (DataType dataType : this.dataTypes) {
                                    RegionKey key = new RegionKey(dataType, coords);
                                    if (this.regionFiles.containsKey(key)) {
                                        regionFilesToVisit.put(dataType, this.regionFiles.get(key));
                                        continue;
                                    }
                                    RegionFile regionFile = dataType == DataType.REGION ? new RegionFile(file, true) : this.platformProvider.getRegionFile(this.platform, this.regionDir, dataType, coords, true);
                                    if (regionFile == null) continue;
                                    this.regionFiles.put(key, regionFile);
                                    regionFilesToVisit.put(dataType, regionFile);
                                }
                            }
                            try {
                                if (!visitor.visitRegion(regionFilesToVisit)) {
                                    cancelled.set(true);
                                }
                                map = this.regionFiles;
                            }
                            catch (Throwable throwable) {
                                Map<RegionKey, RegionFile> map2 = this.regionFiles;
                                synchronized (map2) {
                                    for (Map.Entry entry : regionFilesToVisit.entrySet()) {
                                        ((RegionFile)entry.getValue()).close();
                                        this.regionFiles.remove(new RegionKey((DataType)((Object)((Object)entry.getKey())), coords));
                                    }
                                    throw throwable;
                                }
                            }
                            synchronized (map) {
                                for (Map.Entry entry : regionFilesToVisit.entrySet()) {
                                    ((RegionFile)entry.getValue()).close();
                                    this.regionFiles.remove(new RegionKey((DataType)((Object)((Object)entry.getKey())), coords));
                                }
                                return;
                            }
                        }
                        catch (Throwable e) {
                            logger.error(e.getClass().getSimpleName() + " while visiting region file " + file + " (message: " + e.getMessage() + ")", e);
                            Throwable[] throwableArray2 = exception;
                            synchronized (exception) {
                                if (exception[0] != null) return;
                                exception[0] = e;
                                // ** MonitorExit[var7_10] (shouldn't be in output)
                                return;
                            }
                        }
                    }
                });
            }
        }
        finally {
            executor.shutdown();
            try {
                executor.awaitTermination(366L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                throw new MDCCapturingRuntimeException("Thread interrupted while waiting for all tasks to finish", (Throwable)e);
            }
        }
        Serializable[] serializableArray = exception;
        synchronized (exception) {
            if (exception[0] != null) {
                throw new MDCCapturingRuntimeException(exception[0].getClass().getSimpleName() + " while visiting region files (message: " + exception[0].getMessage() + ")", exception[0]);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return !cancelled.get();
        }
    }

    private boolean visitChunks(ChunkStore.ChunkVisitor visitor, boolean readOnly, String operation, Set<DataType> dataTypes) {
        try {
            return this.visitRegions(regions -> {
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        boolean exceptionFromChunkVisitor = false;
                        try {
                            if (!((RegionFile)regions.get((Object)DataType.REGION)).containsChunk(x, z)) continue;
                            HashMap<DataType, Tag> tags = new HashMap<DataType, Tag>();
                            for (Map.Entry entry : regions.entrySet()) {
                                DataInputStream chunkIn = ((RegionFile)entry.getValue()).getChunkDataInputStream(x & 0x1F, z & 0x1F);
                                if (chunkIn == null) continue;
                                NBTInputStream in = new NBTInputStream((InputStream)chunkIn);
                                Throwable throwable = null;
                                try {
                                    tags.put((DataType)((Object)((Object)entry.getKey())), in.readTag());
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (in == null) continue;
                                    if (throwable != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    in.close();
                                }
                            }
                            NBTChunk chunk = this.platformProvider.createChunk(this.platform, tags, this.minHeight, this.maxHeight, readOnly);
                            exceptionFromChunkVisitor = true;
                            if (visitor.visitChunk(chunk)) {
                                if (!readOnly) {
                                    this.saveChunk(chunk);
                                }
                                continue;
                            }
                            return false;
                        }
                        catch (IOException | RuntimeException e) {
                            if (exceptionFromChunkVisitor) {
                                throw e;
                            }
                            logger.error("{} while visiting chunk {},{} in regions {} (message: \"{}\")", new Object[]{e.getClass().getSimpleName(), x, z, regions, e.getMessage(), e});
                            if (visitor.chunkError(new MinecraftCoords(x, z), e.getClass().getSimpleName() + ": " + e.getMessage())) continue;
                            return false;
                        }
                        catch (Exception e) {
                            throw new MDCCapturingRuntimeException("Checked exception visiting chunk " + x + "," + z + " in regions " + regions, (Throwable)e);
                        }
                    }
                }
                return true;
            }, readOnly, operation, dataTypes);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while visiting regions of " + this.regionDir, e);
        }
    }

    public static void main(String[] args) {
        System.out.println("All checks passed");
    }

    private static /* synthetic */ boolean lambda$visitRegions$0(Pattern regionFilePattern, boolean readOnly, File dir, String name) {
        if (!regionFilePattern.matcher(name).matches()) {
            return false;
        }
        if (new File(dir, name).length() == 0L) {
            if (!readOnly) {
                logger.warn("Skipping empty region file {}", (Object)name);
            }
            return false;
        }
        return true;
    }

    static class RegionKey {
        private final DataType type;
        private final Point coords;

        RegionKey(DataType type, Point coords) {
            this.type = type;
            this.coords = coords;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionKey regionKey = (RegionKey)o;
            return this.type == regionKey.type && this.coords.equals(regionKey.coords);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.coords});
        }
    }

    @FunctionalInterface
    public static interface RegionVisitor {
        public boolean visitRegion(Map<DataType, RegionFile> var1) throws Exception;
    }
}

