/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.util.ArrayList;
import java.util.List;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.Platform;

public class InvertedChunk
implements Chunk {
    private final Chunk chunk;
    private final Platform platform;
    private final int minHeight;
    private final int maxHeight;
    private final int maxY;

    public InvertedChunk(Chunk chunk, int delta, Platform platform) {
        this.chunk = chunk;
        this.platform = platform;
        this.minHeight = chunk.getMinHeight();
        this.maxHeight = chunk.getMaxHeight();
        this.maxY = this.maxHeight + this.minHeight - delta - 1;
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        if (this.maxY - y < this.minHeight || this.maxY - y >= this.maxHeight) {
            return 0;
        }
        return this.chunk.getBlockLightLevel(x, this.maxY - y, z);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.setBlockLightLevel(x, this.maxY - y, z, blockLightLevel);
        }
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        if (this.maxY - y < this.minHeight || this.maxY - y >= this.maxHeight) {
            return 0;
        }
        return this.chunk.getBlockType(x, this.maxY - y, z);
    }

    @Override
    public void setBlockType(int x, int y, int z, int blockType) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.setBlockType(x, this.maxY - y, z, blockType);
        }
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        if (this.maxY - y < this.minHeight || this.maxY - y >= this.maxHeight) {
            return 0;
        }
        return this.chunk.getDataValue(x, this.maxY - y, z);
    }

    @Override
    public void setDataValue(int x, int y, int z, int dataValue) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.setDataValue(x, this.maxY - y, z, dataValue);
        }
    }

    @Override
    public int getHeight(int x, int z) {
        return this.maxY - this.chunk.getHeight(x, z);
    }

    @Override
    public void setHeight(int x, int z, int height) {
        this.chunk.setHeight(x, z, this.maxY - height);
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.maxY - y < this.minHeight) {
            return 0;
        }
        if (this.maxY - y >= this.maxHeight) {
            return 15;
        }
        return this.chunk.getSkyLightLevel(x, this.maxY - y, z);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.setSkyLightLevel(x, this.maxY - y, z, skyLightLevel);
        }
    }

    @Override
    public int getxPos() {
        return this.chunk.getxPos();
    }

    @Override
    public int getzPos() {
        return this.chunk.getzPos();
    }

    @Override
    public MinecraftCoords getCoords() {
        return this.chunk.getCoords();
    }

    @Override
    public boolean isTerrainPopulated() {
        return this.chunk.isTerrainPopulated();
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        this.chunk.setTerrainPopulated(terrainPopulated);
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        if (this.maxY - y < this.minHeight || this.maxY - y >= this.maxHeight) {
            return Material.AIR;
        }
        return this.chunk.getMaterial(x, this.maxY - y, z).invert(this.platform);
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.setMaterial(x, this.maxY - y, z, material.invert(this.platform));
        }
    }

    @Override
    public List<Entity> getEntities() {
        List<Entity> chunkEntities = this.chunk.getEntities();
        if (chunkEntities != null) {
            ArrayList<Entity> entities = new ArrayList<Entity>(chunkEntities.size());
            for (Entity chunkEntity : chunkEntities) {
                Entity entity = chunkEntity.clone();
                double[] pos = entity.getPos();
                pos[1] = (double)this.maxY - pos[1];
                entity.setPos(pos);
                entities.add(entity);
            }
            return entities;
        }
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        List<TileEntity> chunkTileEntities = this.chunk.getTileEntities();
        if (chunkTileEntities != null) {
            ArrayList<TileEntity> tileEntities = new ArrayList<TileEntity>(chunkTileEntities.size());
            for (TileEntity chunkTileEntity : chunkTileEntities) {
                TileEntity tileEntity = (TileEntity)chunkTileEntity.clone();
                int adjustedY = this.maxY - tileEntity.getY();
                if (adjustedY < 0 || adjustedY >= this.maxHeight) continue;
                tileEntity.setY(adjustedY);
                tileEntities.add(tileEntity);
            }
            return tileEntities;
        }
        return null;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public boolean isBiomesSupported() {
        return this.chunk.isBiomesSupported();
    }

    @Override
    public boolean isBiomesAvailable() {
        return this.chunk.isBiomesAvailable();
    }

    @Override
    public boolean is3DBiomesSupported() {
        return this.chunk.is3DBiomesSupported();
    }

    @Override
    public boolean is3DBiomesAvailable() {
        return this.chunk.is3DBiomesAvailable();
    }

    @Override
    public boolean isNamedBiomesSupported() {
        return this.chunk.isNamedBiomesSupported();
    }

    @Override
    public boolean isNamedBiomesAvailable() {
        return this.chunk.isNamedBiomesAvailable();
    }

    @Override
    public int getBiome(int x, int z) {
        return this.chunk.getBiome(x, z);
    }

    @Override
    public void setBiome(int x, int z, int biome) {
        this.chunk.setBiome(x, z, biome);
    }

    @Override
    public int get3DBiome(int x, int y, int z) {
        if (this.maxY - y < this.minHeight) {
            return this.chunk.get3DBiome(x, 0, z);
        }
        if (this.maxY - y >= this.maxHeight) {
            return this.chunk.get3DBiome(x, this.maxHeight >> 2, z);
        }
        return this.chunk.get3DBiome(x, (this.maxY >> 2) - y, z);
    }

    @Override
    public void set3DBiome(int x, int y, int z, int biome) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.set3DBiome(x, (this.maxY >> 2) - y, z, biome);
        }
    }

    @Override
    public String getNamedBiome(int x, int y, int z) {
        if (this.maxY - y < this.minHeight) {
            return this.chunk.getNamedBiome(x, 0, z);
        }
        if (this.maxY - y >= this.maxHeight) {
            return this.chunk.getNamedBiome(x, this.maxHeight >> 2, z);
        }
        return this.chunk.getNamedBiome(x, (this.maxY >> 2) - y, z);
    }

    @Override
    public void setNamedBiome(int x, int y, int z, String biome) {
        if (this.maxY - y >= this.minHeight && this.maxY - y < this.maxHeight) {
            this.chunk.setNamedBiome(x, (this.maxY >> 2) - y, z, biome);
        }
    }

    @Override
    public void markForUpdateChunk(int x, int y, int z) {
        this.chunk.markForUpdateChunk(x, this.maxY - y, z);
    }

    @Override
    public boolean isReadOnly() {
        return this.chunk.isReadOnly();
    }

    @Override
    public boolean isLightPopulated() {
        return this.chunk.isLightPopulated();
    }

    @Override
    public void setLightPopulated(boolean lightPopulated) {
        this.chunk.setLightPopulated(lightPopulated);
    }

    @Override
    public long getInhabitedTime() {
        return this.chunk.getInhabitedTime();
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
        this.chunk.setInhabitedTime(inhabitedTime);
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        for (int y = this.minHeight; y < this.maxHeight; ++y) {
            if (this.chunk.getBlockType(x, y, z) == 0) continue;
            return this.maxY - y;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHighestNonAirBlock() {
        for (int y = this.minHeight; y < this.maxHeight; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (this.chunk.getBlockType(x, y, z) == 0) continue;
                    return this.maxY - y;
                }
            }
        }
        return Integer.MIN_VALUE;
    }
}

