/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Chest;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.InventoryItem;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.Box;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.ParallelProgressManager;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.mdc.MDCThreadPoolExecutor;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.ScaledDimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.BlockBasedExportSettings;
import org.pepsoft.worldpainter.exporting.BlockPropertiesCalculator;
import org.pepsoft.worldpainter.exporting.BorderChunkFactory;
import org.pepsoft.worldpainter.exporting.CachingMinecraftWorld;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.FlatteningDimension;
import org.pepsoft.worldpainter.exporting.InvertedChunk;
import org.pepsoft.worldpainter.exporting.InvertedWorld;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.exporting.WallChunk;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldExporter;
import org.pepsoft.worldpainter.exporting.WorldPainterChunkFactory;
import org.pepsoft.worldpainter.exporting.WorldRegion;
import org.pepsoft.worldpainter.gardenofeden.GardenExporter;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.GardenCategory;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.platforms.JavaExportSettings;
import org.pepsoft.worldpainter.plugins.BlockBasedPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.ThreadUtils;
import org.pepsoft.worldpainter.vo.AttributeKeyVO;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorldExporter
implements WorldExporter {
    protected final World2 world;
    protected final BlockBasedPlatformProvider platformProvider;
    protected final Semaphore performingFixups = new Semaphore(1);
    protected final Platform platform;
    protected final WorldExportSettings worldExportSettings;
    protected final boolean populateSupported;
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final BlockBasedExportSettings DEFAULT_EXPORT_SETTINGS = new BlockBasedExportSettings(){

        @Override
        public boolean isCalculateSkyLight() {
            return true;
        }

        @Override
        public boolean isCalculateBlockLight() {
            return true;
        }

        @Override
        public boolean isCalculateLeafDistance() {
            return true;
        }

        @Override
        public boolean isRemoveFloatingLeaves() {
            return false;
        }
    };
    private static final Object TIMING_FILE_LOCK = new Object();
    private static final Logger logger = LoggerFactory.getLogger(AbstractWorldExporter.class);

    protected AbstractWorldExporter(World2 world, WorldExportSettings worldExportSettings, Platform platform) {
        if (world == null) {
            throw new NullPointerException();
        }
        this.world = world;
        this.platform = platform;
        this.worldExportSettings = worldExportSettings != null ? worldExportSettings : (world.getExportSettings() != null ? world.getExportSettings() : new WorldExportSettings());
        this.platformProvider = (BlockBasedPlatformProvider)PlatformManager.getInstance().getPlatformProvider(platform);
        this.populateSupported = platform.capabilities.contains((Object)Platform.Capability.POPULATE);
    }

    @Override
    public World2 getWorld() {
        return this.world;
    }

    @Override
    public File selectBackupDir(File worldDir) throws IOException {
        File baseDir = worldDir.getParentFile();
        File minecraftDir = baseDir.getParentFile();
        File backupsDir = new File(minecraftDir, "backups");
        if (!(backupsDir.isDirectory() || backupsDir.mkdirs() || (backupsDir = new File(System.getProperty("user.home"), "WorldPainter Backups")).isDirectory() || backupsDir.mkdirs())) {
            throw new IOException("Could not create " + backupsDir);
        }
        return new File(backupsDir, worldDir.getName() + "." + DATE_FORMAT.format(new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChunkFactory.Stats parallelExportRegions(Dimension dimension, File worldDir, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (progressReceiver != null) {
            progressReceiver.setMessage("Exporting " + dimension.getName() + " dimension");
        }
        long start = System.currentTimeMillis();
        Dimension.Anchor anchor = dimension.getAnchor();
        int dim = anchor.dim;
        Dimension ceiling = dimension.getWorld().getDimension(new Dimension.Anchor(dim, anchor.role, true, 0));
        Dimension master = dimension.getWorld().getDimension(new Dimension.Anchor(dim, Dimension.Role.MASTER, false, 0));
        Dimension combined = master != null ? new FlatteningDimension(dimension, new ScaledDimension(master, 16.0f)) : dimension;
        ChunkFactory.Stats collectedStats = new ChunkFactory.Stats();
        boolean tilesSelected = this.worldExportSettings.getTilesToExport() != null;
        Set<Point> selectedTiles = tilesSelected ? this.worldExportSettings.getTilesToExport() : null;
        Map savedSettings = this.world.getDimensions().stream().filter(d -> d.getAnchor().dim == dim).collect(Collectors.toMap(Function.identity(), d -> this.setupDimensionForExport((Dimension)d, selectedTiles)));
        try {
            int regionZ;
            int regionX;
            int lowestRegionX = Integer.MAX_VALUE;
            int highestRegionX = Integer.MIN_VALUE;
            int lowestRegionZ = Integer.MAX_VALUE;
            int highestRegionZ = Integer.MIN_VALUE;
            HashSet<Point> regions = new HashSet<Point>();
            HashSet exportedRegions = new HashSet();
            if (tilesSelected) {
                assert (this.worldExportSettings.getDimensionsToExport().size() == 1);
                assert (this.worldExportSettings.getDimensionsToExport().contains(dim));
                for (Point tile : selectedTiles) {
                    regionX = tile.x >> 2;
                    regionZ = tile.y >> 2;
                    regions.add(new Point(regionX, regionZ));
                    if (regionX < lowestRegionX) {
                        lowestRegionX = regionX;
                    }
                    if (regionX > highestRegionX) {
                        highestRegionX = regionX;
                    }
                    if (regionZ < lowestRegionZ) {
                        lowestRegionZ = regionZ;
                    }
                    if (regionZ <= highestRegionZ) continue;
                    highestRegionZ = regionZ;
                }
            } else {
                for (Point tileCoords : combined.getTileCoords()) {
                    int r = (dimension.getBorder() != null && !dimension.getBorder().isEndless() ? dimension.getBorderSize() : 0) + ((dimension.getBorder() == null || !dimension.getBorder().isEndless()) && dimension.getWallType() != null ? 1 : 0);
                    for (int dx = -r; dx <= r; ++dx) {
                        for (int dy = -r; dy <= r; ++dy) {
                            int regionX2 = tileCoords.x + dx >> 2;
                            int regionZ2 = tileCoords.y + dy >> 2;
                            regions.add(new Point(regionX2, regionZ2));
                            if (regionX2 < lowestRegionX) {
                                lowestRegionX = regionX2;
                            }
                            if (regionX2 > highestRegionX) {
                                highestRegionX = regionX2;
                            }
                            if (regionZ2 < lowestRegionZ) {
                                lowestRegionZ = regionZ2;
                            }
                            if (regionZ2 <= highestRegionZ) continue;
                            highestRegionZ = regionZ2;
                        }
                    }
                }
                if (ceiling != null) {
                    for (Point tileCoords : ceiling.getTileCoords()) {
                        regionX = tileCoords.x >> 2;
                        regionZ = tileCoords.y >> 2;
                        regions.add(new Point(regionX, regionZ));
                        if (regionX < lowestRegionX) {
                            lowestRegionX = regionX;
                        }
                        if (regionX > highestRegionX) {
                            highestRegionX = regionX;
                        }
                        if (regionZ < lowestRegionZ) {
                            lowestRegionZ = regionZ;
                        }
                        if (regionZ <= highestRegionZ) continue;
                        highestRegionZ = regionZ;
                    }
                }
            }
            ArrayList<Point> sortedRegions = new ArrayList<Point>(regions.size());
            if (lowestRegionZ == highestRegionZ) {
                sortedRegions.addAll(regions);
            } else {
                for (int x = lowestRegionX; x <= highestRegionX; ++x) {
                    for (int z = lowestRegionZ; z <= lowestRegionZ + 1; ++z) {
                        Point regionCoords = new Point(x, z);
                        if (!regions.contains(regionCoords)) continue;
                        sortedRegions.add(regionCoords);
                    }
                }
                for (int z = lowestRegionZ + 2; z <= highestRegionZ; ++z) {
                    for (int x = lowestRegionX; x <= highestRegionX; ++x) {
                        Point regionCoords = new Point(x, z);
                        if (!regions.contains(regionCoords)) continue;
                        sortedRegions.add(regionCoords);
                    }
                }
            }
            HashMap<Point, List<Fixup>> fixups = new HashMap<Point, List<Fixup>>();
            ExecutorService executor = this.createExecutorService("exporting", sortedRegions.size());
            RuntimeException[] exception = new RuntimeException[1];
            ParallelProgressManager parallelProgressManager = progressReceiver != null ? new ParallelProgressManager(progressReceiver, regions.size()) : null;
            AtomicBoolean abort = new AtomicBoolean();
            try {
                Iterator regionZ2 = sortedRegions.iterator();
                while (regionZ2.hasNext()) {
                    Point region;
                    Point regionCoords = region = (Point)regionZ2.next();
                    executor.execute(() -> {
                        block23: {
                            ProgressReceiver progressReceiver1;
                            if (abort.get()) {
                                return;
                            }
                            ProgressReceiver progressReceiver = progressReceiver1 = parallelProgressManager != null ? parallelProgressManager.createProgressReceiver() : null;
                            if (progressReceiver1 != null) {
                                try {
                                    progressReceiver1.checkForCancellation();
                                }
                                catch (ProgressReceiver.OperationCancelled e) {
                                    abort.set(true);
                                    return;
                                }
                            }
                            try {
                                ExportResults exportResults;
                                block22: {
                                    int minHeight = dimension.getMinHeight();
                                    int maxHeight = dimension.getMaxHeight();
                                    Map<Layer, LayerExporter> exporters = this.getExportersForRegion(combined, regionCoords);
                                    Map<Layer, LayerExporter> ceilingExporters = ceiling != null ? this.getExportersForRegion(ceiling, region) : null;
                                    WorldPainterChunkFactory chunkFactory = new WorldPainterChunkFactory(combined, exporters, this.platform, maxHeight);
                                    WorldPainterChunkFactory ceilingChunkFactory = ceiling != null ? new WorldPainterChunkFactory(ceiling, ceilingExporters, this.platform, maxHeight) : null;
                                    WorldRegion worldRegion = new WorldRegion(regionCoords.x, regionCoords.y, minHeight, maxHeight, this.platform);
                                    exportResults = null;
                                    try {
                                        exportResults = this.exportRegion(worldRegion, combined, ceiling, regionCoords, tilesSelected, exporters, ceilingExporters, chunkFactory, ceilingChunkFactory, (ProgressReceiver)(progressReceiver1 != null ? new SubProgressReceiver(progressReceiver1, 0.0f, 0.9f) : null));
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("Generated region " + regionCoords.x + "," + regionCoords.y);
                                        }
                                        if (!exportResults.chunksGenerated) break block22;
                                        ChunkFactory.Stats stats = collectedStats;
                                        synchronized (stats) {
                                            collectedStats.landArea += exportResults.stats.landArea;
                                            collectedStats.surfaceArea += exportResults.stats.surfaceArea;
                                            collectedStats.waterArea += exportResults.stats.waterArea;
                                        }
                                    }
                                    finally {
                                        if (exportResults != null && exportResults.chunksGenerated) {
                                            long saveStart = System.currentTimeMillis();
                                            worldRegion.save(worldDir, dim);
                                            if (logger.isDebugEnabled()) {
                                                logger.debug("Saving region took {} ms", (Object)(System.currentTimeMillis() - saveStart));
                                            }
                                        }
                                    }
                                }
                                Map map = fixups;
                                synchronized (map) {
                                    if (exportResults.fixups != null && !exportResults.fixups.isEmpty()) {
                                        fixups.put(new Point(regionCoords.x, regionCoords.y), exportResults.fixups);
                                    }
                                    exportedRegions.add(regionCoords);
                                }
                                this.performFixupsIfNecessary(worldDir, combined, regions, fixups, exportedRegions, progressReceiver1);
                            }
                            catch (Throwable t) {
                                if (ExceptionUtils.chainContains((Throwable)t, ProgressReceiver.OperationCancelled.class)) {
                                    logger.debug("Operation cancelled on thread {} (message: \"{}\")", (Object)Thread.currentThread().getName(), (Object)t.getMessage());
                                } else {
                                    logger.error(t.getClass().getSimpleName() + " while exporting region {},{} (message: \"{}\")", new Object[]{region.x, region.y, t.getMessage(), t});
                                }
                                abort.set(true);
                                if (progressReceiver1 != null) {
                                    progressReceiver1.exceptionThrown(t);
                                }
                                if (exception[0] != null) break block23;
                                exception[0] = new RuntimeException(t.getClass().getSimpleName() + " while exporting region" + region.x + "," + region.y, exception[0]);
                            }
                        }
                    });
                }
            }
            finally {
                executor.shutdown();
                try {
                    executor.awaitTermination(366L, TimeUnit.DAYS);
                }
                catch (InterruptedException e) {
                    throw new MDCCapturingRuntimeException("Thread interrupted while waiting for all tasks to finish", (Throwable)e);
                }
            }
            if (exception[0] != null) {
                throw exception[0];
            }
            if (!abort.get()) {
                HashMap<Point, List<Fixup>> hashMap = fixups;
                synchronized (hashMap) {
                    if (!fixups.isEmpty()) {
                        if (progressReceiver != null) {
                            progressReceiver.setMessage("Doing remaining fixups for " + dimension.getName());
                            progressReceiver.reset();
                        }
                        this.performFixups(worldDir, combined, progressReceiver, fixups);
                    }
                }
            }
            collectedStats.time = System.currentTimeMillis() - start;
            if (progressReceiver != null) {
                progressReceiver.setProgress(1.0f);
            }
        }
        finally {
            savedSettings.forEach(this::restoreDimensionAfterExport);
        }
        return collectedStats;
    }

    protected final void logLayers(Dimension dimension, EventVO event, String prefix) {
        StringBuilder sb = new StringBuilder();
        for (Layer layer : dimension.getAllLayers(false)) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(layer.getName());
        }
        if (sb.length() > 0) {
            event.setAttribute(new AttributeKeyVO(prefix + "layers"), (Serializable)((Object)sb.toString()));
        }
    }

    protected Object setupDimensionForExport(Dimension dimension, Set<Point> selectedTiles) {
        boolean done;
        Set<Layer> allLayers;
        HashMap<String, Object> savedSettings = new HashMap<String, Object>();
        if (!dimension.isUndoAvailable()) {
            UndoManager undoManager = new UndoManager(2);
            dimension.registerUndoManager(undoManager);
            savedSettings.put("undoManager", undoManager);
        }
        dimension.rememberChanges();
        if (this.worldExportSettings.getStepsToSkip() != null && this.worldExportSettings.getStepsToSkip().contains((Object)WorldExportSettings.Step.LEAVES)) {
            ExportSettings exportSettings = dimension.getExportSettings();
            savedSettings.put("exportSettings", exportSettings);
            if (exportSettings == null) {
                exportSettings = this.platformProvider.getDefaultExportSettings(this.platform);
            }
            if (exportSettings instanceof JavaExportSettings) {
                exportSettings = ((JavaExportSettings)exportSettings).withMakeAllLeavesPersistent(true);
                dimension.setExportSettings(exportSettings);
            }
        }
        if (selectedTiles == null) {
            allLayers = dimension.getAllLayers(false);
        } else {
            allLayers = new HashSet<Layer>();
            for (Point coords : selectedTiles) {
                Tile tile = dimension.getTile(coords);
                if (tile == null) continue;
                allLayers.addAll(tile.getLayers());
            }
        }
        allLayers.addAll(dimension.getMinimumLayers());
        do {
            done = true;
            for (Layer layer : new HashSet<Layer>(allLayers)) {
                if (!(layer instanceof CombinedLayer) || !((CombinedLayer)layer).isExport()) continue;
                Set<Layer> addedLayers = ((CombinedLayer)layer).apply(dimension, selectedTiles);
                allLayers.remove(layer);
                allLayers.addAll(addedLayers);
                done = false;
            }
        } while (!done);
        for (CustomLayer customLayer : dimension.getCustomLayers()) {
            if (!(customLayer instanceof TunnelLayer) || ((TunnelLayer)customLayer).getFloorMode() != TunnelLayer.Mode.CUSTOM_DIMENSION) continue;
            ((TunnelLayer)customLayer).updateFloorDimensionTiles(dimension);
        }
        return savedSettings;
    }

    protected void restoreDimensionAfterExport(Dimension dimension, Object savedSettings) {
        Map map = (Map)savedSettings;
        if (map != null && map.containsKey("exportSettings")) {
            dimension.setExportSettings((ExportSettings)map.get("exportSettings"));
        }
        if (dimension.undoChanges()) {
            dimension.clearRedo();
            dimension.armSavePoint();
        }
        if (map != null && map.containsKey("undoManager")) {
            dimension.unregisterUndoManager();
        }
    }

    protected Map<Layer, LayerExporter> getExportersForRegion(Dimension dimension, Point regionCoords) {
        boolean done;
        HashMap<Layer, LayerExporter> exporters = new HashMap<Layer, LayerExporter>();
        HashSet<Layer> allLayers = new HashSet<Layer>(dimension.getMinimumLayers());
        int tileX1 = (regionCoords.x << 2) - 1;
        int tileX2 = tileX1 + 5;
        int tileY1 = (regionCoords.y << 2) - 1;
        int tileY2 = tileY1 + 5;
        for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                Tile tile = dimension.getTile(tileX, tileY);
                if (tile == null) continue;
                allLayers.addAll(tile.getLayers());
            }
        }
        do {
            done = true;
            for (Layer layer2 : new HashSet<Layer>(allLayers)) {
                if (!(layer2 instanceof CombinedLayer) || !((CombinedLayer)layer2).isExport()) continue;
                allLayers.remove(layer2);
                allLayers.addAll(((CombinedLayer)layer2).getLayers());
                done = false;
            }
        } while (!done);
        allLayers.removeIf(layer -> layer instanceof CustomLayer && !((CustomLayer)layer).isExport());
        this.applyWorldExportSettings(allLayers);
        for (Layer layer2 : allLayers) {
            LayerExporter exporter = layer2.getExporter(dimension, this.platform, dimension.getLayerSettings(layer2));
            if (exporter == null) continue;
            exporters.put(layer2, exporter);
        }
        return exporters;
    }

    protected ExportResults firstPass(MinecraftWorld minecraftWorld, Dimension dimension, Point regionCoords, Map<Point, Tile> tiles, boolean tileSelection, Map<Layer, LayerExporter> exporters, ChunkFactory chunkFactory, boolean ceiling, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (logger.isDebugEnabled()) {
            logger.debug("Start of first pass for region {},{}", (Object)regionCoords.x, (Object)regionCoords.y);
        }
        if (progressReceiver != null) {
            if (ceiling) {
                progressReceiver.setMessage("Generating ceiling");
            } else {
                progressReceiver.setMessage("Generating landscape");
            }
        }
        int lowestChunkX = (regionCoords.x << 5) - 1;
        int highestChunkX = (regionCoords.x << 5) + 32;
        int lowestChunkY = (regionCoords.y << 5) - 1;
        int highestChunkY = (regionCoords.y << 5) + 32;
        int lowestRegionChunkX = lowestChunkX + 1;
        int highestRegionChunkX = highestChunkX - 1;
        int lowestRegionChunkY = lowestChunkY + 1;
        int highestRegionChunkY = highestChunkY - 1;
        ExportResults exportResults = new ExportResults();
        int chunkNo = 0;
        int ceilingDelta = dimension.getMaxHeight() - dimension.getCeilingHeight();
        for (int chunkX = lowestChunkX; chunkX <= highestChunkX; ++chunkX) {
            for (int chunkY = lowestChunkY; chunkY <= highestChunkY; ++chunkY) {
                ChunkFactory.ChunkCreationResult chunkCreationResult = this.createChunk(dimension, chunkFactory, tiles, chunkX, chunkY, tileSelection, exporters, ceiling);
                if (chunkCreationResult != null) {
                    if (chunkX >= lowestRegionChunkX && chunkX <= highestRegionChunkX && chunkY >= lowestRegionChunkY && chunkY <= highestRegionChunkY) {
                        exportResults.chunksGenerated = true;
                        exportResults.stats.landArea += chunkCreationResult.stats.landArea;
                        exportResults.stats.surfaceArea += chunkCreationResult.stats.surfaceArea;
                        exportResults.stats.waterArea += chunkCreationResult.stats.waterArea;
                    }
                    if (ceiling) {
                        InvertedChunk invertedChunk = new InvertedChunk(chunkCreationResult.chunk, ceilingDelta, this.platform);
                        Chunk existingChunk = minecraftWorld.getChunkForEditing(chunkX, chunkY);
                        if (existingChunk == null) {
                            existingChunk = this.platformProvider.createChunk(this.platform, chunkX, chunkY, dimension.getMinHeight(), dimension.getMaxHeight());
                            minecraftWorld.addChunk(existingChunk);
                        }
                        this.mergeChunks(invertedChunk, existingChunk);
                    } else {
                        minecraftWorld.addChunk(chunkCreationResult.chunk);
                    }
                }
                ++chunkNo;
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)chunkNo / 1156.0f);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("End of first pass for region {},{}", (Object)regionCoords.x, (Object)regionCoords.y);
        }
        return exportResults;
    }

    protected List<Fixup> secondPass(List<Layer> secondaryPassLayers, Dimension dimension, MinecraftWorld minecraftWorld, Map<Layer, LayerExporter> exporters, Collection<Tile> tiles, Point regionCoords, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (logger.isDebugEnabled()) {
            logger.debug("Start of second pass for region {},{}", (Object)regionCoords.x, (Object)regionCoords.y);
        }
        int stageCount = secondaryPassLayers.stream().mapToInt(layer -> {
            SecondPassLayerExporter exporter = (SecondPassLayerExporter)exporters.get(layer);
            if (exporter == null) {
                throw new IllegalStateException("Exporter missing for layer " + layer + " of type " + layer.getClass().getSimpleName());
            }
            return exporter.getStages().size();
        }).sum();
        GardenExporter gardenExporter = new GardenExporter();
        HashSet firstPassProcessedSeeds = new HashSet();
        tiles.stream().filter(tile -> tile.getLayers().contains(GardenCategory.INSTANCE)).forEach(tile -> gardenExporter.firstPass(dimension, (Tile)tile, this.platform, minecraftWorld, firstPassProcessedSeeds));
        int counter = 0;
        Rectangle area = new Rectangle((regionCoords.x << 9) - 16, (regionCoords.y << 9) - 16, 544, 544);
        Rectangle exportedArea = new Rectangle(regionCoords.x << 9, regionCoords.y << 9, 512, 512);
        ArrayList<Fixup> fixups = new ArrayList<Fixup>();
        for (SecondPassLayerExporter.Stage stage : SecondPassLayerExporter.Stage.values()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Start of {} stage for region {},{}", new Object[]{stage, regionCoords.x, regionCoords.y});
            }
            for (Layer layer2 : secondaryPassLayers) {
                List<Fixup> layerFixups;
                SecondPassLayerExporter exporter = (SecondPassLayerExporter)exporters.get(layer2);
                if (!exporter.getStages().contains((Object)stage)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Stage {} for layer {} for region {},{}", new Object[]{stage, layer2, regionCoords.x, regionCoords.y});
                }
                if (progressReceiver != null) {
                    if (minecraftWorld instanceof InvertedWorld) {
                        progressReceiver.setMessage("Exporting layer " + layer2 + " for ceiling (" + stage.name().toLowerCase() + " stage)");
                    } else {
                        progressReceiver.setMessage("Exporting layer " + layer2 + " (" + stage.name().toLowerCase() + " stage)");
                    }
                }
                switch (stage) {
                    case CARVE: {
                        layerFixups = exporter.carve(area, exportedArea, minecraftWorld);
                        break;
                    }
                    case ADD_FEATURES: {
                        layerFixups = exporter.addFeatures(area, exportedArea, minecraftWorld);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (layerFixups != null) {
                    fixups.addAll(layerFixups);
                }
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)(++counter) / (float)stageCount);
            }
        }
        HashSet secondPassProcessedSeeds = new HashSet();
        tiles.stream().filter(tile -> tile.getLayers().contains(GardenCategory.INSTANCE)).forEach(tile -> gardenExporter.secondPass(dimension, (Tile)tile, this.platform, minecraftWorld, secondPassProcessedSeeds));
        if (dimension.getAnchor().dim == 0 && this.world.isCreateGoodiesChest()) {
            Chunk chunk;
            Point goodiesPoint = (Point)this.world.getSpawnPoint().clone();
            goodiesPoint.translate(3, 3);
            int height = this.getIntHeightAt(0, goodiesPoint.x, goodiesPoint.y) + 1;
            if (height >= dimension.getMinHeight() && height < dimension.getMaxHeight() && (chunk = minecraftWorld.getChunk(goodiesPoint.x >> 4, goodiesPoint.y >> 4)) != null) {
                chunk.setMaterial(goodiesPoint.x & 0xF, height, goodiesPoint.y & 0xF, Material.CHEST_NORTH);
                Chest goodiesChest = this.createGoodiesChest(this.platform);
                goodiesChest.setX(goodiesPoint.x);
                goodiesChest.setY(height);
                goodiesChest.setZ(goodiesPoint.y);
                chunk.getTileEntities().add(goodiesChest);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("End of second pass for region {},{}", (Object)regionCoords.x, (Object)regionCoords.y);
        }
        return fixups;
    }

    protected void blockPropertiesPass(MinecraftWorld minecraftWorld, Point regionCoords, BlockBasedExportSettings exportSettings, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        float maxIterations = 0.0f;
        StringBuilder nounsBuilder = new StringBuilder();
        if (exportSettings.isCalculateSkyLight() || exportSettings.isCalculateBlockLight()) {
            nounsBuilder.append("lighting");
            maxIterations = 16.0f;
        }
        if (exportSettings.isCalculateLeafDistance()) {
            if (nounsBuilder.length() > 0) {
                nounsBuilder.append(" and ");
            }
            nounsBuilder.append("leaf distances");
            maxIterations = Math.max(maxIterations, 7.0f);
        }
        String nouns = nounsBuilder.toString();
        if (progressReceiver != null) {
            progressReceiver.setMessage("Calculating initial " + nouns);
        }
        BlockPropertiesCalculator calculator = new BlockPropertiesCalculator(minecraftWorld, this.platform, this.worldExportSettings, exportSettings);
        int lowMark = Integer.MAX_VALUE;
        int highMark = Integer.MIN_VALUE;
        int lowestChunkX = (regionCoords.x << 5) - 1;
        int highestChunkX = (regionCoords.x << 5) + 32;
        int lowestChunkY = (regionCoords.y << 5) - 1;
        int highestChunkY = (regionCoords.y << 5) + 32;
        int total = highestChunkX - lowestChunkX + 1;
        int count = 0;
        for (int chunkX = lowestChunkX; chunkX <= highestChunkX; ++chunkX) {
            for (int chunkY = lowestChunkY; chunkY <= highestChunkY; ++chunkY) {
                Chunk chunk = minecraftWorld.getChunk(chunkX, chunkY);
                if (chunk == null) continue;
                int[] levels = calculator.firstPass(chunk);
                if (levels[0] < lowMark) {
                    lowMark = levels[0];
                }
                if (levels[1] <= highMark) continue;
                highMark = levels[1];
            }
            if (progressReceiver == null) continue;
            progressReceiver.setProgress(0.2f * (float)(++count) / (float)total);
        }
        if (lowMark != Integer.MAX_VALUE) {
            if (progressReceiver != null) {
                progressReceiver.setMessage("Propagating " + nouns);
            }
            calculator.setDirtyArea(new Box((regionCoords.x << 9) - 16, (regionCoords.x + 1 << 9) + 16, lowMark, highMark + 1, (regionCoords.y << 9) - 16, (regionCoords.y + 1 << 9) + 16));
            int iteration = 1;
            while (calculator.secondPass()) {
                if (progressReceiver == null) continue;
                progressReceiver.setProgress(0.2f + 0.8f * ((float)iteration++ / maxIterations));
            }
            calculator.finalise();
        }
        if (progressReceiver != null) {
            progressReceiver.setProgress(1.0f);
        }
    }

    protected ExportResults exportRegion(MinecraftWorld minecraftWorld, Dimension dimension, Dimension ceiling, Point regionCoords, boolean tileSelection, Map<Layer, LayerExporter> exporters, Map<Layer, LayerExporter> ceilingExporters, ChunkFactory chunkFactory, ChunkFactory ceilingChunkFactory, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled, IOException {
        return (ExportResults)MDCUtils.doWithMdcContext(() -> {
            Class<? extends LayerExporter> exporterType;
            if (progressReceiver != null) {
                progressReceiver.setMessage("Exporting region " + regionCoords.x + "," + regionCoords.y + " of " + dimension.getName());
            }
            int lowestTileX = (regionCoords.x << 2) - 1;
            int highestTileX = lowestTileX + 5;
            int lowestTileY = (regionCoords.y << 2) - 1;
            int highestTileY = lowestTileY + 5;
            HashMap<Point, Tile> tiles = new HashMap<Point, Tile>();
            HashMap<Point, Tile> ceilingTiles = new HashMap<Point, Tile>();
            for (int tileX = lowestTileX; tileX <= highestTileX; ++tileX) {
                for (int tileY = lowestTileY; tileY <= highestTileY; ++tileY) {
                    Point tileCoords = new Point(tileX, tileY);
                    Tile tile = dimension.getTile(tileCoords);
                    if (tile != null && (!tileSelection || this.worldExportSettings.getTilesToExport().contains(tileCoords))) {
                        tiles.put(tileCoords, tile);
                    }
                    if (ceiling == null || (tile = ceiling.getTile(tileCoords)) == null || tileSelection && !this.worldExportSettings.getTilesToExport().contains(tileCoords)) continue;
                    ceilingTiles.put(tileCoords, tile);
                }
            }
            ArrayList<Layer> secondaryPassLayers = new ArrayList<Layer>();
            ArrayList<Layer> ceilingSecondaryPassLayers = new ArrayList<Layer>();
            for (Layer layer : exporters.keySet()) {
                exporterType = layer.getExporterType();
                if (exporterType == null || !SecondPassLayerExporter.class.isAssignableFrom(exporterType)) continue;
                secondaryPassLayers.add(layer);
            }
            Collections.sort(secondaryPassLayers);
            if (ceiling != null) {
                for (Layer layer : ceilingExporters.keySet()) {
                    exporterType = layer.getExporterType();
                    if (exporterType == null || !SecondPassLayerExporter.class.isAssignableFrom(exporterType)) continue;
                    ceilingSecondaryPassLayers.add(layer);
                }
                Collections.sort(ceilingSecondaryPassLayers);
            }
            long t1 = System.currentTimeMillis();
            ExportResults exportResults = this.firstPass(minecraftWorld, dimension, regionCoords, tiles, tileSelection, exporters, chunkFactory, false, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.0f, ceiling != null ? 0.225f : 0.45f) : null));
            ExportResults ceilingExportResults = null;
            if (ceiling != null) {
                ceilingExportResults = this.firstPass(minecraftWorld, ceiling, regionCoords, ceilingTiles, tileSelection, ceilingExporters, ceilingChunkFactory, true, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.225f, 0.225f) : null));
            }
            if (exportResults.chunksGenerated || ceiling != null && ceilingExportResults.chunksGenerated) {
                long t2 = System.currentTimeMillis();
                List<Fixup> myFixups = this.secondPass(secondaryPassLayers, dimension, minecraftWorld, exporters, tiles.values(), regionCoords, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.45f, ceiling != null ? 0.05f : 0.1f) : null));
                if (myFixups != null && !myFixups.isEmpty()) {
                    exportResults.fixups = myFixups;
                }
                if (ceiling != null) {
                    this.secondPass(ceilingSecondaryPassLayers, ceiling, new InvertedWorld(minecraftWorld, ceiling.getMaxHeight() - ceiling.getCeilingHeight(), this.platform), ceilingExporters, ceilingTiles.values(), regionCoords, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.4f, 0.05f) : null));
                }
                long t3 = System.currentTimeMillis();
                BlockBasedExportSettings exportSettings = this.getExportSettings(dimension, this.platform);
                PlatformManager.getInstance().getPostProcessor(this.platform).postProcess(minecraftWorld, new Rectangle(regionCoords.x << 9, regionCoords.y << 9, 512, 512), (ExportSettings)exportSettings, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.55f, 0.1f) : null));
                long t4 = System.currentTimeMillis();
                if (BlockPropertiesCalculator.isBlockPropertiesPassNeeded(this.platform, this.worldExportSettings, exportSettings)) {
                    this.blockPropertiesPass(minecraftWorld, regionCoords, exportSettings, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.65f, 0.35f) : null));
                }
                long t5 = System.currentTimeMillis();
                if ("true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.devMode"))) {
                    String timingMessage = t2 - t1 + ", " + (t3 - t2) + ", " + (t4 - t3) + ", " + (t5 - t4) + ", " + (t5 - t1);
                    Object object = TIMING_FILE_LOCK;
                    synchronized (object) {
                        try (PrintWriter out = new PrintWriter(new FileOutputStream("exporttimings.csv", true));){
                            out.println(timingMessage);
                        }
                    }
                }
            }
            if (progressReceiver != null) {
                progressReceiver.setProgress(1.0f);
            }
            return exportResults;
        }, (Object[])new Object[]{"region.coords", regionCoords});
    }

    protected ChunkFactory.ChunkCreationResult createChunk(Dimension dimension, ChunkFactory chunkFactory, Map<Point, Tile> tiles, int chunkX, int chunkY, boolean tileSelection, Map<Layer, LayerExporter> exporters, boolean ceiling) {
        boolean border;
        int tileX = chunkX >> 3;
        int tileY = chunkY >> 3;
        Point tileCoords = new Point(tileX, tileY);
        Dimension.Border borderType = dimension.getBorder();
        boolean endlessBorder = borderType != null && borderType.isEndless();
        boolean bl = border = borderType != null && !endlessBorder && dimension.getBorderSize() > 0;
        if (tileSelection) {
            if (tiles.containsKey(tileCoords)) {
                return chunkFactory.createChunk(chunkX, chunkY);
            }
            return null;
        }
        Tile tile = dimension.getTile(tileCoords);
        if (tile != null) {
            ChunkFactory.ChunkCreationResult result = chunkFactory.createChunk(chunkX, chunkY);
            if (result == null && border && tile.getBitLayerValue(NotPresent.INSTANCE, (chunkX & 7) << 4, (chunkY & 7) << 4)) {
                return BorderChunkFactory.create(chunkX, chunkY, dimension, this.platform, exporters);
            }
            return result;
        }
        if (!ceiling && !endlessBorder) {
            if (border && this.isBorderChunk(dimension, chunkX, chunkY)) {
                return BorderChunkFactory.create(chunkX, chunkY, dimension, this.platform, exporters);
            }
            if (dimension.getWallType() != null && (border ? this.isBorderChunk(dimension, chunkX - 1, chunkY) || this.isBorderChunk(dimension, chunkX, chunkY - 1) || this.isBorderChunk(dimension, chunkX + 1, chunkY) || this.isBorderChunk(dimension, chunkX, chunkY + 1) : this.isWorldChunk(dimension, chunkX - 1, chunkY) || this.isWorldChunk(dimension, chunkX, chunkY - 1) || this.isWorldChunk(dimension, chunkX + 1, chunkY) || this.isWorldChunk(dimension, chunkX, chunkY + 1))) {
                return WallChunk.create(chunkX, chunkY, dimension, this.platform);
            }
            return null;
        }
        return null;
    }

    protected boolean isReadyForFixups(Set<Point> regionsToExport, Set<Point> exportedRegions, Point coords) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                Point checkCoords;
                if (dx == 0 && dy == 0 || !regionsToExport.contains(checkCoords = new Point(coords.x + dx, coords.y + dy)) || exportedRegions.contains(checkCoords)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFixupsIfNecessary(File worldDir, Dimension dimension, Set<Point> regionsToExport, Map<Point, List<Fixup>> fixups, Set<Point> exportedRegions, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (this.performingFixups.tryAcquire()) {
            try {
                HashMap<Point, List<Fixup>> myFixups = new HashMap<Point, List<Fixup>>();
                Map<Point, List<Fixup>> map = fixups;
                synchronized (map) {
                    Iterator<Map.Entry<Point, List<Fixup>>> i = fixups.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<Point, List<Fixup>> entry = i.next();
                        Point fixupRegionCoords = entry.getKey();
                        if (!this.isReadyForFixups(regionsToExport, exportedRegions, fixupRegionCoords)) continue;
                        myFixups.put(fixupRegionCoords, entry.getValue());
                        i.remove();
                    }
                }
                if (!myFixups.isEmpty()) {
                    this.performFixups(worldDir, dimension, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.9f, 0.1f) : null), myFixups);
                }
            }
            finally {
                this.performingFixups.release();
            }
        }
    }

    protected void performFixups(File worldDir, Dimension dimension, ProgressReceiver progressReceiver, Map<Point, List<Fixup>> fixups) throws ProgressReceiver.OperationCancelled {
        long start = System.currentTimeMillis();
        int count = 0;
        int total = 0;
        for (Map.Entry<Point, List<Fixup>> entry : fixups.entrySet()) {
            total += entry.getValue().size();
        }
        try (CachingMinecraftWorld minecraftWorld = new CachingMinecraftWorld(worldDir, dimension.getAnchor().dim, dimension.getMinHeight(), dimension.getMaxHeight(), this.platform, false, 512);){
            BlockBasedExportSettings exportSettings = this.getExportSettings(dimension, this.platform);
            for (Map.Entry<Point, List<Fixup>> entry : fixups.entrySet()) {
                if (progressReceiver != null) {
                    progressReceiver.setMessage("Performing fixups for region " + entry.getKey().x + "," + entry.getKey().y);
                }
                List<Fixup> regionFixups = entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("Performing " + regionFixups.size() + " fixups for region " + entry.getKey().x + "," + entry.getKey().y);
                }
                for (Fixup fixup : regionFixups) {
                    fixup.fixup(minecraftWorld, dimension, this.platform, this.worldExportSettings, exportSettings);
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)(++count) / (float)total);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Fixups for " + fixups.size() + " regions took " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    protected void moveEntityTileData(Chunk toChunk, Chunk fromChunk, int x, int y, int z, int dy) {
        if (toChunk == fromChunk && dy == 0) {
            return;
        }
        int existingBlockDX = fromChunk.getxPos() << 4;
        int existingBlockDZ = fromChunk.getzPos() << 4;
        toChunk.getTileEntities().removeIf(entity -> entity.getY() == y && entity.getX() - existingBlockDX == x && entity.getZ() - existingBlockDZ == z);
        List<TileEntity> fromEntities = fromChunk.getTileEntities();
        for (TileEntity entity2 : fromEntities) {
            if (entity2.getY() != y - dy || entity2.getX() - existingBlockDX != x || entity2.getZ() - existingBlockDZ != z) continue;
            logger.debug("Moving tile entity " + entity2.getId() + " from  " + x + "," + (y - dy) + "," + z + " to  " + x + "," + y + "," + z);
            entity2.setY(y);
            toChunk.getTileEntities().add(entity2);
            break;
        }
        fromEntities.removeIf(entity -> entity.getY() == y - dy && entity.getX() - existingBlockDX == x && entity.getZ() - existingBlockDZ == z);
    }

    protected final ExecutorService createExecutorService(final String operation, int jobCount) {
        return MDCThreadPoolExecutor.newFixedThreadPool((int)ThreadUtils.chooseThreadCount(operation, jobCount), (ThreadFactory)new ThreadFactory(){
            private final ThreadGroup threadGroup;
            private int nextID;
            {
                this.threadGroup = new ThreadGroup(operation);
                this.nextID = 1;
            }

            @Override
            public synchronized Thread newThread(Runnable r) {
                Thread thread = new Thread(this.threadGroup, r, operation.toLowerCase().replaceAll("\\s+", "-") + "-" + this.nextID++);
                thread.setPriority(1);
                return thread;
            }
        });
    }

    protected final void applyWorldExportSettings(Collection<? extends Layer> layers) {
        Set<WorldExportSettings.Step> stepsToSkip = this.worldExportSettings.getStepsToSkip();
        if (stepsToSkip != null && !stepsToSkip.isEmpty()) {
            layers.removeIf(layer -> {
                boolean rc;
                boolean bl = rc = stepsToSkip.contains((Object)WorldExportSettings.Step.CAVES) && (layer instanceof Caverns || layer instanceof Chasms || layer instanceof Caves || layer instanceof TunnelLayer) || stepsToSkip.contains((Object)WorldExportSettings.Step.RESOURCES) && (layer instanceof Resources || layer instanceof UndergroundPocketsLayer);
                if (rc) {
                    logger.debug("Disabling layer {} due to world export settings", layer);
                }
                return rc;
            });
        }
    }

    protected final int getIntHeightAt(int dim, int x, int y) {
        Dimension dimension = this.world.getDimension(new Dimension.Anchor(dim, Dimension.Role.DETAIL, false, 0));
        Tile tile = dimension.getTile(x >> 7, y >> 7);
        if (tile != null) {
            Tile masterTile;
            if (tile.getBitLayerValue(NotPresent.INSTANCE, x & 0x7F, y & 0x7F) && (masterTile = this.getMasterTile(dim, x, y)) != null) {
                return masterTile.getIntHeight(x >> 4 & 0x7F, y >> 4 & 0x7F);
            }
            return tile.getIntHeight(x & 0x7F, y & 0x7F);
        }
        Tile masterTile = this.getMasterTile(dim, x, y);
        if (masterTile != null) {
            return masterTile.getIntHeight(x >> 4 & 0x7F, y >> 4 & 0x7F);
        }
        return Integer.MIN_VALUE;
    }

    protected final int getWaterLevelAt(int dim, int x, int y) {
        Dimension dimension = this.world.getDimension(new Dimension.Anchor(dim, Dimension.Role.DETAIL, false, 0));
        Tile tile = dimension.getTile(x >> 7, y >> 7);
        if (tile != null) {
            Tile masterTile;
            if (tile.getBitLayerValue(NotPresent.INSTANCE, x & 0x7F, y & 0x7F) && (masterTile = this.getMasterTile(dim, x, y)) != null) {
                return masterTile.getWaterLevel(x >> 4 & 0x7F, y >> 4 & 0x7F);
            }
            return tile.getWaterLevel(x & 0x7F, y & 0x7F);
        }
        Tile masterTile = this.getMasterTile(dim, x, y);
        if (masterTile != null) {
            return masterTile.getWaterLevel(x >> 4 & 0x7F, y >> 4 & 0x7F);
        }
        return Integer.MIN_VALUE;
    }

    private Tile getMasterTile(int dim, int x, int y) {
        Dimension masterDimension = this.world.getDimension(new Dimension.Anchor(dim, Dimension.Role.MASTER, false, 0));
        if (masterDimension != null) {
            return masterDimension.getTile(x >> 11, y >> 11);
        }
        return null;
    }

    private void mergeChunks(Chunk source, Chunk destination) {
        int maxHeight = source.getMaxHeight();
        if (maxHeight != destination.getMaxHeight()) {
            throw new IllegalArgumentException("Different maxHeights");
        }
        for (int y = 0; y < maxHeight; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Material destinationMaterial = destination.getMaterial(x, y, z);
                    if (destinationMaterial.solid) continue;
                    Material sourceMaterial = source.getMaterial(x, y, z);
                    if (!(destinationMaterial == Material.AIR ? sourceMaterial != Material.AIR : sourceMaterial.solid)) continue;
                    destination.setMaterial(x, y, z, sourceMaterial);
                    destination.setBlockLightLevel(x, y, z, source.getBlockLightLevel(x, y, z));
                    destination.setSkyLightLevel(x, y, z, source.getSkyLightLevel(x, y, z));
                    if (!sourceMaterial.tileEntity) continue;
                    this.moveEntityTileData(destination, source, x, y, z, 0);
                }
            }
        }
        for (Entity entity : source.getEntities()) {
            destination.getEntities().add(entity);
        }
    }

    private boolean isWorldChunk(Dimension dimension, int x, int y) {
        return dimension.isTilePresent(x >> 3, y >> 3);
    }

    private boolean isBorderChunk(Dimension dimension, int x, int y) {
        int tileX = x >> 3;
        int tileY = y >> 3;
        int borderSize = dimension.getBorderSize();
        if (dimension.getBorder() == null || borderSize == 0) {
            return false;
        }
        if (dimension.isTilePresent(tileX, tileY)) {
            return false;
        }
        for (int dx = -borderSize; dx <= borderSize; ++dx) {
            for (int dy = -borderSize; dy <= borderSize; ++dy) {
                if (!dimension.isTilePresent(tileX + dx, tileY + dy)) continue;
                return true;
            }
        }
        return false;
    }

    private Chest createGoodiesChest(Platform platform) {
        ArrayList<InventoryItem> list = new ArrayList<InventoryItem>();
        if (platform == DefaultPlugin.JAVA_MCREGION) {
            list.add(new InventoryItem(276, 0, 1, 0));
            list.add(new InventoryItem(277, 0, 1, 1));
            list.add(new InventoryItem(278, 0, 1, 2));
            list.add(new InventoryItem(279, 0, 1, 3));
            list.add(new InventoryItem(6, 0, 64, 4));
            list.add(new InventoryItem(6, 1, 64, 5));
            list.add(new InventoryItem(6, 2, 64, 6));
            list.add(new InventoryItem(39, 0, 64, 7));
            list.add(new InventoryItem(40, 0, 64, 8));
            list.add(new InventoryItem(352, 0, 64, 9));
            list.add(new InventoryItem(326, 0, 1, 10));
            list.add(new InventoryItem(326, 0, 1, 11));
            list.add(new InventoryItem(263, 0, 64, 12));
            list.add(new InventoryItem(265, 0, 64, 13));
            list.add(new InventoryItem(81, 0, 64, 14));
            list.add(new InventoryItem(338, 0, 64, 15));
            list.add(new InventoryItem(50, 0, 64, 16));
            list.add(new InventoryItem(355, 0, 1, 17));
            list.add(new InventoryItem(49, 0, 64, 18));
            list.add(new InventoryItem(259, 0, 1, 19));
            list.add(new InventoryItem(17, 0, 64, 20));
            list.add(new InventoryItem(58, 0, 1, 21));
            list.add(new InventoryItem(120, 0, 12, 22));
            list.add(new InventoryItem(381, 0, 12, 23));
        } else if (platform == DefaultPlugin.JAVA_ANVIL) {
            list.add(new InventoryItem("minecraft:diamond_sword", 1, 0));
            list.add(new InventoryItem("minecraft:diamond_shovel", 1, 1));
            list.add(new InventoryItem("minecraft:diamond_pickaxe", 1, 2));
            list.add(new InventoryItem("minecraft:diamond_axe", 1, 3));
            list.add(new InventoryItem("minecraft:sapling", 0, 64, 4));
            list.add(new InventoryItem("minecraft:sapling", 1, 64, 5));
            list.add(new InventoryItem("minecraft:sapling", 2, 64, 6));
            list.add(new InventoryItem("minecraft:brown_mushroom", 64, 7));
            list.add(new InventoryItem("minecraft:red_mushroom", 64, 8));
            list.add(new InventoryItem("minecraft:bone", 64, 9));
            list.add(new InventoryItem("minecraft:water_bucket", 1, 10));
            list.add(new InventoryItem("minecraft:water_bucket", 1, 11));
            list.add(new InventoryItem("minecraft:coal", 64, 12));
            list.add(new InventoryItem("minecraft:iron_ingot", 64, 13));
            list.add(new InventoryItem("minecraft:cactus", 64, 14));
            list.add(new InventoryItem("minecraft:reeds", 64, 15));
            list.add(new InventoryItem("minecraft:torch", 64, 16));
            list.add(new InventoryItem("minecraft:bed", 1, 17));
            list.add(new InventoryItem("minecraft:obsidian", 64, 18));
            list.add(new InventoryItem("minecraft:flint_and_steel", 1, 19));
            list.add(new InventoryItem("minecraft:log", 64, 20));
            list.add(new InventoryItem("minecraft:crafting_table", 1, 21));
            list.add(new InventoryItem("minecraft:end_portal_frame", 12, 22));
            list.add(new InventoryItem("minecraft:ender_eye", 12, 23));
        } else {
            list.add(new InventoryItem("minecraft:diamond_sword", 1, 0));
            list.add(new InventoryItem("minecraft:diamond_shovel", 1, 1));
            list.add(new InventoryItem("minecraft:diamond_pickaxe", 1, 2));
            list.add(new InventoryItem("minecraft:diamond_axe", 1, 3));
            list.add(new InventoryItem("minecraft:oak_sapling", 64, 4));
            list.add(new InventoryItem("minecraft:spruce_sapling", 64, 5));
            list.add(new InventoryItem("minecraft:birch_sapling", 64, 6));
            list.add(new InventoryItem("minecraft:brown_mushroom", 64, 7));
            list.add(new InventoryItem("minecraft:red_mushroom", 64, 8));
            list.add(new InventoryItem("minecraft:bone", 64, 9));
            list.add(new InventoryItem("minecraft:water_bucket", 1, 10));
            list.add(new InventoryItem("minecraft:water_bucket", 1, 11));
            list.add(new InventoryItem("minecraft:coal", 64, 12));
            list.add(new InventoryItem("minecraft:iron_ingot", 64, 13));
            list.add(new InventoryItem("minecraft:cactus", 64, 14));
            list.add(new InventoryItem("minecraft:sugar_cane", 64, 15));
            list.add(new InventoryItem("minecraft:torch", 64, 16));
            list.add(new InventoryItem("minecraft:red_bed", 1, 17));
            list.add(new InventoryItem("minecraft:obsidian", 64, 18));
            list.add(new InventoryItem("minecraft:flint_and_steel", 1, 19));
            list.add(new InventoryItem("minecraft:oak_log", 64, 20));
            list.add(new InventoryItem("minecraft:crafting_table", 1, 21));
            list.add(new InventoryItem("minecraft:end_portal_frame", 12, 22));
            list.add(new InventoryItem("minecraft:ender_eye", 12, 23));
        }
        Chest chest = new Chest(platform);
        chest.setItems(list);
        return chest;
    }

    private BlockBasedExportSettings getExportSettings(Dimension dimension, Platform platform) {
        ExportSettings dimensionExportSettings = dimension.getExportSettings();
        if (dimensionExportSettings instanceof BlockBasedExportSettings) {
            return (BlockBasedExportSettings)dimensionExportSettings;
        }
        BlockBasedExportSettings platformDefaultExportSettings = (BlockBasedExportSettings)this.platformProvider.getDefaultExportSettings(platform);
        return platformDefaultExportSettings != null ? platformDefaultExportSettings : DEFAULT_EXPORT_SETTINGS;
    }

    public static class ExportResults {
        public boolean chunksGenerated;
        public final ChunkFactory.Stats stats = new ChunkFactory.Stats();
        public List<Fixup> fixups;
    }
}

