/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17Biomes;

public interface Minecraft1_19Biomes
extends Minecraft1_17Biomes {
    public static final int BIOME_WINDSWEPT_HILLS = 3;
    public static final int BIOME_SNOWY_PLAINS = 12;
    public static final int BIOME_SPARSE_JUNGLE = 23;
    public static final int BIOME_STONY_SHORE = 25;
    public static final int BIOME_OLD_GROWTH_PINE_TAIGA = 32;
    public static final int BIOME_WINDSWEPT_FOREST = 34;
    public static final int BIOME_WOODED_BADLANDS = 38;
    public static final int BIOME_WINDSWEPT_GRAVELLY_HILLS = 131;
    public static final int BIOME_OLD_GROWTH_BIRCH_FOREST = 155;
    public static final int BIOME_OLD_GROWTH_SPRUCE_TAIGA = 160;
    public static final int BIOME_WINDSWEPT_SAVANNA = 163;
    public static final int BIOME_MANGROVE_SWAMP = 247;
    public static final int BIOME_DEEP_DARK = 248;
    public static final int BIOME_FROZEN_PEAKS = 249;
    public static final int BIOME_GROVE = 250;
    public static final int BIOME_JAGGED_PEAKS = 251;
    public static final int BIOME_MEADOW = 252;
    public static final int BIOME_SNOWY_SLOPES = 253;
    public static final int BIOME_STONY_PEAKS = 254;
    public static final int HIGHEST_BIOME_ID = 254;
    public static final String[] BIOME_NAMES = new String[]{"Ocean", "Plains", "Desert", "Windswept Hills", "Forest", "Taiga", "Swamp", "River", "Nether Wastes", "The End", "Frozen Ocean", "Frozen River", "Snowy Plains", "Snowy Mountains", "Mushroom Fields", "Mushroom Field Shore", "Beach", "Desert Hills", "Wooded Hills", "Taiga Hills", "Mountain Edge", "Jungle", "Jungle Hills", "Sparse Jungle", "Deep Ocean", "Stone Shore", "Snowy Beach", "Birch Forest", "Birch Forest Hills", "Dark Forest", "Snowy Taiga", "Snowy Taiga Hills", "Old Growth Pine Taiga", "Giant Tree Taiga Hills", "Windswept Forest", "Savanna", "Savanna Plateau", "Badlands", "Wooded Badlands", "Badlands Plateau", "Small End Islands", "End Midlands", "End Highlands", "End Barrens", "Warm Ocean", "Lukewarm Ocean", "Cold Ocean", "Deep Warm Ocean", "Deep Lukewarm Ocean", "Deep Cold Ocean", "Deep Frozen Ocean", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "The Void", null, "Sunflower Plains", "Desert Lakes", "Windswept Gravelly Hills", "Flower Forest", "Taiga Mountains", "Swamp Hills", null, null, null, null, null, "Ice Spikes", null, null, null, null, null, null, null, null, "Modified Jungle", null, "Modified Jungle Edge", null, null, null, "Old Growth Birch Forest", "Tall Birch Hills", "Dark Forest Hills", "Snowy Taiga Mountains", null, "Old Growth Spruce Taiga", "Giant Spruce Taiga Hills", "Modified Gravelly Mountains", "Windswept Savanna", "Shattered Savanna Plateau", "Eroded Badlands", "Modified Wooded Badlands Plateau", "Modified Badlands Plateau", "Bamboo Jungle", "Bamboo Jungle Hills", "Soul Sand Valley", "Crimson Forest", "Warped Forest", "Basalt Deltas", "Dripstone Caves", "Lush Caves", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "Mangrove Swamp", "Deep Dark", "Frozen Peaks", "Grove", "Jagged Peaks", "Meadow", "Snowy Slopes", "Stony Peaks", null};
    public static final String[] MODERN_IDS = new String[]{"minecraft:ocean", "minecraft:plains", "minecraft:desert", "minecraft:windswept_hills", "minecraft:forest", "minecraft:taiga", "minecraft:swamp", "minecraft:river", "minecraft:nether_wastes", "minecraft:the_end", "minecraft:frozen_ocean", "minecraft:frozen_river", "minecraft:snowy_plains", "minecraft:snowy_plains", "minecraft:mushroom_fields", "minecraft:mushroom_fields", "minecraft:beach", "minecraft:desert", "minecraft:forest", "minecraft:taiga", "minecraft:windswept_hills", "minecraft:jungle", "minecraft:jungle", "minecraft:sparse_jungle", "minecraft:deep_ocean", "minecraft:stony_shore", "minecraft:snowy_beach", "minecraft:birch_forest", "minecraft:birch_forest", "minecraft:dark_forest", "minecraft:snowy_taiga", "minecraft:snowy_taiga", "minecraft:old_growth_pine_taiga", "minecraft:old_growth_pine_taiga", "minecraft:windswept_forest", "minecraft:savanna", "minecraft:savanna_plateau", "minecraft:badlands", "minecraft:wooded_badlands", "minecraft:badlands", "minecraft:small_end_islands", "minecraft:end_midlands", "minecraft:end_highlands", "minecraft:end_barrens", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:cold_ocean", "minecraft:warm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_frozen_ocean", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "minecraft:the_void", null, "minecraft:sunflower_plains", "minecraft:desert", "minecraft:windswept_gravelly_hills", "minecraft:flower_forest", "minecraft:taiga", "minecraft:swamp", null, null, null, null, null, "minecraft:ice_spikes", null, null, null, null, null, null, null, null, "minecraft:jungle", null, "minecraft:sparse_jungle", null, null, null, "minecraft:old_growth_birch_forest", "minecraft:old_growth_birch_forest", "minecraft:dark_forest", "minecraft:snowy_taiga", null, "minecraft:old_growth_spruce_taiga", "minecraft:old_growth_spruce_taiga", "minecraft:windswept_gravelly_hills", "minecraft:windswept_savanna", "minecraft:windswept_savanna", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:badlands", "minecraft:bamboo_jungle", "minecraft:bamboo_jungle", "minecraft:soul_sand_valley", "minecraft:crimson_forest", "minecraft:warped_forest", "minecraft:basalt_deltas", "minecraft:dripstone_caves", "minecraft:lush_caves", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "minecraft:mangrove_swamp", "minecraft:deep_dark", "minecraft:frozen_peaks", "minecraft:grove", "minecraft:jagged_peaks", "minecraft:meadow", "minecraft:snowy_slopes", "minecraft:stony_peaks", null};
    public static final Map<String, Integer> BIOMES_BY_MODERN_ID = StaticInitialiser.access$000();
    public static final boolean[][][] BIOME_PATTERNS = StaticInitialiser.access$100();

    public static class StaticInitialiser {
        private static boolean[][][] loadPatterns() {
            boolean[][][] patterns = new boolean[256][][];
            try {
                BufferedImage image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/swamp_pattern.png"));
                patterns[6] = StaticInitialiser.createPattern(image);
                patterns[134] = StaticInitialiser.createPattern(image);
                patterns[247] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/mountains_pattern.png"));
                patterns[3] = StaticInitialiser.createPattern(image);
                patterns[131] = StaticInitialiser.createPattern(image);
                patterns[34] = StaticInitialiser.createPattern(image);
                patterns[162] = StaticInitialiser.createPattern(image);
                patterns[13] = StaticInitialiser.createPattern(image);
                patterns[42] = StaticInitialiser.createPattern(image);
                patterns[249] = StaticInitialiser.createPattern(image);
                patterns[251] = StaticInitialiser.createPattern(image);
                patterns[254] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/deciduous_trees_pattern.png"));
                patterns[4] = StaticInitialiser.createPattern(image);
                patterns[132] = StaticInitialiser.createPattern(image);
                patterns[171] = StaticInitialiser.createPattern(image);
                patterns[172] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/roofed_trees_pattern.png"));
                patterns[29] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/birch_trees_pattern.png"));
                patterns[27] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/spruce_trees_pattern.png"));
                patterns[5] = StaticInitialiser.createPattern(image);
                patterns[30] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/pine_trees_pattern.png"));
                patterns[32] = StaticInitialiser.createPattern(image);
                patterns[160] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/hills_pattern.png"));
                patterns[17] = StaticInitialiser.createPattern(image);
                patterns[20] = StaticInitialiser.createPattern(image);
                patterns[41] = StaticInitialiser.createPattern(image);
                patterns[253] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/deciduous_hills_pattern.png"));
                patterns[18] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/roofed_hills_pattern.png"));
                patterns[157] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/birch_hills_pattern.png"));
                patterns[155] = StaticInitialiser.createPattern(image);
                patterns[28] = StaticInitialiser.createPattern(image);
                patterns[156] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/spruce_hills_pattern.png"));
                patterns[133] = StaticInitialiser.createPattern(image);
                patterns[19] = StaticInitialiser.createPattern(image);
                patterns[31] = StaticInitialiser.createPattern(image);
                patterns[158] = StaticInitialiser.createPattern(image);
                patterns[250] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/pine_hills_pattern.png"));
                patterns[33] = StaticInitialiser.createPattern(image);
                patterns[161] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/jungle_trees_pattern.png"));
                patterns[21] = StaticInitialiser.createPattern(image);
                patterns[168] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/jungle_hills_pattern.png"));
                patterns[22] = StaticInitialiser.createPattern(image);
                patterns[149] = StaticInitialiser.createPattern(image);
                patterns[169] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/savanna_pattern.png"));
                patterns[35] = StaticInitialiser.createPattern(image);
                patterns[36] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/savanna_hills_pattern.png"));
                patterns[163] = StaticInitialiser.createPattern(image);
                patterns[164] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/mesa_pattern.png"));
                patterns[37] = StaticInitialiser.createPattern(image);
                patterns[39] = StaticInitialiser.createPattern(image);
                patterns[38] = StaticInitialiser.createPattern(image);
                patterns[166] = StaticInitialiser.createPattern(image);
                patterns[167] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/mesa_bryce_pattern.png"));
                patterns[165] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/jungle_edge_pattern.png"));
                patterns[23] = StaticInitialiser.createPattern(image);
                image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/jungle_edge_hills_pattern.png"));
                patterns[151] = StaticInitialiser.createPattern(image);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error loading image", e);
            }
            return patterns;
        }

        private static boolean[][] createPattern(BufferedImage image) {
            boolean[][] pattern = new boolean[16][];
            for (int x = 0; x < 16; ++x) {
                pattern[x] = new boolean[16];
                for (int y = 0; y < 16; ++y) {
                    pattern[x][y] = image.getRGB(x, y) != -1;
                }
            }
            return pattern;
        }

        private static Map<String, Integer> biomesByModernId() {
            HashMap<String, Integer> biomesByModernId = new HashMap<String, Integer>();
            for (int i = 0; i < 256; ++i) {
                if (MODERN_IDS[i] == null || biomesByModernId.containsKey(MODERN_IDS[i])) continue;
                biomesByModernId.put(MODERN_IDS[i], i);
            }
            return Collections.unmodifiableMap(biomesByModernId);
        }

        static /* synthetic */ Map access$000() {
            return StaticInitialiser.biomesByModernId();
        }

        static /* synthetic */ boolean[][][] access$100() {
            return StaticInitialiser.loadPatterns();
        }
    }
}

