/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.util.Checksum;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_12JarBiomeScheme;

public final class Minecraft1_12LargeBiomeScheme
extends Minecraft1_12JarBiomeScheme {
    private Object largeBiomesGenerator;
    private static final Map<Checksum, String[]> HASHES_TO_CLASSNAMES = new HashMap<Checksum, String[]>();

    public Minecraft1_12LargeBiomeScheme(File minecraftJar, File libDir, Checksum md5Sum) {
        super(minecraftJar, libDir, md5Sum, HASHES_TO_CLASSNAMES);
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.seed || this.landscape == null) {
            try {
                this.landscape = ((Object[])this.getLandscapesMethod.invoke(null, seed, this.largeBiomesGenerator, null))[1];
                this.seed = seed;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access denied while trying to set the seed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while trying to set the seed", e);
            }
        }
    }

    @Override
    protected void init(String[] classNames, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        super.init(classNames, classLoader);
        Field field = this.worldGeneratorClass.getField("d");
        this.largeBiomesGenerator = field.get(null);
    }

    static {
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{-116, 4, 67, -122, -117, -98, 70, -57, 125, 57, -37, 97, -57, 85, 103, -99}), new String[]{"bdq", "bdo", "amz", "ni", "ayx"});
    }
}

