/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pepsoft.util.Checksum;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.Version;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_10BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_10LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_12BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_12LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_1BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_2BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_3LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_6BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_6LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_7BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_7LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_8BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_8LargeBiomeScheme;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiomeSchemeManager {
    private static final Map<Checksum, Set<BiomeSchemeDescriptor>> DESCRIPTORS = new HashMap<Checksum, Set<BiomeSchemeDescriptor>>();
    private static final Map<Integer, BiomeScheme> BIOME_SCHEMES = new HashMap<Integer, BiomeScheme>();
    private static final Map<Integer, SortedMap<Version, BiomeJar>> BIOME_JARS = new HashMap<Integer, SortedMap<Version, BiomeJar>>();
    private static final SortedMap<Version, File> ALL_JARS = new TreeMap<Version, File>();
    private static final Object initialisationLock = new Object();
    private static File minecraftDir;
    private static boolean initialised;
    private static boolean initialising;
    private static final Pattern VERSION_NUMBERS_ONLY;
    private static final Logger logger;

    public static BiomeScheme getNewBiomeScheme(int biomeAlgorithm) {
        return BiomeSchemeManager.getBiomeScheme(biomeAlgorithm, false);
    }

    public static BiomeScheme getSharedBiomeScheme(int biomeAlgorithm) {
        return BiomeSchemeManager.getBiomeScheme(biomeAlgorithm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BiomeScheme getBiomeScheme(int biomeAlgorithm, boolean shared) {
        String version;
        if (logger.isTraceEnabled()) {
            logger.trace("Thread {} requesting biome scheme {}", new Object[]{Thread.currentThread().getName(), biomeAlgorithm, new Throwable("Invoked from")});
        }
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        if (shared && BIOME_SCHEMES.containsKey(biomeAlgorithm)) {
            return BIOME_SCHEMES.get(biomeAlgorithm);
        }
        switch (biomeAlgorithm) {
            case 4: {
                version = "1.1";
                break;
            }
            case 5: {
                version = "1.6.4 or 1.2.3 - 1.6.2";
                break;
            }
            case 8: {
                version = "1.6.4 or 1.3.1 - 1.6.2";
                break;
            }
            case 9: {
                version = "1.12.2 or 1.7.2 - 1.10.2";
                break;
            }
            case 10: {
                version = "1.12.2 or 1.7.2 - 1.10.2";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        SortedMap<Version, BiomeJar> biomeJars = BIOME_JARS.get(biomeAlgorithm);
        if (biomeJars != null && !biomeJars.isEmpty()) {
            if (Configuration.getInstance().isSafeMode()) {
                logger.info("[SAFE MODE] Not creating biome scheme");
                return null;
            }
            BiomeJar biomeJar = (BiomeJar)biomeJars.get(biomeJars.lastKey());
            logger.info("Creating biome scheme " + version + " from " + biomeJar.file.getAbsolutePath());
            try {
                BiomeScheme biomeScheme = biomeJar.descriptor.instantiate(biomeJar.file, minecraftDir, biomeJar.checksum);
                if (shared) {
                    BIOME_SCHEMES.put(biomeAlgorithm, biomeScheme);
                }
                return biomeScheme;
            }
            catch (Error | RuntimeException e) {
                logger.error("{} while instantiating biome scheme of type {} from {}", new Object[]{e.getClass().getSimpleName(), biomeJar.descriptor._class.getName(), biomeJar.file.getAbsolutePath(), e});
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Could not find compatible jar for biome scheme " + version);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<Version, File> getAllMinecraftJars() {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        return Collections.unmodifiableSortedMap(ALL_JARS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getLatestMinecraftVersion() {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        return ALL_JARS.isEmpty() ? null : ALL_JARS.lastKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getMinecraftJar(Version version) {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        return (File)ALL_JARS.get(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getLatestMinecraftJar() {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        return ALL_JARS.isEmpty() ? null : (File)ALL_JARS.get(ALL_JARS.lastKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getMinecraftJarNoNewerThan(Version version) {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        return ALL_JARS.entrySet().stream().filter(e -> ((Version)e.getKey()).compareTo(version) <= 0).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getMinecraftJarNoOlderThan(Version version) {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        return ALL_JARS.entrySet().stream().filter(e -> ((Version)e.getKey()).compareTo(version) >= 0).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue).orElse(null);
    }

    public static BufferedImage createImage(BiomeScheme biomeScheme, int biome, ColourScheme colourScheme) {
        int backgroundColour = biomeScheme.getColour(biome, colourScheme);
        boolean[][] pattern = biomeScheme.getPattern(biome);
        BufferedImage image = new BufferedImage(16, 16, 1);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if (pattern != null && pattern[x][y]) {
                    image.setRGB(x, y, 0);
                    continue;
                }
                image.setRGB(x, y, backgroundColour);
            }
        }
        return GUIUtils.scaleToUI((Image)image, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getAvailableBiomeAlgorithms() {
        Object object = initialisationLock;
        synchronized (object) {
            if (!initialised) {
                BiomeSchemeManager.initialise();
            }
        }
        ArrayList<Integer> availableBiomeAlgorithms = new ArrayList<Integer>(BIOME_JARS.keySet());
        availableBiomeAlgorithms.sort(Comparator.reverseOrder());
        return availableBiomeAlgorithms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialiseInBackground() {
        Object object = initialisationLock;
        synchronized (object) {
            if (initialised || initialising) {
                return;
            }
            initialising = true;
            new Thread(() -> {
                try {
                    BiomeSchemeManager.doInitialisation();
                }
                catch (Throwable t) {
                    logger.error(t.getClass().getSimpleName() + " while scanning for Minecraft jars", t);
                }
            }, "Biome Scheme Manager Initialiser").start();
        }
    }

    private static void scanDir(File dir) {
        File[] files = dir.listFiles(file -> {
            String name = file.getName().toLowerCase();
            return file.isDirectory() && VERSION_NUMBERS_ONLY.matcher(name).matches() || name.endsWith(".jar") && VERSION_NUMBERS_ONLY.matcher(name.substring(0, name.length() - 4)).matches();
        });
        if (files != null) {
            for (File file2 : files) {
                try {
                    Checksum hash;
                    if (file2.isDirectory()) {
                        BiomeSchemeManager.scanDir(file2);
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Scanning file {}", (Object)file2);
                    }
                    if (DESCRIPTORS.containsKey(hash = FileUtils.getMD5((File)file2))) {
                        for (BiomeSchemeDescriptor descriptor : DESCRIPTORS.get(hash)) {
                            BIOME_JARS.computeIfAbsent(descriptor.biomeScheme, k -> new TreeMap()).put(descriptor.minecraftVersion, new BiomeJar(file2, hash, descriptor));
                            ALL_JARS.put(descriptor.minecraftVersion, file2);
                        }
                        continue;
                    }
                    Version version = Version.parse((String)file2.getName().substring(0, file2.getName().length() - 4));
                    ALL_JARS.put(version, file2);
                }
                catch (IOException e) {
                    logger.error("I/O error while scanning potential Minecraft jar or directory " + file2.getAbsolutePath() + "; skipping file", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialise() {
        Object object = initialisationLock;
        synchronized (object) {
            if (initialised) {
                return;
            }
            if (initialising) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Thread {} waiting for another thread to finish initialisation", (Object)Thread.currentThread().getName());
                }
                while (initialising) {
                    try {
                        initialisationLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Thread interrupted while waiting for biome scheme manager initialisation", e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Thread {} continuing", (Object)Thread.currentThread().getName());
                }
                return;
            }
            BiomeSchemeManager.doInitialisation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInitialisation() {
        Object object = initialisationLock;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("Performing initialisation on thread {}", (Object)Thread.currentThread().getName());
            }
            try {
                minecraftDir = MinecraftUtil.findMinecraftDir();
                if (minecraftDir != null) {
                    BiomeSchemeManager.scanDir(new File(minecraftDir, "versions"));
                }
                HashSet processedFiles = new HashSet();
                for (Map.Entry<Integer, SortedMap<Version, BiomeJar>> entry : BIOME_JARS.entrySet()) {
                    processedFiles.addAll(entry.getValue().values().stream().map(biomeJar -> biomeJar.file).collect(Collectors.toList()));
                }
                Configuration config = Configuration.getInstance();
                Map<Integer, File> minecraftJars = config.getMinecraftJars();
                Iterator<Map.Entry<Integer, File>> i = minecraftJars.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<Integer, File> entry = i.next();
                    File file = entry.getValue();
                    String name = file.getName();
                    if (name.length() <= 4 || !VERSION_NUMBERS_ONLY.matcher(name.substring(0, name.length() - 4)).matches()) {
                        i.remove();
                        continue;
                    }
                    if (processedFiles.contains(file)) continue;
                    if (!file.isFile() || !file.canRead()) {
                        i.remove();
                        continue;
                    }
                    try {
                        Checksum checksum = FileUtils.getMD5((File)file);
                        if (DESCRIPTORS.containsKey(checksum)) {
                            for (BiomeSchemeDescriptor descriptor : DESCRIPTORS.get(checksum)) {
                                SortedMap jars = BIOME_JARS.computeIfAbsent(descriptor.biomeScheme, key -> new TreeMap());
                                jars.put(descriptor.minecraftVersion, new BiomeJar(file, checksum, descriptor));
                                ALL_JARS.put(descriptor.minecraftVersion, file);
                            }
                            continue;
                        }
                        Version version = Version.parse((String)name.substring(0, name.length() - 4));
                        ALL_JARS.put(version, file);
                    }
                    catch (IOException e) {
                        logger.error("I/O error while scanning Minecraft jar " + file.getAbsolutePath() + "; skipping file", (Throwable)e);
                    }
                }
            }
            finally {
                initialised = true;
                initialising = false;
                initialisationLock.notifyAll();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Thread {} finished initialisation", (Object)Thread.currentThread().getName());
            }
        }
    }

    private static void addDescriptor(Checksum checksum, BiomeSchemeDescriptor descriptor) {
        Set descriptors = DESCRIPTORS.computeIfAbsent(checksum, key -> new HashSet());
        descriptors.add(descriptor);
    }

    static {
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-23, 35, 2, -46, -84, -37, -89, -55, 126, 13, -115, -15, -31, 13, 32, 6}), new BiomeSchemeDescriptor(new Version(new int[]{1, 1}), 4, Minecraft1_1BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{18, -10, -60, -79, -67, -52, 99, -16, 41, -29, -64, -120, -93, 100, -72, -28}), new BiomeSchemeDescriptor(new Version(new int[]{1, 2, 3}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{37, 66, 62, -85, 109, -121, 7, -7, 108, -58, -83, -118, 33, -89, 37, 10}), new BiomeSchemeDescriptor(new Version(new int[]{1, 2, 4}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-114, -121, 120, 7, -118, 23, 90, 51, 96, 58, 88, 82, 87, -14, -123, 99}), new BiomeSchemeDescriptor(new Version(new int[]{1, 2, 5}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{38, 108, -53, -55, 121, -118, -3, 46, -83, -13, -42, -64, 27, 76, 86, 42}), new BiomeSchemeDescriptor(new Version(new int[]{1, 3, 1}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-106, -106, -103, -15, 62, 91, -66, 127, 18, -28, 10, -60, -13, 43, 125, -102}), new BiomeSchemeDescriptor(new Version(new int[]{1, 3, 2}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{119, 17, 117, -64, 23, 120, -22, 103, 57, 91, -58, -111, -102, 90, -99, -59}), new BiomeSchemeDescriptor(new Version(new int[]{1, 4, 2}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-114, -128, -5, 1, -77, 33, -58, -77, -57, -17, -54, 57, 122, 62, -22, 53}), new BiomeSchemeDescriptor(new Version(new int[]{1, 4, 7}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{92, 18, 25, -40, 105, -72, 125, 35, 61, -29, 3, 54, -120, -20, 117, 103}), new BiomeSchemeDescriptor(new Version(new int[]{1, 5, 1}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{104, -105, -61, 40, 127, -71, 113, -55, -13, 98, -21, 58, -78, 15, 93, -35}), new BiomeSchemeDescriptor(new Version(new int[]{1, 5, 2}), 5, Minecraft1_2BiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-106, -106, -103, -15, 62, 91, -66, 127, 18, -28, 10, -60, -13, 43, 125, -102}), new BiomeSchemeDescriptor(new Version(new int[]{1, 3, 2}), 8, Minecraft1_3LargeBiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{119, 17, 117, -64, 23, 120, -22, 103, 57, 91, -58, -111, -102, 90, -99, -59}), new BiomeSchemeDescriptor(new Version(new int[]{1, 4, 2}), 8, Minecraft1_3LargeBiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-114, -128, -5, 1, -77, 33, -58, -77, -57, -17, -54, 57, 122, 62, -22, 53}), new BiomeSchemeDescriptor(new Version(new int[]{1, 4, 7}), 8, Minecraft1_3LargeBiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{92, 18, 25, -40, 105, -72, 125, 35, 61, -29, 3, 54, -120, -20, 117, 103}), new BiomeSchemeDescriptor(new Version(new int[]{1, 5, 1}), 8, Minecraft1_3LargeBiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{104, -105, -61, 40, 127, -71, 113, -55, -13, 98, -21, 58, -78, 15, 93, -35}), new BiomeSchemeDescriptor(new Version(new int[]{1, 5, 2}), 8, Minecraft1_3LargeBiomeScheme.class, false));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{29, 67, -51, -70, -117, -105, 82, -41, -11, 87, -85, 125, 62, 54, 89, 100}), new BiomeSchemeDescriptor(new Version(new int[]{1, 6, 2}), 5, Minecraft1_6BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{46, 80, 68, -11, 53, -98, -126, 36, 85, 81, 22, 122, 35, 127, 49, 103}), new BiomeSchemeDescriptor(new Version(new int[]{1, 6, 4}), 5, Minecraft1_6BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{29, 67, -51, -70, -117, -105, 82, -41, -11, 87, -85, 125, 62, 54, 89, 100}), new BiomeSchemeDescriptor(new Version(new int[]{1, 6, 2}), 8, Minecraft1_6LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{46, 80, 68, -11, 53, -98, -126, 36, 85, 81, 22, 122, 35, 127, 49, 103}), new BiomeSchemeDescriptor(new Version(new int[]{1, 6, 4}), 8, Minecraft1_6LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{122, 48, 69, 84, -3, -22, -121, -102, 121, -98, -2, 110, -82, -35, -116, -107}), new BiomeSchemeDescriptor(new Version(new int[]{1, 7, 2}), 9, Minecraft1_7BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{95, 124, -57, -21, 1, -53, -39, 53, -87, -105, 60, -74, -23, -60, -63, 14}), new BiomeSchemeDescriptor(new Version(new int[]{1, 7, 9}), 9, Minecraft1_7BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-122, 99, -95, 12, -20, -63, 14, -86, 104, 58, -110, 126, -11, 55, 24, 82}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8}), 9, Minecraft1_8BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{92, -102, -81, 49, 25, -97, 118, 62, -7, 8, 92, -55, -74, -112, 43, 29}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 1}), 9, Minecraft1_8BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-108, 55, -76, -114, 5, 27, 12, -24, -127, 124, -104, -98, 89, -25, -103, 79}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 3}), 9, Minecraft1_8BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{101, -123, -119, 23, -111, -32, -41, 93, -59, 76, -5, 84, 122, -122, 109, -80}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 8}), 9, Minecraft1_8BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{57, 96, -103, -30, 62, 88, 48, -99, 33, 113, 58, -75, -41, -63, -47, -88}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 9}), 9, Minecraft1_8BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-66, 112, 66, 2, 51, 112, -101, 61, 119, -113, 118, 39, -35, 80, -34, 98}), new BiomeSchemeDescriptor(new Version(new int[]{1, 9}), 9, Minecraft1_8BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{55, -8, 13, 38, 104, 114, -20, 17, 86, 10, -80, -119, 95, 124, -10, 59}), new BiomeSchemeDescriptor(new Version(new int[]{1, 10, 2}), 9, Minecraft1_10BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-116, 4, 67, -122, -117, -98, 70, -57, 125, 57, -37, 97, -57, 85, 103, -99}), new BiomeSchemeDescriptor(new Version(new int[]{1, 12, 2}), 9, Minecraft1_12BiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{122, 48, 69, 84, -3, -22, -121, -102, 121, -98, -2, 110, -82, -35, -116, -107}), new BiomeSchemeDescriptor(new Version(new int[]{1, 7, 2}), 10, Minecraft1_7LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{95, 124, -57, -21, 1, -53, -39, 53, -87, -105, 60, -74, -23, -60, -63, 14}), new BiomeSchemeDescriptor(new Version(new int[]{1, 7, 9}), 10, Minecraft1_7LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-122, 99, -95, 12, -20, -63, 14, -86, 104, 58, -110, 126, -11, 55, 24, 82}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8}), 10, Minecraft1_8LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{92, -102, -81, 49, 25, -97, 118, 62, -7, 8, 92, -55, -74, -112, 43, 29}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 1}), 10, Minecraft1_8LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-108, 55, -76, -114, 5, 27, 12, -24, -127, 124, -104, -98, 89, -25, -103, 79}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 3}), 10, Minecraft1_8LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{101, -123, -119, 23, -111, -32, -41, 93, -59, 76, -5, 84, 122, -122, 109, -80}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 8}), 10, Minecraft1_8LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{57, 96, -103, -30, 62, 88, 48, -99, 33, 113, 58, -75, -41, -63, -47, -88}), new BiomeSchemeDescriptor(new Version(new int[]{1, 8, 9}), 10, Minecraft1_8LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-66, 112, 66, 2, 51, 112, -101, 61, 119, -113, 118, 39, -35, 80, -34, 98}), new BiomeSchemeDescriptor(new Version(new int[]{1, 9}), 10, Minecraft1_8LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{55, -8, 13, 38, 104, 114, -20, 17, 86, 10, -80, -119, 95, 124, -10, 59}), new BiomeSchemeDescriptor(new Version(new int[]{1, 10, 2}), 10, Minecraft1_10LargeBiomeScheme.class, true));
        BiomeSchemeManager.addDescriptor(new Checksum(new byte[]{-116, 4, 67, -122, -117, -98, 70, -57, 125, 57, -37, 97, -57, 85, 103, -99}), new BiomeSchemeDescriptor(new Version(new int[]{1, 12, 2}), 10, Minecraft1_12LargeBiomeScheme.class, true));
        VERSION_NUMBERS_ONLY = Pattern.compile("([0-9]+\\.)*[0-9]+");
        logger = LoggerFactory.getLogger(BiomeSchemeManager.class);
    }

    static class BiomeJar {
        final File file;
        final Checksum checksum;
        final BiomeSchemeDescriptor descriptor;

        BiomeJar(File file, Checksum checksum, BiomeSchemeDescriptor descriptor) {
            this.file = file;
            this.checksum = checksum;
            this.descriptor = descriptor;
        }
    }

    static class BiomeSchemeDescriptor {
        final Version minecraftVersion;
        final int biomeScheme;
        final Class<? extends BiomeScheme> _class;
        final Constructor<? extends BiomeScheme> constructor;
        private final boolean addLibraries;

        BiomeSchemeDescriptor(Version minecraftVersion, int biomeScheme, Class<? extends BiomeScheme> _class, boolean addLibraries) {
            this.minecraftVersion = minecraftVersion;
            this.biomeScheme = biomeScheme;
            this._class = _class;
            this.addLibraries = addLibraries;
            try {
                this.constructor = addLibraries ? _class.getConstructor(File.class, File.class, Checksum.class) : _class.getConstructor(File.class, Checksum.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public BiomeScheme instantiate(File jarFile, File minecraftDir, Checksum checksum) {
            try {
                if (this.addLibraries) {
                    File libDir = new File(minecraftDir, "libraries");
                    return this.constructor.newInstance(jarFile, libDir, checksum);
                }
                return this.constructor.newInstance(jarFile, checksum);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not instantiate biome scheme", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access denied while instantiating biome scheme", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while instantiating biome scheme", e);
            }
        }
    }
}

