/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

@Deprecated
public final class World
implements TileProvider,
Serializable,
Tile.Listener {
    private final long seed = 0L;
    private final Map<Point, Tile> tiles = new HashMap<Point, Tile>();
    private final TileFactory tileFactory = null;
    private final int lowestX = Integer.MAX_VALUE;
    private final int highestX = Integer.MIN_VALUE;
    private final int lowestY = Integer.MAX_VALUE;
    private final int highestY = Integer.MIN_VALUE;
    private final String name = "Generated World";
    private Terrain subsurfaceMaterial = Terrain.RESOURCES;
    private boolean createGoodiesChest = true;
    private boolean populate;
    private Border border;
    private int borderLevel = 4;
    private boolean darkLevel;
    private boolean bedrockWall;
    private Point spawnPoint = new Point(15, 0);
    private File importedFrom;
    private Map<Layer, ExporterSettings> layerSettings = new HashMap<Layer, ExporterSettings>();
    private long minecraftSeed = Long.MIN_VALUE;
    private static final long serialVersionUID = 2011032801L;

    private World() {
    }

    public boolean isDirty() {
        return false;
    }

    public void setDirty(boolean dirty) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public long getSeed() {
        return 0L;
    }

    public String getName() {
        return "Generated World";
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Terrain getSubsurfaceMaterial() {
        return this.subsurfaceMaterial;
    }

    public void setSubsurfaceMaterial(Terrain subsurfaceMaterial) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public boolean isCreateGoodiesChest() {
        return this.createGoodiesChest;
    }

    public void setCreateGoodiesChest(boolean createGoodiesChest) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public boolean isPopulate() {
        return this.populate;
    }

    public void setPopulate(boolean populate) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public int getBorderLevel() {
        return this.borderLevel;
    }

    public void setBorderLevel(int borderLevel) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public boolean isDarkLevel() {
        return this.darkLevel;
    }

    public void setDarkLevel(boolean darkLevel) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public boolean isBedrockWall() {
        return this.bedrockWall;
    }

    public void setBedrockWall(boolean bedrockWall) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public TileFactory getTileFactory() {
        return this.tileFactory;
    }

    @Override
    public boolean isTilePresent(int x, int y) {
        return this.tiles.containsKey(new Point(x, y));
    }

    @Override
    public Tile getTile(int x, int y) {
        return this.tiles.get(new Point(x, y));
    }

    public Tile getTile(Point coords) {
        return this.getTile(coords.x, coords.y);
    }

    @Override
    public Rectangle getExtent() {
        return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 2, 2);
    }

    public Collection<Tile> getTiles() {
        return new ArrayList<Tile>(this.tiles.values());
    }

    public void addTile(Tile tile) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void removeTile(Tile tile) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public int getHighestX() {
        return Integer.MIN_VALUE;
    }

    public int getHighestY() {
        return Integer.MIN_VALUE;
    }

    public int getLowestX() {
        return Integer.MAX_VALUE;
    }

    public int getLowestY() {
        return Integer.MAX_VALUE;
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public Point getTileCoordinates(int worldX, int worldY) {
        int tileX = (int)Math.floor((double)worldX / 128.0);
        int tileY = (int)Math.floor((double)worldY / 128.0);
        return new Point(tileX, tileY);
    }

    public Point getTileCoordinates(Point worldCoords) {
        return this.getTileCoordinates(worldCoords.x, worldCoords.y);
    }

    public float getHeightAt(int x, int y) {
        Point tileCoords = this.getTileCoordinates(x, y);
        Tile tile = this.getTile(tileCoords);
        if (tile != null) {
            return tile.getHeight(x & 0x7F, y & 0x7F);
        }
        return -3.4028235E38f;
    }

    public float getHeightAt(Point coords) {
        return this.getHeightAt(coords.x, coords.y);
    }

    public void setHeightAt(int x, int y, float height) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void setHeightAt(Point coords, int height) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Terrain getTerrainAt(int x, int y) {
        Point tileCoords = this.getTileCoordinates(x, y);
        Tile tile = this.getTile(tileCoords);
        if (tile != null) {
            return tile.getTerrain(x & 0x7F, y & 0x7F);
        }
        return null;
    }

    public void setTerrainAt(int x, int y, Terrain terrain) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void setTerrainAt(Point coords, Terrain terrain) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void applyTheme(int x, int y) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public int getWaterLevelAt(int x, int y) {
        Point tileCoords = this.getTileCoordinates(x, y);
        Tile tile = this.getTile(tileCoords);
        if (tile != null) {
            return tile.getWaterLevel(x & 0x7F, y & 0x7F);
        }
        return Integer.MIN_VALUE;
    }

    public int getWaterLevelAt(Point coords) {
        return this.getWaterLevelAt(coords.x, coords.y);
    }

    public void setWaterLevelAt(int x, int y, int waterLevel) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public int getLayerValueAt(Layer layer, int x, int y) {
        Point tileCoords = this.getTileCoordinates(x, y);
        Tile tile = this.getTile(tileCoords);
        if (tile != null) {
            return tile.getLayerValue(layer, x & 0x7F, y & 0x7F);
        }
        return 0;
    }

    public void setLayerValueAt(Layer layer, int x, int y, int value) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public boolean getBitLayerValueAt(Layer layer, int x, int y) {
        Point tileCoords = this.getTileCoordinates(x, y);
        Tile tile = this.getTile(tileCoords);
        if (tile != null) {
            return tile.getBitLayerValue(layer, x & 0x7F, y & 0x7F);
        }
        return false;
    }

    public void setBitLayerValueAt(Layer layer, int x, int y, boolean value) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void setEventsInhibited(boolean eventsInhibited) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public boolean isEventsInhibited() {
        return false;
    }

    public Point getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(Point spawnPoint) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public File getImportedFrom() {
        return this.importedFrom;
    }

    public void setImportedFrom(File importedFrom) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Map<Layer, ExporterSettings> getAllLayerSettings() {
        return Collections.unmodifiableMap(this.layerSettings);
    }

    public ExporterSettings getLayerSettings(Layer layer) {
        return this.layerSettings.get(layer);
    }

    public void setLayerSettings(Layer layer, ExporterSettings settings) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Set<Layer> getMinimumLayers() {
        Set<Layer> layers = this.layerSettings.values().stream().filter(ExporterSettings::isApplyEverywhere).map(ExporterSettings::getLayer).collect(Collectors.toSet());
        return layers;
    }

    public long getMinecraftSeed() {
        return this.minecraftSeed;
    }

    public void setMinecraftSeed(long minecraftSeed) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void applyTheme(Point coords) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void register(UndoManager undoManager) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void destroy() {
        for (Tile tile : this.tiles.values()) {
            tile.removeListener(this);
            tile.unregister();
        }
    }

    public void addWorldListener(Listener listener) {
    }

    public void removeWorldListener(Listener listener) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    @Override
    public void heightMapChanged(Tile tile) {
    }

    @Override
    public void terrainChanged(Tile tile) {
    }

    @Override
    public void waterLevelChanged(Tile tile) {
    }

    @Override
    public void seedsChanged(Tile tile) {
    }

    @Override
    public void layerDataChanged(Tile tile, Set<Layer> changedLayers) {
    }

    @Override
    public void allBitLayerDataChanged(Tile tile) {
    }

    @Override
    public void allNonBitlayerDataChanged(Tile tile) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (Tile tile : this.tiles.values()) {
            tile.addListener(this);
        }
        if (this.subsurfaceMaterial == null) {
            this.subsurfaceMaterial = Terrain.STONE;
            this.createGoodiesChest = true;
            this.borderLevel = 4;
        }
        if (this.spawnPoint == null) {
            this.spawnPoint = new Point(15, 0);
        }
        if (this.layerSettings == null) {
            this.layerSettings = new HashMap<Layer, ExporterSettings>();
        }
        if (this.minecraftSeed == Long.MIN_VALUE) {
            this.minecraftSeed = 0L;
        }
    }

    @Deprecated
    public static enum Border {
        VOID,
        WATER,
        LAVA;

    }

    @Deprecated
    public static interface Listener {
        public void tileAdded(World var1, Tile var2);

        public void tileRemoved(World var1, Tile var2);
    }
}

