/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPBorderTileProvider
implements TileProvider {
    private final Dimension dimension;
    private final ColourScheme colourScheme;
    private final Effect effect;
    private int zoom = 0;
    private static final Paint BARRIER_PAINT = new TexturePaint(IconUtils.loadUnscaledImage((String)"org/pepsoft/worldpainter/icons/barrier.png"), new Rectangle(0, 0, 16, 16));
    private static final Logger logger = LoggerFactory.getLogger(WPBorderTileProvider.class);

    public WPBorderTileProvider(Dimension dimension, ColourScheme colourScheme, Effect effect) {
        this.dimension = dimension;
        this.colourScheme = colourScheme;
        this.effect = effect;
    }

    public WPBorderTileProvider(Dimension dimension, ColourScheme colourScheme) {
        this(dimension, colourScheme, null);
    }

    public int getTileSize() {
        return 128;
    }

    public boolean isTilePresent(int x, int y) {
        if (this.zoom == 0) {
            TileType unzoomedTileType = this.getUnzoomedTileType(x, y);
            return unzoomedTileType != TileType.SURROUNDS && unzoomedTileType != TileType.WORLD;
        }
        int scale = 1 << -this.zoom;
        for (int dx = 0; dx < scale; ++dx) {
            for (int dy = 0; dy < scale; ++dy) {
                switch (this.getUnzoomedTileType(x * scale + dx, y * scale + dy)) {
                    case BORDER: 
                    case BEDROCK_WALL: 
                    case BARRIER_WALL: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintTile(Image tileImage, int x, int y, int imageX, int imageY) {
        try {
            if (this.zoom == 0) {
                return this.paintUnzoomedTile(tileImage, x, y, imageX, imageY);
            }
            Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
            try {
                g2.setComposite(AlphaComposite.Src);
                g2.setBackground(new Color(0xFFFFFF & VoidRenderer.getColour(), true));
                Color waterColour = new Color(this.colourScheme.getColour(Material.WATER));
                Color lavaColour = new Color(this.colourScheme.getColour(Material.LAVA));
                Color voidColour = new Color(0xFFFFFF & VoidRenderer.getColour(), true);
                Color bedrockColour = new Color(this.colourScheme.getColour(Material.BEDROCK));
                int scale = 1 << -this.zoom;
                int subSize = 128 / scale;
                for (int dx = 0; dx < scale; ++dx) {
                    block16: for (int dy = 0; dy < scale; ++dy) {
                        TileType tileType = this.getUnzoomedTileType(x * scale + dx, y * scale + dy);
                        switch (tileType) {
                            case BORDER: {
                                Paint paint;
                                switch (this.dimension.getBorder()) {
                                    case WATER: 
                                    case ENDLESS_WATER: {
                                        paint = waterColour;
                                        break;
                                    }
                                    case LAVA: 
                                    case ENDLESS_LAVA: {
                                        paint = lavaColour;
                                        break;
                                    }
                                    case VOID: 
                                    case ENDLESS_VOID: {
                                        paint = voidColour;
                                        break;
                                    }
                                    case BARRIER: 
                                    case ENDLESS_BARRIER: {
                                        paint = BARRIER_PAINT;
                                        break;
                                    }
                                    default: {
                                        throw new InternalError();
                                    }
                                }
                                g2.setPaint(paint);
                                g2.fillRect(imageX + dx * subSize, imageY + dy * subSize, subSize, subSize);
                                g2.setColor(Color.BLACK);
                                g2.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f));
                                if (this.dimension.isTilePresent(x * scale + dx, y * scale + dy - 1)) {
                                    g2.drawLine(imageX + dx * subSize, imageY + dy * subSize, imageX + (dx + 1) * subSize - 1, imageY + dy * subSize);
                                }
                                if (this.dimension.isTilePresent(x * scale + dx + 1, y * scale + dy)) {
                                    g2.drawLine(imageX + (dx + 1) * subSize - 1, imageY + dy * subSize, imageX + (dx + 1) * subSize - 1, imageY + (dy + 1) * subSize - 1);
                                }
                                if (this.dimension.isTilePresent(x * scale + dx, y * scale + dy + 1)) {
                                    g2.drawLine(imageX + dx * subSize, imageY + (dy + 1) * subSize - 1, imageX + (dx + 1) * subSize - 1, imageY + (dy + 1) * subSize - 1);
                                }
                                if (!this.dimension.isTilePresent(x * scale + dx - 1, y * scale + dy)) continue block16;
                                g2.drawLine(imageX + dx * subSize, imageY + dy * subSize, imageX + dx * subSize, imageY + (dy + 1) * subSize - 1);
                                continue block16;
                            }
                            case BEDROCK_WALL: 
                            case BARRIER_WALL: {
                                g2.setColor(voidColour);
                                g2.fillRect(imageX + dx * subSize, imageY + dy * subSize, subSize, subSize);
                                g2.setPaint(tileType == TileType.BEDROCK_WALL ? bedrockColour : BARRIER_PAINT);
                                TileType neighbourType = this.getUnzoomedTileType(x * scale + dx, y * scale + dy - 1);
                                int wallWidth = Math.max(subSize / 8, 1);
                                if (neighbourType == TileType.WORLD || neighbourType == TileType.BORDER) {
                                    g2.fillRect(imageX + dx * subSize, imageY + dy * subSize, subSize, wallWidth);
                                }
                                if ((neighbourType = this.getUnzoomedTileType(x * scale + dx + 1, y * scale + dy)) == TileType.WORLD || neighbourType == TileType.BORDER) {
                                    g2.fillRect(imageX + (dx + 1) * subSize - wallWidth, imageY + dy * subSize, wallWidth, subSize);
                                }
                                if ((neighbourType = this.getUnzoomedTileType(x * scale + dx, y * scale + dy + 1)) == TileType.WORLD || neighbourType == TileType.BORDER) {
                                    g2.fillRect(imageX + dx * subSize, imageY + (dy + 1) * subSize - wallWidth, subSize, wallWidth);
                                }
                                if ((neighbourType = this.getUnzoomedTileType(x * scale + dx - 1, y * scale + dy)) != TileType.WORLD && neighbourType != TileType.BORDER) continue block16;
                                g2.fillRect(imageX + dx * subSize, imageY + dy * subSize, wallWidth, subSize);
                                continue block16;
                            }
                            default: {
                                g2.clearRect(imageX + dx * subSize, imageY + dy * subSize, subSize, subSize);
                            }
                        }
                    }
                }
                this.applyEffects(g2);
            }
            finally {
                g2.dispose();
            }
            return true;
        }
        catch (Throwable e) {
            logger.error("Exception while generating image for tile at {}, {}", new Object[]{x, y, e});
            return false;
        }
    }

    public int getTilePriority(int x, int y) {
        return -1;
    }

    public Rectangle getExtent() {
        return null;
    }

    public void addTileListener(TileListener tileListener) {
    }

    public void removeTileListener(TileListener tileListener) {
    }

    public boolean isZoomSupported() {
        return true;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom != this.zoom) {
            if (zoom > 0) {
                throw new UnsupportedOperationException("Zooming in not supported");
            }
            this.zoom = zoom;
        }
    }

    private TileType getUnzoomedTileType(int x, int y) {
        if (this.dimension.isTilePresent(x, y)) {
            return TileType.WORLD;
        }
        if (this.dimension.isBorderTile(x, y)) {
            return TileType.BORDER;
        }
        if (this.dimension.getWallType() != null && (this.dimension.getBorder() != null ? this.dimension.isBorderTile(x - 1, y) || this.dimension.isBorderTile(x, y - 1) || this.dimension.isBorderTile(x + 1, y) || this.dimension.isBorderTile(x, y + 1) : this.dimension.isTilePresent(x - 1, y) || this.dimension.isTilePresent(x, y - 1) || this.dimension.isTilePresent(x + 1, y) || this.dimension.isTilePresent(x, y + 1))) {
            return this.dimension.getWallType() == Dimension.WallType.BEDROCK ? TileType.BEDROCK_WALL : TileType.BARRIER_WALL;
        }
        return TileType.SURROUNDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean paintUnzoomedTile(Image tileImage, int x, int y, int dx, int dy) {
        TileType tileType = this.getUnzoomedTileType(x, y);
        switch (tileType) {
            case WORLD: 
            case SURROUNDS: {
                return false;
            }
            case BORDER: {
                Paint paint;
                switch (this.dimension.getBorder()) {
                    case WATER: 
                    case ENDLESS_WATER: {
                        paint = new Color(0xFF000000 | this.colourScheme.getColour(Material.WATER));
                        break;
                    }
                    case LAVA: 
                    case ENDLESS_LAVA: {
                        paint = new Color(0xFF000000 | this.colourScheme.getColour(Material.LAVA));
                        break;
                    }
                    case VOID: 
                    case ENDLESS_VOID: {
                        paint = new Color(0xFFFFFF & VoidRenderer.getColour());
                        break;
                    }
                    case BARRIER: 
                    case ENDLESS_BARRIER: {
                        paint = BARRIER_PAINT;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
                try {
                    g2.setPaint(paint);
                    g2.setComposite(AlphaComposite.Src);
                    g2.fillRect(dx, dy, 128, 128);
                    g2.setColor(Color.BLACK);
                    g2.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f));
                    if (this.dimension.isTilePresent(x, y - 1)) {
                        g2.drawLine(dx + 1, dy + 1, dx + 128 - 1, dy + 1);
                    }
                    if (this.dimension.isTilePresent(x + 1, y)) {
                        g2.drawLine(dx + 128 - 1, dy + 1, dx + 128 - 1, dy + 128 - 1);
                    }
                    if (this.dimension.isTilePresent(x, y + 1)) {
                        g2.drawLine(dx + 1, dy + 128 - 1, dx + 128 - 1, dy + 128 - 1);
                    }
                    if (this.dimension.isTilePresent(x - 1, y)) {
                        g2.drawLine(dx + 1, dy + 1, dx + 1, dy + 128 - 1);
                    }
                    this.applyEffects(g2);
                }
                finally {
                    g2.dispose();
                }
                return true;
            }
            case BEDROCK_WALL: 
            case BARRIER_WALL: {
                Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
                try {
                    g2.setColor(new Color(0xFFFFFF & VoidRenderer.getColour(), true));
                    g2.setComposite(AlphaComposite.Src);
                    g2.fillRect(dx, dy, 128, 128);
                    if (tileType == TileType.BARRIER_WALL) {
                        g2.setPaint(BARRIER_PAINT);
                    } else {
                        g2.setColor(new Color(this.colourScheme.getColour(Material.BEDROCK)));
                    }
                    TileType neighbourType = this.getUnzoomedTileType(x, y - 1);
                    if (neighbourType == TileType.WORLD || neighbourType == TileType.BORDER) {
                        g2.fillRect(dx, dy, 128, 16);
                    }
                    if ((neighbourType = this.getUnzoomedTileType(x + 1, y)) == TileType.WORLD || neighbourType == TileType.BORDER) {
                        g2.fillRect(dx + 128 - 16, dy, 16, 128);
                    }
                    if ((neighbourType = this.getUnzoomedTileType(x, y + 1)) == TileType.WORLD || neighbourType == TileType.BORDER) {
                        g2.fillRect(dx, dy + 128 - 16, 128, 16);
                    }
                    if ((neighbourType = this.getUnzoomedTileType(x - 1, y)) == TileType.WORLD || neighbourType == TileType.BORDER) {
                        g2.fillRect(dx, dy, 16, 128);
                    }
                    this.applyEffects(g2);
                }
                finally {
                    g2.dispose();
                }
                return true;
            }
        }
        throw new InternalError();
    }

    private void applyEffects(Graphics2D g2) {
        if (this.effect == null) {
            return;
        }
        switch (this.effect) {
            case FADE_TO_FIFTY_PERCENT: {
                g2.setComposite(AlphaComposite.SrcOver.derive(0.5f));
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, 128, 128);
                break;
            }
            case FADE_TO_TWENTYFIVE_PERCENT: {
                g2.setComposite(AlphaComposite.SrcOver.derive(0.75f));
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, 128, 128);
            }
        }
    }

    public static enum Effect {
        FADE_TO_FIFTY_PERCENT,
        FADE_TO_TWENTYFIVE_PERCENT;

    }

    private static enum TileType {
        WORLD,
        BORDER,
        SURROUNDS,
        BEDROCK_WALL,
        BARRIER_WALL;

    }
}

