/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.ColourUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.renderers.BiomeRenderer;
import org.pepsoft.worldpainter.layers.renderers.BitLayerRenderer;
import org.pepsoft.worldpainter.layers.renderers.ByteLayerRenderer;
import org.pepsoft.worldpainter.layers.renderers.ColourSchemeRenderer;
import org.pepsoft.worldpainter.layers.renderers.DimensionAwareRenderer;
import org.pepsoft.worldpainter.layers.renderers.LayerRenderer;
import org.pepsoft.worldpainter.layers.renderers.NibbleLayerRenderer;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerHelper;
import org.pepsoft.worldpainter.ramps.ColourRamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TileRenderer {
    private final BiomeRenderer biomeRenderer;
    private final Set<Layer> hiddenLayers = new HashSet<FloodWithLava>(Collections.singletonList(FloodWithLava.INSTANCE));
    private final int[] intHeightCache = new int[16384];
    private final int[] intFluidHeightCache = new int[16384];
    private final float[] floatHeightCache = new float[16384];
    private final BufferedImage bufferedImage;
    private final int[] renderBuffer;
    private final int[][] heights = new int[3][3];
    private final int[][] deltas = new int[3][3];
    private final int[][] fluidHeights = new int[3][3];
    private final int[][] fluidDeltas = new int[3][3];
    private final Set<Layer> missingRendererReportedFor = new HashSet<Layer>();
    private final boolean[] oppositesOverlap = new boolean[16384];
    private final int zoom;
    private final Platform platform;
    private final TileProvider tileProvider;
    private final TileProvider relatedTileProvider;
    private final boolean renderCeilingIntersection;
    private final boolean renderTunnelRoofIntersection;
    private final boolean transparentVoid;
    private final TunnelLayerHelper tunnelLayerHelper;
    private final ColourRamp colourRamp;
    private ColourScheme colourScheme;
    private boolean contourLines = true;
    private boolean hideAllLayers;
    private int contourSeparation = 10;
    private int waterColour;
    private int lavaColour;
    private int bedrockColour;
    private int notPresentColour;
    private int voidColour;
    private LightOrigin lightOrigin = LightOrigin.NORTHWEST;
    public static final Layer TERRAIN_AS_LAYER = new Layer("org.pepsoft.synthetic.Terrain", "Terrain", "The terrain type of the surface", Layer.DataSize.NONE, false, 0){
        private final BufferedImage ICON = IconUtils.scaleIcon((Image)IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/resources/terrain.png"), (int)16);

        @Override
        public BufferedImage getIcon() {
            return this.ICON;
        }
    };
    public static final Layer FLUIDS_AS_LAYER = new Layer("org.pepsoft.synthetic.Fluids", "Water/Lava", "Areas flooded with water or lava", Layer.DataSize.NONE, false, 0){
        private final BufferedImage ICON = IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/resources/fluids.png");

        @Override
        public BufferedImage getIcon() {
            return this.ICON;
        }
    };
    private static final int BLACK = 0;
    private static final int LIGHT_GREY = 0xD0D0D0;
    private static final boolean[][] CEILING_PATTERN = new boolean[][]{{true, true, false, false, true, true, false, false}, {false, true, true, true, true, false, false, false}, {false, false, true, true, false, false, false, false}, {false, true, true, true, true, false, false, false}, {true, true, false, false, true, true, false, false}, {true, false, false, false, false, true, true, true}, {false, false, false, false, false, false, true, true}, {true, false, false, false, false, true, true, true}};
    private static final Logger logger = LoggerFactory.getLogger(TileRenderer.class);

    public TileRenderer(TileProvider tileProvider, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int zoom, boolean transparentVoid, ColourRamp colourRamp) {
        this.biomeRenderer = new BiomeRenderer(customBiomeManager);
        this.tileProvider = tileProvider;
        Dimension dimension = tileProvider instanceof Dimension ? (Dimension)tileProvider : null;
        Dimension relatedTileProvider = null;
        boolean renderCeilingIntersection = false;
        boolean renderTunnelRoofIntersection = false;
        TunnelLayerHelper tunnelLayerHelper = null;
        if (dimension != null && dimension.getWorld() != null) {
            TunnelLayer tunnelLayer;
            Dimension detailDimension;
            this.platform = dimension.getWorld().getPlatform();
            Dimension.Anchor anchor = dimension.getAnchor();
            if (anchor.role == Dimension.Role.DETAIL) {
                relatedTileProvider = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, anchor.role, !anchor.invert, 0));
                renderCeilingIntersection = relatedTileProvider != null;
            } else if (anchor.role == Dimension.Role.CAVE_FLOOR && (detailDimension = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, anchor.invert, 0))) != null && (tunnelLayer = TunnelLayer.find(dimension)).getRoofMode() != TunnelLayer.Mode.FIXED_HEIGHT_ABOVE_FLOOR) {
                relatedTileProvider = detailDimension;
                renderTunnelRoofIntersection = true;
                tunnelLayerHelper = new TunnelLayerHelper(tunnelLayer, detailDimension);
            }
        } else {
            this.platform = Configuration.DEFAULT_PLATFORM;
        }
        this.relatedTileProvider = relatedTileProvider;
        this.renderCeilingIntersection = renderCeilingIntersection;
        this.renderTunnelRoofIntersection = renderTunnelRoofIntersection;
        this.tunnelLayerHelper = tunnelLayerHelper;
        this.zoom = zoom;
        this.transparentVoid = transparentVoid;
        this.colourRamp = colourRamp;
        this.setColourScheme(colourScheme);
        this.bufferedImage = new BufferedImage(128, 128, 2);
        this.renderBuffer = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
        this.waterColour = colourScheme.getColour(Material.WATER);
        this.lavaColour = colourScheme.getColour(Material.LAVA);
        this.bedrockColour = colourScheme.getColour(Material.BEDROCK);
        this.notPresentColour = 0;
        this.voidColour = (this.transparentVoid ? 0 : -16777216) | VoidRenderer.getColour();
    }

    public void addHiddenLayers(Collection<Layer> hiddenLayers) {
        if (this.hideAllLayers) {
            throw new IllegalStateException("Cannot add to hiddenLayers when hideAllLayers is set");
        }
        this.hiddenLayers.addAll(hiddenLayers);
    }

    public void setHiddenLayers(Set<Layer> hiddenLayers) {
        if (this.hideAllLayers) {
            throw new IllegalStateException("Cannot set hiddenLayers when hideAllLayers is set");
        }
        this.hiddenLayers.clear();
        hiddenLayers.add(FloodWithLava.INSTANCE);
        this.hiddenLayers.addAll(hiddenLayers);
    }

    public Set<Layer> getHiddenLayers() {
        return Collections.unmodifiableSet(this.hiddenLayers);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setContourLines(boolean contourLines) {
        this.contourLines = contourLines;
    }

    public int getContourSeparation() {
        return this.contourSeparation;
    }

    public void setContourSeparation(int contourSeparation) {
        this.contourSeparation = contourSeparation;
    }

    public boolean isHideAllLayers() {
        return this.hideAllLayers;
    }

    public void setHideAllLayers(boolean hideAllLayers) {
        this.hideAllLayers = hideAllLayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTile(Tile tile, Image image, int dx, int dy) {
        boolean notAllBlocksPresent;
        ArrayList<Layer> layerList;
        long seed;
        boolean topLayersRelativeToTerrain;
        boolean bottomless;
        int tileX = tile.getX();
        int tileY = tile.getY();
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                float height;
                this.floatHeightCache[x | y << 7] = height = tile.getHeight(x, y);
                this.intHeightCache[x | y << 7] = Math.round(height);
                this.intFluidHeightCache[x | y << 7] = tile.getWaterLevel(x, y);
            }
        }
        boolean noOpposites = true;
        if (this.tileProvider instanceof Dimension) {
            Dimension dim = (Dimension)this.tileProvider;
            Dimension oppositeDim = (Dimension)this.relatedTileProvider;
            bottomless = dim.isBottomless();
            topLayersRelativeToTerrain = dim.getTopLayerAnchor() == Dimension.LayerAnchor.TERRAIN;
            seed = dim.getSeed();
            if (this.renderCeilingIntersection) {
                int reflectionPoint = (dim.getAnchor().invert ? dim.getCeilingHeight() : oppositeDim.getCeilingHeight()) + oppositeDim.getMinHeight();
                Tile relatedTile = oppositeDim.getTile(tile.getX(), tile.getY());
                if (relatedTile != null) {
                    Arrays.fill(this.oppositesOverlap, false);
                    for (int x = 0; x < 128; ++x) {
                        for (int y = 0; y < 128; ++y) {
                            if (reflectionPoint - relatedTile.getIntHeight(x, y) > this.intHeightCache[x | y << 7]) continue;
                            this.oppositesOverlap[x | y << 7] = true;
                            noOpposites = false;
                        }
                    }
                }
            } else if (this.renderTunnelRoofIntersection) {
                Dimension detailDimension = (Dimension)this.relatedTileProvider;
                int minZ = detailDimension.getMinHeight() + (detailDimension.isBottomless() ? 0 : 1);
                int maxZ = detailDimension.getMaxHeight() - 1;
                Arrays.fill(this.oppositesOverlap, false);
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        int tunnelFloorLevel;
                        int worldX = tileX << 7 | x;
                        int worldY = tileY << 7 | y;
                        int terrainHeight = detailDimension.getIntHeightAt(worldX, worldY);
                        if (this.intHeightCache[x | y << 7] < this.tunnelLayerHelper.calculateRoofLevel(worldX, worldY, terrainHeight, minZ, maxZ, tunnelFloorLevel = this.tunnelLayerHelper.calculateFloorLevel(worldX, worldY, terrainHeight, minZ, maxZ))) continue;
                        this.oppositesOverlap[x | y << 7] = true;
                        noOpposites = false;
                    }
                }
            }
        } else {
            bottomless = false;
            topLayersRelativeToTerrain = false;
            seed = 0L;
        }
        if (!(layerList = new ArrayList<Layer>(tile.getLayers())).contains(Biome.INSTANCE)) {
            layerList.add(Biome.INSTANCE);
        }
        layerList.removeAll(this.hiddenLayers);
        boolean hideTerrain = this.hiddenLayers.contains(TERRAIN_AS_LAYER);
        boolean hideFluids = this.hiddenLayers.contains(FLUIDS_AS_LAYER);
        boolean _void = layerList.contains(Void.INSTANCE);
        boolean bl = notAllBlocksPresent = layerList.contains(NotPresent.INSTANCE) || layerList.contains(NotPresentBlock.INSTANCE);
        if (this.hideAllLayers) {
            layerList.clear();
        } else {
            layerList.removeIf(layer -> layer instanceof Void || layer instanceof NotPresent || layer instanceof NotPresentBlock);
        }
        Layer[] layers = layerList.toArray(new Layer[layerList.size()]);
        LayerRenderer[] renderers = new LayerRenderer[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            renderers[i] = layers[i] instanceof Biome ? this.biomeRenderer : layers[i].getRenderer();
            if (renderers[i] instanceof ColourSchemeRenderer) {
                ((ColourSchemeRenderer)renderers[i]).setColourScheme(this.colourScheme);
            }
            if (!(renderers[i] instanceof DimensionAwareRenderer) || !(this.tileProvider instanceof Dimension)) continue;
            ((DimensionAwareRenderer)renderers[i]).setDimension((Dimension)this.tileProvider);
        }
        int scale = 1 << -this.zoom;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        try {
            g2.setComposite(AlphaComposite.Src);
            if (this.zoom == 0) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        int worldX = tileX << 7 | x;
                        int worldY = tileY << 7 | y;
                        if (notAllBlocksPresent && (tile.getBitLayerValue(NotPresent.INSTANCE, x, y) || tile.getBitLayerValue(NotPresentBlock.INSTANCE, x, y))) {
                            this.renderBuffer[x | y << 7] = this.notPresentColour;
                            continue;
                        }
                        if (!noOpposites && this.oppositesOverlap[x | y << 7] && CEILING_PATTERN[x & 7][y & 7]) {
                            this.renderBuffer[x | y << 7] = -16777216;
                            continue;
                        }
                        if (_void && tile.getBitLayerValue(Void.INSTANCE, x, y)) {
                            this.renderBuffer[x | y << 7] = this.voidColour;
                            continue;
                        }
                        int colour = this.getPixelColour(tile, worldX, worldY, layers, renderers, this.contourLines, hideTerrain, hideFluids, bottomless, topLayersRelativeToTerrain, seed);
                        colour = ColourUtils.multiply((int)colour, (int)this.getTerrainBrightenAmount());
                        int offset = x + y * 128;
                        if (this.intFluidHeightCache[offset] > this.intHeightCache[offset]) {
                            colour = ColourUtils.multiply((int)colour, (int)this.getFluidBrightenAmount());
                        }
                        this.renderBuffer[x | y << 7] = 0xFF000000 | colour;
                    }
                }
                g2.drawImage((Image)this.bufferedImage, dx, dy, null);
            } else {
                int tileSize = 128 / scale;
                for (int x = 0; x < 128; x += scale) {
                    for (int y = 0; y < 128; y += scale) {
                        int worldX = tileX << 7 | x;
                        int worldY = tileY << 7 | y;
                        if (notAllBlocksPresent && (tile.getBitLayerValue(NotPresent.INSTANCE, x, y) || tile.getBitLayerValue(NotPresentBlock.INSTANCE, x, y))) {
                            this.renderBuffer[x / scale + y * tileSize] = this.notPresentColour;
                            continue;
                        }
                        if (!noOpposites && this.oppositesOverlap[x | y << 7]) {
                            this.renderBuffer[x / scale + y * tileSize] = -16777216;
                            continue;
                        }
                        if (_void && tile.getBitLayerValue(Void.INSTANCE, x, y)) {
                            this.renderBuffer[x / scale + y * tileSize] = this.voidColour;
                            continue;
                        }
                        int colour = this.getPixelColour(tile, worldX, worldY, layers, renderers, this.contourLines, hideTerrain, hideFluids, bottomless, topLayersRelativeToTerrain, seed);
                        colour = ColourUtils.multiply((int)colour, (int)this.getTerrainBrightenAmount());
                        int offset = x + y * 128;
                        if (this.intFluidHeightCache[offset] > this.intHeightCache[offset]) {
                            colour = ColourUtils.multiply((int)colour, (int)this.getFluidBrightenAmount());
                        }
                        this.renderBuffer[x / scale + y * tileSize] = 0xFF000000 | colour;
                    }
                }
                g2.drawImage(this.bufferedImage, dx, dy, dx + tileSize, dy + tileSize, 0, 0, tileSize, tileSize, null);
            }
        }
        finally {
            g2.dispose();
        }
    }

    private int getTerrainBrightenAmount() {
        return this.getBrightenAmount(this.deltas);
    }

    private int getFluidBrightenAmount() {
        return this.getBrightenAmount(this.fluidDeltas);
    }

    private int getBrightenAmount(int[][] deltas) {
        switch (this.lightOrigin) {
            case NORTHWEST: {
                return Math.max(0, (deltas[2][1] - deltas[0][1] + deltas[1][2] - deltas[1][0] << 5) + 256);
            }
            case NORTHEAST: {
                return Math.max(0, (deltas[0][1] - deltas[2][1] + deltas[1][2] - deltas[1][0] << 5) + 256);
            }
            case SOUTHEAST: {
                return Math.max(0, (deltas[0][1] - deltas[2][1] + deltas[1][0] - deltas[1][2] << 5) + 256);
            }
            case SOUTHWEST: {
                return Math.max(0, (deltas[2][1] - deltas[0][1] + deltas[1][0] - deltas[1][2] << 5) + 256);
            }
            case ABOVE: {
                return 256;
            }
        }
        throw new InternalError();
    }

    public LightOrigin getLightOrigin() {
        return this.lightOrigin;
    }

    public void setLightOrigin(LightOrigin lightOrigin) {
        if (lightOrigin == null) {
            throw new NullPointerException();
        }
        this.lightOrigin = lightOrigin;
    }

    private int getPixelColour(Tile tile, int worldX, int worldY, Layer[] layers, LayerRenderer[] renderers, boolean contourLines, boolean hideTerrain, boolean hideFluids, boolean bottomless, boolean topLayersRelativeToTerrain, long seed) {
        int colour;
        int x = worldX & 0x7F;
        int y = worldY & 0x7F;
        int offset = x + y * 128;
        int intHeight = this.intHeightCache[offset];
        int minHeight = tile.getMinHeight();
        this.heights[1][0] = this.getNeighbourHeight(tile, x, y, 0, -1);
        this.deltas[1][0] = this.heights[1][0] - intHeight;
        this.heights[0][1] = this.getNeighbourHeight(tile, x, y, -1, 0);
        this.deltas[0][1] = this.heights[0][1] - intHeight;
        this.heights[2][1] = this.getNeighbourHeight(tile, x, y, 1, 0);
        this.deltas[2][1] = this.heights[2][1] - intHeight;
        this.heights[1][2] = this.getNeighbourHeight(tile, x, y, 0, 1);
        this.deltas[1][2] = this.heights[1][2] - intHeight;
        if (contourLines && intHeight % this.contourSeparation == 0 && (this.deltas[0][1] < 0 || this.deltas[2][1] < 0 || this.deltas[1][0] < 0 || this.deltas[1][2] < 0)) {
            return 0;
        }
        int waterLevel = tile.getWaterLevel(x, y);
        this.fluidHeights[1][0] = this.getNeighbourFluidHeight(tile, x, y, 0, -1, waterLevel);
        this.fluidDeltas[1][0] = this.fluidHeights[1][0] - waterLevel;
        this.fluidHeights[0][1] = this.getNeighbourFluidHeight(tile, x, y, -1, 0, waterLevel);
        this.fluidDeltas[0][1] = this.fluidHeights[0][1] - waterLevel;
        this.fluidHeights[2][1] = this.getNeighbourFluidHeight(tile, x, y, 1, 0, waterLevel);
        this.fluidDeltas[2][1] = this.fluidHeights[2][1] - waterLevel;
        this.fluidHeights[1][2] = this.getNeighbourFluidHeight(tile, x, y, 0, 1, waterLevel);
        this.fluidDeltas[1][2] = this.fluidHeights[1][2] - waterLevel;
        if (!hideFluids && waterLevel > intHeight) {
            colour = tile.getBitLayerValue(FloodWithLava.INSTANCE, x, y) ? this.lavaColour : this.waterColour;
        } else if (!hideTerrain) {
            float height = this.floatHeightCache[offset];
            if (!bottomless && intHeight == minHeight) {
                colour = this.bedrockColour;
            } else {
                MixedMaterial mixedMaterial;
                Terrain terrain = tile.getTerrain(x, y);
                colour = topLayersRelativeToTerrain && terrain.isCustom() ? ((mixedMaterial = Terrain.getCustomMaterial(terrain.getCustomTerrainIndex())).getMode() == MixedMaterial.Mode.LAYERED ? terrain.getColour(seed, worldX, worldY, mixedMaterial.getPatternHeight() - 1, intHeight, this.platform, this.colourScheme) : terrain.getColour(seed, worldX, worldY, height, intHeight, this.platform, this.colourScheme)) : terrain.getColour(seed, worldX, worldY, height, intHeight, this.platform, this.colourScheme);
            }
        } else {
            colour = this.colourRamp != null ? this.colourRamp.getColour(this.floatHeightCache[offset]) : 0xD0D0D0;
        }
        block5: for (int i = 0; i < layers.length; ++i) {
            Layer layer = layers[i];
            switch (layer.getDataSize()) {
                case BIT: 
                case BIT_PER_CHUNK: {
                    BitLayerRenderer renderer;
                    boolean bitLayerValue;
                    if (hideFluids && layer instanceof Frost && waterLevel > this.intHeightCache[offset] || !(bitLayerValue = tile.getBitLayerValue(layer, x, y)) || this.reportMissingRenderer(layer, (renderer = (BitLayerRenderer)renderers[i]) == null)) continue block5;
                    colour = renderer.getPixelColour(worldX, worldY, colour, true);
                    continue block5;
                }
                case NIBBLE: {
                    NibbleLayerRenderer renderer;
                    int layerValue = tile.getLayerValue(layer, x, y);
                    if (layerValue <= 0 || this.reportMissingRenderer(layer, (renderer = (NibbleLayerRenderer)renderers[i]) == null)) continue block5;
                    colour = renderer.getPixelColour(worldX, worldY, colour, layerValue);
                    continue block5;
                }
                case BYTE: {
                    ByteLayerRenderer byteLayerRenderer = (ByteLayerRenderer)renderers[i];
                    if (this.reportMissingRenderer(layer, byteLayerRenderer == null)) continue block5;
                    colour = byteLayerRenderer.getPixelColour(worldX, worldY, colour, tile.getLayerValue(layer, x, y));
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Don't know how to render " + layer.getClass().getSimpleName());
                }
            }
        }
        return colour;
    }

    @Contract(value="_, true -> true")
    private boolean reportMissingRenderer(Layer layer, boolean rendererMissing) {
        if (rendererMissing) {
            logger.error("Missing renderer for layer " + layer + " (type: " + layer.getClass().getSimpleName() + ")");
            if (!this.missingRendererReportedFor.contains(layer)) {
                this.missingRendererReportedFor.add(layer);
                throw new IllegalStateException("Missing renderer for layer " + layer + " (type: " + layer.getClass().getSimpleName() + ")");
            }
            return true;
        }
        return false;
    }

    private int getNeighbourHeight(Tile tile, int x, int y, int dx, int dy) {
        if ((x += dx) >= 0 && x < 128 && (y += dy) >= 0 && y < 128) {
            return this.intHeightCache[x + y * 128];
        }
        int tileDX = 0;
        int tileDY = 0;
        if (x < 0) {
            tileDX = -1;
            x += 128;
        } else if (x >= 128) {
            tileDX = 1;
            x -= 128;
        }
        if (y < 0) {
            tileDY = -1;
            y += 128;
        } else if (y >= 128) {
            tileDY = 1;
            y -= 128;
        }
        Tile neighborTile = this.tileProvider.getTile(tile.getX() + tileDX, tile.getY() + tileDY);
        return neighborTile != null ? neighborTile.getIntHeight(x, y) : 62;
    }

    private int getNeighbourFluidHeight(Tile tile, int x, int y, int dx, int dy, int defaultHeight) {
        if ((x += dx) >= 0 && x < 128 && (y += dy) >= 0 && y < 128) {
            int offset = x + y * 128;
            return this.intFluidHeightCache[offset] > this.intHeightCache[offset] ? this.intFluidHeightCache[offset] : defaultHeight;
        }
        int tileDX = 0;
        int tileDY = 0;
        if (x < 0) {
            tileDX = -1;
            x += 128;
        } else if (x >= 128) {
            tileDX = 1;
            x -= 128;
        }
        if (y < 0) {
            tileDY = -1;
            y += 128;
        } else if (y >= 128) {
            tileDY = 1;
            y -= 128;
        }
        Tile neighborTile = this.tileProvider.getTile(tile.getX() + tileDX, tile.getY() + tileDY);
        if (neighborTile != null) {
            int waterLevel = neighborTile.getWaterLevel(x, y);
            return waterLevel > neighborTile.getIntHeight(x, y) ? waterLevel : defaultHeight;
        }
        return defaultHeight;
    }

    public static enum LightOrigin {
        NORTHWEST{

            @Override
            public LightOrigin left() {
                return ABOVE;
            }

            @Override
            public LightOrigin right() {
                return NORTHEAST;
            }
        }
        ,
        NORTHEAST{

            @Override
            public LightOrigin left() {
                return NORTHWEST;
            }

            @Override
            public LightOrigin right() {
                return SOUTHEAST;
            }
        }
        ,
        SOUTHEAST{

            @Override
            public LightOrigin left() {
                return NORTHEAST;
            }

            @Override
            public LightOrigin right() {
                return SOUTHWEST;
            }
        }
        ,
        SOUTHWEST{

            @Override
            public LightOrigin left() {
                return SOUTHEAST;
            }

            @Override
            public LightOrigin right() {
                return ABOVE;
            }
        }
        ,
        ABOVE{

            @Override
            public LightOrigin left() {
                return SOUTHWEST;
            }

            @Override
            public LightOrigin right() {
                return NORTHWEST;
            }
        };


        public abstract LightOrigin left();

        public abstract LightOrigin right();
    }
}

