/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.Random;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.DisplacementHeightMap;
import org.pepsoft.worldpainter.heightMaps.MaximisingHeightMap;
import org.pepsoft.worldpainter.heightMaps.NinePatchHeightMap;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.heightMaps.ProductHeightMap;
import org.pepsoft.worldpainter.heightMaps.SumHeightMap;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.impl.fancy.FancyTheme;

public final class TileFactoryFactory {
    private TileFactoryFactory() {
    }

    public static HeightMapTileFactory createNoiseTileFactory(long seed, Terrain terrain, int minHeight, int maxHeight, int baseHeight, int waterLevel, boolean floodWithLava, boolean beaches, float range, double scale) {
        return new HeightMapTileFactory(seed, new SumHeightMap(new ConstantHeightMap(baseHeight), new NoiseHeightMap(range, scale, 1, 0L)), minHeight, maxHeight, floodWithLava, SimpleTheme.createDefault(terrain, minHeight, maxHeight, waterLevel, true, beaches));
    }

    public static HeightMapTileFactory createFlatTileFactory(long seed, Terrain terrain, int minHeight, int maxHeight, int height, int waterLevel, boolean floodWithLava, boolean beaches) {
        return new HeightMapTileFactory(seed, new ConstantHeightMap(height), minHeight, maxHeight, floodWithLava, SimpleTheme.createDefault(terrain, minHeight, maxHeight, waterLevel, false, beaches));
    }

    public static HeightMapTileFactory createFancyTileFactory(long seed, Terrain terrain, int minHeight, int maxHeight, int baseHeight, int waterLevel, boolean floodWithLava, float range, double scale) {
        ConstantHeightMap oceanFloor = new ConstantHeightMap("Ocean Floor", waterLevel - 22);
        AbstractHeightMap continent = new NinePatchHeightMap("Continent", 0, 500, 50, baseHeight - (waterLevel - 22));
        Random random = new Random(seed);
        ProductHeightMap hills = new ProductHeightMap("Hills", new NoiseHeightMap(1.0, 10.0, 1, random.nextLong()), new NoiseHeightMap(range, scale, 2, random.nextLong()));
        continent = new SumHeightMap(new SumHeightMap(oceanFloor, continent), hills);
        NinePatchHeightMap mountainsLimit = new NinePatchHeightMap(0, 500, 200, 1.0);
        ProductHeightMap mountainsHeight = new ProductHeightMap(new ProductHeightMap(new NoiseHeightMap(1.0, 10.0, 1, random.nextLong()), mountainsLimit), new NoiseHeightMap(256.0, 5.0, 5, random.nextLong()));
        NoiseHeightMap mountainsAngleMap = new NoiseHeightMap(6.2831854820251465, 2.5, 1, random.nextLong());
        NoiseHeightMap mountainsDistanceMap = new NoiseHeightMap(25.0, 2.5, 1, random.nextLong());
        DisplacementHeightMap mountains = new DisplacementHeightMap("Mountains", mountainsHeight, mountainsAngleMap, mountainsDistanceMap);
        MaximisingHeightMap heightMap = new MaximisingHeightMap(continent, mountains);
        return new HeightMapTileFactory(seed, heightMap, minHeight, maxHeight, false, new FancyTheme(minHeight, maxHeight, 62, heightMap, terrain));
    }
}

