/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.pepsoft.util.SystemUtils;

public enum AccelerationType {
    DEFAULT(SystemUtils.OS.WINDOWS, SystemUtils.OS.MAC, SystemUtils.OS.LINUX, SystemUtils.OS.OTHER),
    DIRECT3D(SystemUtils.OS.WINDOWS),
    OPENGL(SystemUtils.OS.WINDOWS, SystemUtils.OS.MAC, SystemUtils.OS.LINUX),
    QUARTZ(SystemUtils.OS.MAC),
    XRENDER(SystemUtils.OS.LINUX),
    UNACCELERATED(SystemUtils.OS.WINDOWS, SystemUtils.OS.MAC, SystemUtils.OS.LINUX, SystemUtils.OS.OTHER);

    private final Set<SystemUtils.OS> oses;

    private AccelerationType(SystemUtils.OS ... oses) {
        this.oses = EnumSet.copyOf(Arrays.asList(oses));
    }

    public static List<AccelerationType> getForThisOS() {
        ArrayList<AccelerationType> types = new ArrayList<AccelerationType>(AccelerationType.values().length);
        for (AccelerationType type : AccelerationType.values()) {
            if (!type.oses.contains(SystemUtils.getOS())) continue;
            types.add(type);
        }
        return types;
    }
}

