/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.FloatTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.LongTag;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.worldpainter.mapexplorer.AbstractNode;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class TagNode
extends AbstractNode {
    private final Tag tag;
    private static final Collator COLLATOR = Collator.getInstance();

    public TagNode(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        String name = this.tag.getName();
        if (name != null && name.trim().length() > 0) {
            sb.append(name.trim());
            sb.append(" (");
        }
        sb.append(this.tag.getClass().getSimpleName());
        if (name != null && name.trim().length() > 0) {
            sb.append(')');
        }
        if (this.tag instanceof StringTag) {
            sb.append(": \"");
            sb.append(((StringTag)this.tag).getValue());
            sb.append('\"');
        } else if (this.tag instanceof ByteArrayTag) {
            sb.append(": ");
            sb.append(((ByteArrayTag)this.tag).getValue().length);
            sb.append(" bytes of data");
        } else if (this.tag instanceof IntArrayTag) {
            sb.append(": ");
            sb.append(((IntArrayTag)this.tag).getValue().length * 4);
            sb.append(" bytes of data");
        } else if (this.tag instanceof LongArrayTag) {
            sb.append(": ");
            sb.append(((LongArrayTag)this.tag).getValue().length * 8);
            sb.append(" bytes of data");
        } else if (this.tag instanceof ByteTag) {
            sb.append(": ");
            sb.append(((ByteTag)this.tag).getValue());
        } else if (this.tag instanceof ShortTag) {
            sb.append(": ");
            sb.append(((ShortTag)this.tag).getValue());
        } else if (this.tag instanceof IntTag) {
            sb.append(": ");
            sb.append(((IntTag)this.tag).getValue());
        } else if (this.tag instanceof FloatTag) {
            sb.append(": ");
            sb.append(((FloatTag)this.tag).getValue());
        } else if (this.tag instanceof LongTag) {
            sb.append(": ");
            sb.append(((LongTag)this.tag).getValue());
        } else if (this.tag instanceof DoubleTag) {
            sb.append(": ");
            sb.append(((DoubleTag)this.tag).getValue());
        }
        return sb.toString();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return !(this.tag instanceof CompoundTag) && !(this.tag instanceof ListTag);
    }

    @Override
    public void doubleClicked() {
        if (this.tag instanceof ByteArrayTag) {
            byte[] bytes = ((ByteArrayTag)this.tag).getValue();
            for (int i = 0; i < bytes.length; i += 16) {
                if (i % 256 == 0) {
                    System.out.println();
                }
                for (int j = 0; j < 16; ++j) {
                    int k = i + j;
                    if (k >= bytes.length) continue;
                    System.out.printf("%02x ", bytes[k]);
                }
                System.out.println();
            }
        } else if (this.tag instanceof IntArrayTag) {
            int[] ints = ((IntArrayTag)this.tag).getValue();
            for (int i = 0; i < ints.length; i += 4) {
                if (i % 64 == 0) {
                    System.out.println();
                }
                for (int j = 0; j < 4; ++j) {
                    int k = i + j;
                    if (k >= ints.length) continue;
                    System.out.printf("%08x ", ints[k]);
                }
                System.out.println();
            }
        } else if (this.tag instanceof LongArrayTag) {
            long[] longs = ((LongArrayTag)this.tag).getValue();
            for (int i = 0; i < longs.length; i += 2) {
                if (i % 32 == 0) {
                    System.out.println();
                }
                for (int j = 0; j < 2; ++j) {
                    int k = i + j;
                    if (k >= longs.length) continue;
                    System.out.printf("%016x ", longs[k]);
                }
                System.out.println();
            }
        } else {
            DesktopUtils.beep();
        }
    }

    @Override
    protected Node[] loadChildren() {
        ArrayList tagList = new ArrayList();
        if (this.tag instanceof CompoundTag) {
            Map tags = ((CompoundTag)this.tag).getValue();
            tagList.addAll(tags.values());
            Collections.sort(tagList, (tag1, tag2) -> COLLATOR.compare(tag1.getName(), tag2.getName()));
        } else if (this.tag instanceof ListTag) {
            List tags = ((ListTag)this.tag).getValue();
            tagList.addAll(tags);
        }
        return (Node[])tagList.stream().map(TagNode::new).toArray(Node[]::new);
    }
}

