/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.minecraft.mapexplorer.ChunkNode;
import org.pepsoft.minecraft.mapexplorer.FileSystemNode;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class RegionFileNode
extends FileSystemNode {
    private final int x;
    private final int z;
    private static final Icon ICON = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/plugin.png");

    RegionFileNode(File file) {
        super(file);
        StringTokenizer tokenizer = new StringTokenizer(file.getName(), ".");
        tokenizer.nextToken();
        this.x = Integer.parseInt(tokenizer.nextToken());
        this.z = Integer.parseInt(tokenizer.nextToken());
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @Override
    public String getName() {
        return "Region " + this.x + ", " + this.z;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected Node[] loadChildren() {
        try {
            ArrayList<ChunkNode> chunks = new ArrayList<ChunkNode>();
            RegionFile regionFile = new RegionFile(this.file);
            for (int chunkX = 0; chunkX < 32; ++chunkX) {
                for (int chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    if (!regionFile.containsChunk(chunkX, chunkZ)) continue;
                    chunks.add(new ChunkNode(regionFile, chunkX, chunkZ));
                }
            }
            return chunks.toArray(new Node[chunks.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading region file", e);
        }
    }
}

