/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.util.HashMap;
import org.jnbt.CompoundTag;
import org.jnbt.StringTag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Chest;
import org.pepsoft.minecraft.Sign;

public class TileEntity
extends AbstractNBTItem {
    private static final long serialVersionUID = 1L;

    public TileEntity(String id) {
        super(new CompoundTag("", new HashMap()));
        if (id == null) {
            throw new NullPointerException();
        }
        this.setString("id", id);
    }

    protected TileEntity(CompoundTag tag) {
        super(tag);
    }

    public String getId() {
        String id = this.getString("id");
        return id != null ? id : this.getString("Id");
    }

    public int getX() {
        return this.getInt("x");
    }

    public void setX(int x) {
        this.setInt("x", x);
    }

    public int getY() {
        return this.getInt("y");
    }

    public void setY(int y) {
        this.setInt("y", y);
    }

    public int getZ() {
        return this.getInt("z");
    }

    public void setZ(int z) {
        this.setInt("z", z);
    }

    public static TileEntity fromNBT(CompoundTag tileEntityTag) {
        StringTag idTag = (StringTag)tileEntityTag.getTag("id");
        if (idTag == null) {
            idTag = (StringTag)tileEntityTag.getTag("Id");
        }
        if (idTag != null) {
            switch (idTag.getValue()) {
                case "Chest": 
                case "minecraft:chest": {
                    return new Chest(tileEntityTag);
                }
                case "Sign": 
                case "minecraft:sign": {
                    return new Sign(tileEntityTag);
                }
            }
        }
        return new TileEntity(tileEntityTag);
    }
}

