/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3i;
import org.jnbt.CompoundTag;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.NBTChunk;
import org.pepsoft.minecraft.TileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MCNamedBlocksChunk
extends NBTChunk {
    private static final Logger logger = LoggerFactory.getLogger(MCNamedBlocksChunk.class);

    protected MCNamedBlocksChunk(CompoundTag tag) {
        super(tag);
    }

    protected MCNamedBlocksChunk(Map<DataType, CompoundTag> tags) {
        super(tags);
    }

    protected void normalise() {
        Iterator<TileEntity> i = this.getTileEntities().iterator();
        while (i.hasNext()) {
            TileEntity tileEntity = i.next();
            Set<String> blockNames = Material.TILE_ENTITY_MAP.get(tileEntity.getId());
            if (blockNames == null) {
                logger.warn("Unknown tile entity ID \"" + tileEntity.getId() + "\" encountered @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + "; can't check whether the corresponding block is there!");
                continue;
            }
            Material existingMaterial = this.getMaterial(tileEntity.getX() & 0xF, tileEntity.getY(), tileEntity.getZ() & 0xF);
            if (blockNames.contains(existingMaterial.name)) continue;
            i.remove();
            logger.warn("Removing tile entity " + tileEntity.getId() + " @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + " because the block at that location is " + existingMaterial);
        }
        HashSet<Point3i> occupiedCoords = new HashSet<Point3i>();
        Iterator<TileEntity> i2 = this.getTileEntities().iterator();
        while (i2.hasNext()) {
            TileEntity tileEntity = i2.next();
            Point3i coords = new Point3i(tileEntity.getX(), tileEntity.getZ(), tileEntity.getY());
            if (occupiedCoords.contains(coords)) {
                i2.remove();
                logger.warn("Removing tile entity " + tileEntity.getId() + " @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + " because there is already a tile entity of the same type at that location");
                continue;
            }
            occupiedCoords.add(coords);
        }
    }
}

