/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

public enum Direction {
    NORTH,
    EAST,
    SOUTH,
    WEST;


    public String toString() {
        return this.name().toLowerCase();
    }

    public Direction rotate(int steps) {
        int direction = this.ordinal();
        direction = direction + steps & 3;
        switch (direction) {
            case 0: {
                return NORTH;
            }
            case 1: {
                return EAST;
            }
            case 2: {
                return SOUTH;
            }
            case 3: {
                return WEST;
            }
        }
        throw new InternalError();
    }

    public Direction mirror(Direction axis) {
        if (!((axis != WEST && axis != EAST || this != NORTH && this != SOUTH) && (axis != NORTH && axis != SOUTH || this != WEST && this != EAST))) {
            return this.opposite();
        }
        return this;
    }

    public Direction opposite() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case WEST: {
                return EAST;
            }
        }
        throw new InternalError();
    }

    public Direction left() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new InternalError();
    }

    public Direction right() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new InternalError();
    }

    public int getDx() {
        switch (this) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return -1;
            }
        }
        throw new InternalError();
    }

    public int getDy() {
        switch (this) {
            case NORTH: {
                return -1;
            }
            case EAST: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 0;
            }
        }
        throw new InternalError();
    }

    public static Direction parse(String str) {
        return Direction.valueOf(str.toUpperCase());
    }
}

