/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.vo;

import java.io.Serializable;
import java.util.Arrays;

public class ExceptionVO
implements Serializable {
    private final String type;
    private final String message;
    private final StackFrameVO[] stackTrace;
    private final ExceptionVO cause;
    private static final long serialVersionUID = 1L;

    public ExceptionVO(Throwable exception) {
        this.type = exception.getClass().getName();
        this.message = exception.getMessage();
        this.stackTrace = (StackFrameVO[])Arrays.stream(exception.getStackTrace()).map(StackFrameVO::new).toArray(StackFrameVO[]::new);
        this.cause = exception.getCause() != null ? new ExceptionVO(exception.getCause()) : null;
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public StackFrameVO[] getStackTrace() {
        return this.stackTrace;
    }

    public ExceptionVO getCause() {
        return this.cause;
    }

    public static class StackFrameVO
    implements Serializable {
        private final String class_;
        private final String method;
        private final String sourceFile;
        private final int lineNo;
        private static final long serialVersionUID = 1L;

        public StackFrameVO(StackTraceElement stackTraceElement) {
            this.class_ = stackTraceElement.getClassName();
            this.method = stackTraceElement.getMethodName();
            this.sourceFile = stackTraceElement.getFileName();
            this.lineNo = stackTraceElement.getLineNumber();
        }

        public String getClass_() {
            return this.class_;
        }

        public String getMethod() {
            return this.method;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public int getLineNo() {
            return this.lineNo;
        }
    }
}

