/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jnbt.NBTUtils;
import org.jnbt.Tag;

public final class ListTag<T extends Tag>
extends Tag {
    private final Class<T> type;
    private List<T> value;
    private static final long serialVersionUID = 1L;

    public ListTag(String name, Class<T> type, List<T> value) {
        super(name);
        this.type = type;
        this.value = Collections.unmodifiableList(value);
    }

    public Class<? extends Tag> getType() {
        return this.type;
    }

    public List<T> getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_List" + append + ": " + this.value.size() + " entries of type " + NBTUtils.getTypeName(this.type) + "\r\n{\r\n");
        for (Tag t : this.value) {
            bldr.append("   " + t.toString().replaceAll("\r\n", "\r\n   ") + "\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }

    @Override
    public ListTag<T> clone() {
        ListTag clone = (ListTag)super.clone();
        clone.value = new ArrayList<T>(this.value.size());
        clone.value.addAll(this.value.stream().map(t -> t.clone()).collect(Collectors.toList()));
        return clone;
    }
}

