/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import org.pepsoft.util.PerlinNoise;

public final class RandomField {
    private final int bits;
    private final double scale;
    private final PerlinNoise[] noiseGenerators;

    public RandomField(int bits, double scale, long seed) {
        this.bits = bits;
        this.scale = scale;
        this.noiseGenerators = new PerlinNoise[bits];
        for (int i = 0; i < bits; ++i) {
            this.noiseGenerators[i] = new PerlinNoise(seed + (long)i);
        }
    }

    public int getValue(int x) {
        return this.getValue(x, 0, 0);
    }

    public int getValue(int x, int y) {
        return this.getValue(x, y, 0);
    }

    public int getValue(int x, int y, int z) {
        double dX = (double)x / this.scale;
        double dY = (double)y / this.scale;
        double dZ = (double)z / this.scale;
        switch (this.bits) {
            case 1: {
                return this.noiseGenerators[0].getPerlinNoise(dX, dY, dZ) > 0.0f ? 1 : 0;
            }
            case 2: {
                return (this.noiseGenerators[0].getPerlinNoise(dX, dY, dZ) > 0.0f ? 2 : 0) | (this.noiseGenerators[1].getPerlinNoise(dX, dY, dZ) > 0.0f ? 1 : 0);
            }
            case 3: {
                return (this.noiseGenerators[0].getPerlinNoise(dX, dY, dZ) > 0.0f ? 4 : 0) | (this.noiseGenerators[1].getPerlinNoise(dX, dY, dZ) > 0.0f ? 2 : 0) | (this.noiseGenerators[2].getPerlinNoise(dX, dY, dZ) > 0.0f ? 1 : 0);
            }
            case 4: {
                return (this.noiseGenerators[0].getPerlinNoise(dX, dY, dZ) > 0.0f ? 8 : 0) | (this.noiseGenerators[1].getPerlinNoise(dX, dY, dZ) > 0.0f ? 4 : 0) | (this.noiseGenerators[2].getPerlinNoise(dX, dY, dZ) > 0.0f ? 2 : 0) | (this.noiseGenerators[3].getPerlinNoise(dX, dY, dZ) > 0.0f ? 1 : 0);
            }
        }
        int value = 0;
        for (int i = 0; i < this.bits; ++i) {
            value = value << 1 | (this.noiseGenerators[i].getPerlinNoise(dX, dY, dZ) > 0.0f ? 1 : 0);
        }
        return value;
    }

    public int getBits() {
        return this.bits;
    }

    public double getScale() {
        return this.scale;
    }

    public long getSeed() {
        return this.noiseGenerators[0].getSeed();
    }

    public void setSeed(long seed) {
        for (int i = 0; i < this.bits; ++i) {
            this.noiseGenerators[i].setSeed(seed + (long)i);
        }
    }
}

