/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractWorldExporter;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackupUtils {
    private static final Pattern BACKUP_DIR_PATTERN = Pattern.compile("^.+\\.\\d{14}$");
    private static final Logger logger = LoggerFactory.getLogger(BackupUtils.class);

    private BackupUtils() {
    }

    public static File getBackupFile(File file, int backup) {
        String filename = file.getName();
        int p = filename.lastIndexOf(46);
        filename = p != -1 ? filename.substring(0, p) + "." + backup + filename.substring(p) : filename + "." + backup;
        return new File(file.getParentFile(), filename);
    }

    public static synchronized boolean cleanUpBackups(File exportDir, Window parent) throws IOException {
        Configuration config = Configuration.getInstance();
        if (config == null || !config.isAutoDeleteBackups() && exportDir != null) {
            return true;
        }
        Map<FileStore, Set<File>> backupsDirs = exportDir != null ? BackupUtils.selectDirsForAutomatic(exportDir) : BackupUtils.selectDirsForManual();
        int minimumFreeSpace = config.getMinimumFreeSpaceForMaps();
        AtomicBoolean permissionGiven = new AtomicBoolean(exportDir == null);
        StringBuilder report = new StringBuilder();
        for (Map.Entry<FileStore, Set<File>> entry : backupsDirs.entrySet()) {
            int count;
            FileStore store = entry.getKey();
            if (store.getUsableSpace() >= (long)minimumFreeSpace * 0x40000000L) {
                logger.debug("File store {} has more than {} GB usable space", (Object)store, (Object)minimumFreeSpace);
                report.append("File store ").append(store).append(" has more than ").append(minimumFreeSpace).append(" GB usable space; no action taken\n");
                continue;
            }
            if (!permissionGiven.get()) {
                DesktopUtils.beep();
                int rc = JOptionPane.showConfirmDialog(parent, "There is less than " + minimumFreeSpace + " GB free on file store " + store + "\nWould you like to make space by deleting old backups, if possible?", "Disk Space Low", 1);
                switch (rc) {
                    case 0: {
                        permissionGiven.set(true);
                        break;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
            if ((count = BackupUtils.doDeleteBackups((Collection<? extends File>)entry.getValue(), minimumFreeSpace, store)) == 0) {
                logger.debug("No backups to delete from {}", (Object)store);
                report.append("No backups to delete on ").append(store).append('\n');
            } else {
                logger.debug("{} backups deleted from {}", (Object)count, (Object)store);
                report.append(count).append(" backups were deleted from ").append(store).append('\n');
            }
            if (store.getUsableSpace() >= (long)minimumFreeSpace * 0x40000000L) {
                logger.debug("There is now more than {} GB free on {}", (Object)minimumFreeSpace, (Object)store);
                report.append("There is now more than ").append(minimumFreeSpace).append(" GB free on ").append(store).append('\n');
                continue;
            }
            logger.warn("There is still less than {} GB free on {}", (Object)minimumFreeSpace, (Object)store);
            report.append("There is still less than ").append(minimumFreeSpace).append(" GB free on ").append(store).append("!\n");
        }
        if (exportDir != null) {
            FileStore store = Files.getFileStore(exportDir.toPath());
            if (store.getUsableSpace() < (long)minimumFreeSpace * 0x40000000L) {
                logger.warn("After deleting backups there is still less than {} GB free on {}", (Object)minimumFreeSpace, (Object)store);
                int rc = JOptionPane.showConfirmDialog(parent, report + "\nDo you want to continue with the operation?", "Not Enough Space Cleared", 2, 2);
                return rc == 0;
            }
        } else {
            MessageUtils.showInfo((Component)parent, (String)report.toString(), (String)"Clean Up Results");
        }
        return true;
    }

    private static Map<FileStore, Set<File>> selectDirsForManual() throws IOException {
        File minecraftDir;
        Configuration config = Configuration.getInstance();
        HashMap<FileStore, Set<File>> backupsDirs = new HashMap<FileStore, Set<File>>();
        PlatformManager platformManager = PlatformManager.getInstance();
        platformManager.getAllPlatforms().forEach(platform -> {
            try {
                File backupsDir;
                File exportDir = config.getExportDirectory((Platform)platform);
                if (exportDir != null && (backupsDir = platformManager.getPlatformProvider((Platform)platform).selectBackupDir(exportDir)) != null && backupsDir.isDirectory()) {
                    FileStore backupsDirStore = Files.getFileStore(backupsDir.toPath());
                    backupsDirs.computeIfAbsent(backupsDirStore, key -> new HashSet()).add(backupsDir);
                }
            }
            catch (IOException e) {
                throw new MDCCapturingRuntimeException("I/O error getting backups directory file store for platform " + platform, (Throwable)e);
            }
        });
        File backupsDir = new File(System.getProperty("user.home"), "WorldPainter Backups");
        if (backupsDir.isDirectory()) {
            FileStore backupsDirStore = Files.getFileStore(backupsDir.toPath());
            backupsDirs.computeIfAbsent(backupsDirStore, key -> new HashSet()).add(backupsDir);
        }
        if ((minecraftDir = MinecraftUtil.findMinecraftDir()) != null && minecraftDir.isDirectory() && (backupsDir = new File(minecraftDir, "backups")).isDirectory()) {
            FileStore backupsDirStore = Files.getFileStore(backupsDir.toPath());
            backupsDirs.computeIfAbsent(backupsDirStore, key -> new HashSet()).add(backupsDir);
        }
        return backupsDirs;
    }

    private static Map<FileStore, Set<File>> selectDirsForAutomatic(File exportDir) throws IOException {
        FileStore exportDirFileStore = Files.getFileStore(exportDir.toPath());
        Map<FileStore, Set<File>> backupsDirs = BackupUtils.selectDirsForManual();
        PlatformManager platformManager = PlatformManager.getInstance();
        platformManager.getAllPlatforms().forEach(platform -> {
            try {
                File backupsDir = platformManager.getPlatformProvider((Platform)platform).selectBackupDir(exportDir);
                if (backupsDir != null && backupsDir.isDirectory()) {
                    FileStore backupsDirStore = Files.getFileStore(exportDir.toPath());
                    backupsDirs.computeIfAbsent(backupsDirStore, key -> new HashSet()).add(backupsDir);
                }
            }
            catch (IOException e) {
                throw new MDCCapturingRuntimeException("I/O error getting backups directory file store for platform " + platform, (Throwable)e);
            }
        });
        backupsDirs.keySet().removeIf(fileStore -> !fileStore.equals(exportDirFileStore));
        return backupsDirs;
    }

    private static int doDeleteBackups(Collection<? extends File> backupsDirs, int minimumFreeSpace, FileStore fileStore) throws IOException {
        List allBackupDirs = backupsDirs.stream().map(backupsDir -> backupsDir.listFiles(file -> file.isDirectory() && BACKUP_DIR_PATTERN.matcher(file.getName()).matches())).filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList());
        int count = 0;
        while (fileStore.getUsableSpace() < (long)minimumFreeSpace * 0x40000000L && !allBackupDirs.isEmpty()) {
            Map<String, List<File>> dirsByOriginalName = allBackupDirs.stream().collect(Collectors.groupingBy(dir -> dir.getName().substring(0, dir.getName().length() - 15)));
            List dirsWithOneBackup = dirsByOriginalName.values().stream().filter(list -> list.size() == 1).flatMap(Collection::stream).sorted(Comparator.comparing(dir -> BackupUtils.parseDate(dir.getName()))).collect(Collectors.toList());
            List dirsWithMultipleBackups = dirsByOriginalName.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).sorted(Comparator.comparing(dir -> BackupUtils.parseDate(dir.getName()))).collect(Collectors.toList());
            File backupToDelete = dirsWithMultipleBackups.isEmpty() ? (File)dirsWithOneBackup.get(0) : (File)dirsWithMultipleBackups.get(0);
            logger.info("Deleting map backup {} to make space on drive", (Object)backupToDelete);
            if (!FileUtils.deleteDir((File)backupToDelete)) {
                throw new IOException("Could not (fully) delete backup directory " + backupToDelete);
            }
            allBackupDirs.remove(backupToDelete);
            ++count;
        }
        return count;
    }

    private static Date parseDate(String name) {
        try {
            return AbstractWorldExporter.DATE_FORMAT.parse(name.substring(name.length() - 14));
        }
        catch (ParseException e) {
            throw new MDCCapturingRuntimeException("Could not parse date in filename \"" + name + '\"', (Throwable)e);
        }
    }
}

