/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.tools.scripts.CreateFilterOp;
import org.pepsoft.worldpainter.tools.scripts.ExportWorldOp;
import org.pepsoft.worldpainter.tools.scripts.GetHeightMapOp;
import org.pepsoft.worldpainter.tools.scripts.GetLayerOp;
import org.pepsoft.worldpainter.tools.scripts.GetPlatformOp;
import org.pepsoft.worldpainter.tools.scripts.GetTerrainOp;
import org.pepsoft.worldpainter.tools.scripts.GetWorldOp;
import org.pepsoft.worldpainter.tools.scripts.ImportHeightMapOp;
import org.pepsoft.worldpainter.tools.scripts.InstallCustomTerrainOp;
import org.pepsoft.worldpainter.tools.scripts.MappingOp;
import org.pepsoft.worldpainter.tools.scripts.MergeWorldOp;
import org.pepsoft.worldpainter.tools.scripts.SaveWorldOp;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;

public class ScriptingContext {
    public final boolean commandLine;
    private boolean goCalled = true;
    private String lastCommandName;

    public ScriptingContext(boolean commandLine) {
        this.commandLine = commandLine;
    }

    public String getVersion() {
        return Version.VERSION;
    }

    public GetWorldOp getWorld() {
        this.checkGoCalled("getWorld");
        return new GetWorldOp(this);
    }

    public GetLayerOp getLayer() {
        this.checkGoCalled("getLayer");
        return new GetLayerOp(this);
    }

    public GetTerrainOp getTerrain() {
        this.checkGoCalled("getTerrain");
        return new GetTerrainOp(this);
    }

    public ImportHeightMapOp createWorld() {
        this.checkGoCalled("createWorld");
        return new ImportHeightMapOp(this);
    }

    public ExportWorldOp exportWorld(World2 world) throws ScriptException {
        this.checkGoCalled("exportWorld");
        return new ExportWorldOp(this, world);
    }

    public MergeWorldOp mergeWorld() {
        this.checkGoCalled("mergeWorld");
        return new MergeWorldOp(this);
    }

    public SaveWorldOp saveWorld(World2 world) throws ScriptException {
        this.checkGoCalled("saveWorld");
        return new SaveWorldOp(this, world);
    }

    public GetHeightMapOp getHeightMap() {
        this.checkGoCalled("getHeightMap");
        return new GetHeightMapOp(this);
    }

    public MappingOp applyHeightMap(HeightMap heightMap) throws ScriptException {
        this.checkGoCalled("applyHeightMap");
        return new MappingOp(this, heightMap);
    }

    public MappingOp applyLayer(Layer layer) throws ScriptException {
        this.checkGoCalled("applyLayer");
        return new MappingOp(this, layer);
    }

    public MappingOp applyTerrain(int terrainIndex) throws ScriptException {
        this.checkGoCalled("applyTerrain");
        return new MappingOp(this, terrainIndex);
    }

    public InstallCustomTerrainOp installCustomTerrain(MixedMaterial terrain) throws ScriptException {
        this.checkGoCalled("installCustomTerrain");
        return new InstallCustomTerrainOp(this, terrain);
    }

    public CreateFilterOp createFilter() {
        this.checkGoCalled("createFilter");
        return new CreateFilterOp(this);
    }

    public GetPlatformOp getMapFormat() {
        this.checkGoCalled("getMapFormat");
        return new GetPlatformOp(this);
    }

    public void checkGoCalled(String commandName) {
        if (!this.goCalled) {
            throw new IllegalStateException("You forgot to invoke go() on the " + this.lastCommandName + "() operation");
        }
        this.goCalled = false;
        this.lastCommandName = commandName;
    }

    void goCalled() {
        this.goCalled = true;
    }
}

