/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.pepsoft.worldpainter.UnloadableWorldException;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldIO;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class GetWorldOp
extends AbstractOperation<World2> {
    private String fileName;

    protected GetWorldOp(ScriptingContext context) {
        super(context);
    }

    public GetWorldOp fromFile(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Override
    public World2 go() throws ScriptException {
        this.goCalled();
        File file = this.sanityCheckFileName(this.fileName);
        WorldIO worldIO = new WorldIO();
        try {
            worldIO.load(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ScriptException("I/O error while loading world " + this.fileName, e);
        }
        catch (UnloadableWorldException e) {
            throw new ScriptException("Unloadable world " + this.fileName + " (not a WorldPainter world?)", (Throwable)((Object)e));
        }
        return worldIO.getWorld();
    }
}

