/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.plugins.LayerProvider;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class GetLayerOp
extends AbstractOperation<Layer> {
    private World2 world;
    private String name;
    private String fileName;

    protected GetLayerOp(ScriptingContext context) {
        super(context);
    }

    public GetLayerOp fromFile(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public GetLayerOp fromWorld(World2 world) {
        this.world = world;
        return this;
    }

    public GetLayerOp withName(String name) {
        this.name = name;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Layer go() throws ScriptException {
        Layer layer;
        this.goCalled();
        if (this.fileName != null) {
            File file = this.sanityCheckFileName(this.fileName);
            try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(file)));){
                Layer layer2 = (Layer)in.readObject();
                return layer2;
            }
            catch (IOException e) {
                throw new ScriptException("I/O error while loading layer " + this.fileName, e);
            }
            catch (ClassCastException e) {
                throw new ScriptException(this.fileName + " is not a WorldPainter custom layer file", e);
            }
            catch (ClassNotFoundException e) {
                throw new ScriptException("Class not found exception while loading layer " + this.fileName + " (not a WorldPainter custom layer?)", e);
            }
        }
        if (this.world != null) {
            Layer layer3;
            if (this.name == null) throw new ScriptException("name not set");
            if (this.name.isEmpty()) {
                throw new ScriptException("name not set");
            }
            Iterator<Dimension> file = this.world.getDimensions().iterator();
            block13: while (true) {
                if (!file.hasNext()) throw new ScriptException("World contains no layer named \"" + this.name + "\"");
                Dimension dimension = file.next();
                Iterator<Layer> iterator = dimension.getAllLayers(false).iterator();
                do {
                    if (!iterator.hasNext()) continue block13;
                } while (!(layer3 = iterator.next()).getName().equals(this.name));
                break;
            }
            return layer3;
        }
        if (this.name == null) throw new ScriptException("name not set");
        if (this.name.isEmpty()) {
            throw new ScriptException("name not set");
        }
        if (this.name.equals("Biomes")) {
            return Biome.INSTANCE;
        }
        if (this.name.equals("Annotations")) {
            return Annotations.INSTANCE;
        }
        if (this.name.equals("Populate")) {
            return Populate.INSTANCE;
        }
        List<LayerProvider> layerProviders = WPPluginManager.getInstance().getPlugins(LayerProvider.class);
        Iterator<LayerProvider> iterator = layerProviders.iterator();
        block15: while (true) {
            if (!iterator.hasNext()) throw new ScriptException("No default layer named \"" + this.name + "\" exists and no world specified");
            LayerProvider layerProvider = iterator.next();
            Iterator<Layer> iterator2 = layerProvider.getLayers().iterator();
            do {
                if (!iterator2.hasNext()) continue block15;
            } while (!(layer = iterator2.next()).getName().equals(this.name));
            break;
        }
        return layer;
    }
}

