/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.FloatTag;
import org.jnbt.IntArrayTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.NBTInputStream;
import org.jnbt.NumberTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.RegionFileCache;
import org.pepsoft.worldpainter.AbstractTool;

public class NBTDiff
extends AbstractTool {
    public static void main(String[] args) throws IOException {
        NBTDiff.initialisePlatform();
        File levelDatFile1 = new File(args[0], "level.dat");
        File levelDatFile2 = new File(args[1], "level.dat");
        int chunkX = Integer.parseInt(args[2]);
        int chunkZ = Integer.parseInt(args[3]);
        Tag chunk1 = NBTDiff.loadChunk(levelDatFile1, chunkX, chunkZ);
        Tag chunk2 = NBTDiff.loadChunk(levelDatFile2, chunkX, chunkZ);
        NBTDiff.diff("", chunk1, chunk2);
    }

    /*
     * Unable to fully structure code
     */
    private static Tag loadChunk(File levelDatFile, int chunkX, int chunkZ) throws IOException {
        level = JavaLevel.load(levelDatFile);
        chunkIn = RegionFileCache.getChunkDataInputStream(levelDatFile.getParentFile(), chunkX, chunkZ, level.getVersion());
        var5_5 = null;
        try {
            if (chunkIn == null) ** GOTO lbl-1000
            in = new NBTInputStream((InputStream)chunkIn);
            var7_8 = null;
            try {
                var8_9 = in.readTag();
                return var8_9;
            }
            catch (Throwable var8_10) {
                var7_8 = var8_10;
                throw var8_10;
            }
            finally {
                if (in != null) {
                    if (var7_8 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable var9_11) {
                            var7_8.addSuppressed(var9_11);
                        }
                    } else {
                        in.close();
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                throw new IllegalArgumentException(String.format("Chunk %d,%d not present!", new Object[]{chunkX, chunkZ}));
            }
            {
                catch (Throwable var6_7) {
                    var5_5 = var6_7;
                    throw var6_7;
                }
            }
        }
        finally {
            if (chunkIn != null) {
                if (var5_5 != null) {
                    try {
                        chunkIn.close();
                    }
                    catch (Throwable var9_12) {
                        var5_5.addSuppressed(var9_12);
                    }
                } else {
                    chunkIn.close();
                }
            }
        }
    }

    private static void diff(String prefix, Tag tag1, Tag tag2) {
        if (tag1.getClass() != tag2.getClass()) {
            throw new IllegalArgumentException("Tags not of the same type");
        }
        String name = tag1.getName();
        if (!Objects.equals(name, tag2.getName())) {
            System.out.printf("%s.%s.name \"%s\" != \"%s\"%n", prefix, name, name, tag2.getName());
        }
        switch (tag2.getClass().getSimpleName()) {
            case "ByteArrayTag": {
                NBTDiff.diffList(prefix, name, Bytes.asList((byte[])((ByteArrayTag)tag1).getValue()), Bytes.asList((byte[])((ByteArrayTag)tag2).getValue()));
                break;
            }
            case "CompoundTag": {
                NBTDiff.diffMap(prefix, name, ((CompoundTag)tag1).getValue(), ((CompoundTag)tag2).getValue());
                break;
            }
            case "DoubleTag": {
                NBTDiff.diffValue(prefix, name, ((DoubleTag)tag1).getValue(), ((DoubleTag)tag2).getValue());
                break;
            }
            case "FloatTag": {
                NBTDiff.diffValue(prefix, name, Float.valueOf(((FloatTag)tag1).getValue()), Float.valueOf(((FloatTag)tag2).getValue()));
                break;
            }
            case "IntArrayTag": {
                NBTDiff.diffList(prefix, name, Ints.asList((int[])((IntArrayTag)tag1).getValue()), Ints.asList((int[])((IntArrayTag)tag2).getValue()));
                break;
            }
            case "ListTag": {
                if (name.equals("Sections")) {
                    NBTDiff.diffMap(prefix, name, ((ListTag)tag1).getValue().stream().collect(Collectors.toMap(tag -> ((ByteTag)tag.getTag("Y")).intValue(), Function.identity())), ((ListTag)tag2).getValue().stream().collect(Collectors.toMap(tag -> ((ByteTag)tag.getTag("Y")).intValue(), Function.identity())));
                    break;
                }
                if (name.equals("Palette")) {
                    NBTDiff.diffMap(prefix, name, ((ListTag)tag1).getValue().stream().collect(Collectors.toMap(tag -> ((StringTag)tag.getTag("Name")).getValue(), Function.identity())), ((ListTag)tag2).getValue().stream().collect(Collectors.toMap(tag -> ((StringTag)tag.getTag("Name")).getValue(), Function.identity())));
                    break;
                }
                if (((ListTag)tag1).getType() != ((ListTag)tag2).getType()) {
                    System.out.printf("%s.%s.type %s != %s%n", prefix, name, ((ListTag)tag1).getType().getSimpleName(), ((ListTag)tag2).getType().getSimpleName());
                    break;
                }
                NBTDiff.diffList(prefix, name, ((ListTag)tag1).getValue(), ((ListTag)tag2).getValue());
                break;
            }
            case "LongArrayTag": {
                NBTDiff.diffList(prefix, name, Longs.asList((long[])((LongArrayTag)tag1).getValue()), Longs.asList((long[])((LongArrayTag)tag2).getValue()));
                break;
            }
            case "ByteTag": 
            case "IntTag": 
            case "LongTag": 
            case "ShortTag": {
                NBTDiff.diffValue(prefix, name, ((NumberTag)tag1).longValue(), ((NumberTag)tag2).longValue());
                break;
            }
            case "StringTag": {
                NBTDiff.diffValue(prefix, name, ((StringTag)tag1).getValue(), ((StringTag)tag2).getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Tags of type " + tag1.getClass().getSimpleName() + " not supported");
            }
        }
    }

    private static void diffList(String prefix, String name, List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            System.out.printf("%s.%s.length %d != %d%n", prefix, name, list1.size(), list2.size());
        } else {
            for (int i = 0; i < list1.size(); ++i) {
                Object value1 = list1.get(i);
                if (value1 instanceof Tag) {
                    NBTDiff.diff(String.format("%s.%s[%d]", prefix, name, i), (Tag)value1, (Tag)list2.get(i));
                    continue;
                }
                if (Objects.equals(value1, list2.get(i))) continue;
                System.out.printf("%s.%s[%d] %s != %s%n", prefix, name, i, value1, list2.get(i));
            }
        }
    }

    private static void diffValue(String prefix, String name, Object value1, Object value2) {
        if (!Objects.equals(value1, value2)) {
            System.out.printf("%s.%s %s != %s%n", prefix, name, value1, value2);
        }
    }

    private static <K, V extends Tag> void diffMap(String prefix, String name, Map<K, V> map1, Map<K, V> map2) {
        if (map1.size() != map2.size()) {
            System.out.printf("%s.%s.size %d != %d%n", prefix, name, map1.size(), map2.size());
        }
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            K key = entry.getKey();
            if (map2.containsKey(key)) {
                NBTDiff.diff(String.format("%s.%s[%s]", prefix, name, key), (Tag)entry.getValue(), (Tag)map2.get(key));
                continue;
            }
            System.out.printf("%s.%s[%s] missing from tag 2%n", prefix, name, key);
        }
        for (Map.Entry<K, V> key : map2.keySet()) {
            if (map1.containsKey(key)) continue;
            System.out.printf("%s.%s[%s] missing from tag 1%n", prefix, name, key);
        }
    }
}

