/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pepsoft.util.ObjectMapperHolder;

public class LegacyBlockDBTransformer {
    public static void main(String[] args) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(LegacyBlockDBTransformer.class.getResourceAsStream("mc-blocks.json")));){
            String name2;
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (line.trim().startsWith("#") || line.trim().startsWith("//")) continue;
                sb.append(line);
            }
            List blockSpecs = (List)ObjectMapperHolder.OBJECT_MAPPER.readValue(sb.toString(), List.class);
            HashMap<String, Map> allProperties = new HashMap<String, Map>();
            for (Map blockSpec : blockSpecs) {
                name2 = ((String)blockSpec.get("name")).intern();
                Map propertiesSeenForBlock = allProperties.computeIfAbsent(name2, s -> new HashMap());
                if (!blockSpec.containsKey("properties")) continue;
                for (Map.Entry entry : ((Map)blockSpec.get("properties")).entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    propertiesSeenForBlock.computeIfAbsent(key, s -> new HashSet()).add(value);
                }
            }
            allProperties.forEach((name, propertiesOfBlock) -> {
                System.out.println((String)name);
                propertiesOfBlock.forEach((key, values) -> System.out.printf("    %s: %s%n", key, values));
            });
            for (Map blockSpec : blockSpecs) {
                name2 = ((String)blockSpec.get("name")).intern();
                Map propertiesSeenForName = (Map)allProperties.get(name2);
                if (propertiesSeenForName == null || !blockSpec.containsKey("properties")) continue;
                Map blockSpecProperties = (Map)blockSpec.get("properties");
                Iterator i = blockSpecProperties.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String key = (String)entry.getKey();
                    if (((Set)propertiesSeenForName.get(key)).size() != 1) continue;
                    i.remove();
                }
                if (!blockSpecProperties.isEmpty()) continue;
                blockSpec.remove("properties");
            }
            try (FileWriter out = new FileWriter("legacy-mc-blocks.json");){
                ObjectMapperHolder.OBJECT_MAPPER.writeValue((Writer)out, (Object)blockSpecs);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading Minecraft block database mc-blocks.json from classpath", e);
        }
    }
}

