/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.pepsoft.minecraft.RegionFile;

public class FindOutliers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        File[] worldDirs;
        for (File worldDir : worldDirs = new File(args[0]).listFiles()) {
            System.out.println("Scanning " + worldDir);
            File[] regionFiles = new File(worldDir, "region").listFiles();
            if (regionFiles == null || regionFiles.length == 0) {
                System.out.println("  No regions found");
                continue;
            }
            int regionCount = 0;
            int chunkCount = 0;
            int lowestChunkX = Integer.MAX_VALUE;
            int highestChunkX = Integer.MIN_VALUE;
            int lowestChunkZ = Integer.MAX_VALUE;
            int highestChunkZ = Integer.MIN_VALUE;
            ArrayList<Integer> xValues = new ArrayList<Integer>();
            ArrayList<Integer> zValues = new ArrayList<Integer>();
            ArrayList<Point> chunks = new ArrayList<Point>();
            for (File file : regionFiles) {
                String[] nameFrags = file.getName().split("\\.");
                int regionX = Integer.parseInt(nameFrags[1]);
                int regionZ = Integer.parseInt(nameFrags[2]);
                ++regionCount;
                try (RegionFile regionFile = new RegionFile(file);){
                    for (int x = 0; x < 32; ++x) {
                        for (int z = 0; z < 32; ++z) {
                            if (!regionFile.containsChunk(x, z)) continue;
                            ++chunkCount;
                            int chunkX = regionX * 32 + x;
                            int chunkZ = regionZ * 32 + z;
                            if (chunkX < lowestChunkX) {
                                lowestChunkX = chunkX;
                            }
                            if (chunkX > highestChunkX) {
                                highestChunkX = chunkX;
                            }
                            if (chunkZ < lowestChunkZ) {
                                lowestChunkZ = chunkZ;
                            }
                            if (chunkZ > highestChunkZ) {
                                highestChunkZ = chunkZ;
                            }
                            xValues.add(chunkX);
                            zValues.add(chunkZ);
                            chunks.add(new Point(chunkX, chunkZ));
                        }
                    }
                }
            }
            Collections.sort(xValues);
            int p1 = xValues.size() / 4;
            float q1 = (float)((Integer)xValues.get(p1)).intValue() * 0.75f + (float)((Integer)xValues.get(p1 + 1)).intValue() * 0.25f;
            int p2 = xValues.size() / 2;
            float q2 = (float)((Integer)xValues.get(p2) + (Integer)xValues.get(p2 + 1)) / 2.0f;
            int p3 = xValues.size() * 3 / 4;
            float q3 = (float)((Integer)xValues.get(p3)).intValue() * 0.25f + (float)((Integer)xValues.get(p3 + 1)).intValue() * 0.75f;
            float iqr = q3 - q1;
            int lowerLimit = (int)(q2 - iqr * 1.5f);
            int upperLimit = (int)(q2 + iqr * 1.5f);
            HashSet<Point> outlyingChunks = new HashSet<Point>();
            for (Point chunk : chunks) {
                if (chunk.x >= lowerLimit && chunk.x <= upperLimit) continue;
                outlyingChunks.add(chunk);
            }
            Collections.sort(zValues);
            p1 = zValues.size() / 4;
            q1 = (float)((Integer)zValues.get(p1)).intValue() * 0.75f + (float)((Integer)zValues.get(p1 + 1)).intValue() * 0.25f;
            p2 = zValues.size() / 2;
            q2 = (float)((Integer)zValues.get(p2) + (Integer)zValues.get(p2 + 1)) / 2.0f;
            p3 = zValues.size() * 3 / 4;
            q3 = (float)((Integer)zValues.get(p3)).intValue() * 0.25f + (float)((Integer)zValues.get(p3 + 1)).intValue() * 0.75f;
            iqr = q3 - q1;
            lowerLimit = (int)(q2 - iqr * 1.5f);
            upperLimit = (int)(q2 + iqr * 1.5f);
            for (Point chunk : chunks) {
                if (chunk.y >= lowerLimit && chunk.y <= upperLimit) continue;
                outlyingChunks.add(chunk);
            }
            if (!outlyingChunks.isEmpty()) {
                System.out.println("  Outlying chunk count: " + outlyingChunks.size());
                continue;
            }
            System.out.println("  No outlying chunks found: " + outlyingChunks.size());
        }
    }
}

