/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC118AnvilChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.DataUtils;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.PlatformManager;

public class DumpChunk
extends AbstractTool {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        DumpChunk.initialisePlatform();
        File levelDatFile = new File(args[0]);
        int chunkX = Integer.parseInt(args[1]);
        int chunkZ = Integer.parseInt(args[2]);
        JavaLevel level = JavaLevel.load(levelDatFile);
        File worldDir = levelDatFile.getParentFile();
        Platform platform = PlatformManager.getInstance().identifyPlatform(worldDir);
        Chunk chunk = PlatformManager.getInstance().getChunkStore(platform, worldDir, 0).getChunk(chunkX, chunkZ);
        if (chunk.isBiomesAvailable()) {
            System.out.println("Biomes");
            System.out.println("X-->");
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    System.out.printf("[%3d]", chunk.getBiome(x, z));
                }
                if (z == 0) {
                    System.out.print(" Z");
                } else if (z == 1) {
                    System.out.print(" |");
                } else if (z == 2) {
                    System.out.print(" v");
                }
                System.out.println();
            }
        } else if (chunk.is3DBiomesAvailable()) {
            System.out.println("Biomes");
            for (int y = 0; y < level.getMaxHeight() >> 2; ++y) {
                System.out.println("X-->");
                for (int z = 0; z < 4; ++z) {
                    for (int x = 0; x < 4; ++x) {
                        System.out.printf("[%3d]", chunk.get3DBiome(x, y, z));
                    }
                    if (z == 0) {
                        System.out.print(" Z");
                    } else if (z == 1) {
                        System.out.print(" |");
                    } else if (z == 2) {
                        System.out.print(" v");
                    } else {
                        System.out.print(" Y: " + y);
                    }
                    System.out.println();
                }
            }
        }
        if (chunk instanceof MC115AnvilChunk || chunk instanceof MC118AnvilChunk) {
            Map<String, long[]> heightMaps = chunk instanceof MC115AnvilChunk ? ((MC115AnvilChunk)chunk).getHeightMaps() : ((MC118AnvilChunk)chunk).getHeightMaps();
            for (Map.Entry<String, long[]> entry : heightMaps.entrySet()) {
                System.out.println("Heightmap (type: " + entry.getKey() + ")");
                System.out.println("X-->");
                long[][] data = DataUtils.unpackDataArray((Object)entry.getValue(), (int)9, (int)16);
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        System.out.printf("[%3d]", data[z][x]);
                    }
                    if (z == 0) {
                        System.out.print(" Z");
                    } else if (z == 1) {
                        System.out.print(" |");
                    } else if (z == 2) {
                        System.out.print(" v");
                    }
                    System.out.println();
                }
            }
        }
        System.out.println("Blocks:");
        List<Entity> entities = chunk.getEntities();
        List<TileEntity> tileEntities = chunk.getTileEntities();
        for (int y = 0; y < level.getMaxHeight(); ++y) {
            boolean blockFound = false;
            block9: for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk.getMaterial(x, y, z) == Material.AIR) continue;
                    blockFound = true;
                    break block9;
                }
            }
            if (!blockFound) continue;
            System.out.println("X-->");
            TreeMap<String, Set> materialsInSlice = new TreeMap<String, Set>();
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Material material = chunk.getMaterial(x, y, z);
                    Integer waterLevel = material.getProperty(Material.LEVEL);
                    if (material != Material.AIR) {
                        String name = material.name;
                        name = name.substring(name.indexOf(58) + 1);
                        if (waterLevel == null) {
                            System.out.printf("[%3.3s:  ]", name);
                        } else {
                            System.out.printf("[%3.3s:%2d]", name, waterLevel);
                        }
                        materialsInSlice.computeIfAbsent(name, materialsForTag -> new HashSet()).add(material);
                        continue;
                    }
                    if (waterLevel == null) {
                        System.out.print("[   :  ]");
                        continue;
                    }
                    System.out.printf("[   :%2d]", waterLevel);
                }
                if (z == 0) {
                    System.out.print(" Z");
                } else if (z == 1) {
                    System.out.print(" |");
                } else if (z == 2) {
                    System.out.print(" v");
                } else if (z == 15) {
                    System.out.print(" Y: " + y);
                }
                System.out.println();
            }
            materialsInSlice.forEach((tag, materials) -> System.out.println(tag + ": " + materials.stream().map(Material::toFullString).collect(Collectors.joining(", "))));
            for (Entity entity : entities) {
                if (!(entity.getPos()[1] >= (double)y) || !(entity.getPos()[1] < (double)(y + 1))) continue;
                System.out.println("Entity " + entity.getId() + ": " + entity.toString().replaceAll("[\\r\\n]", ""));
            }
        }
        if (!tileEntities.isEmpty()) {
            System.out.println("Unmatched tile entities!");
            for (TileEntity tileEntity : tileEntities) {
                System.out.println(tileEntity.getId() + "@" + tileEntity.getX() + "," + tileEntity.getY() + "," + tileEntity.getZ());
            }
        }
    }
}

