/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jnbt.CompoundTag;
import org.jnbt.NBTInputStream;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.MCRegionChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.RegionFileCache;

public class CompareChunks {
    public static void main(String[] args) throws IOException {
        File levelDatFile1 = new File(args[0]);
        File levelDatFile2 = new File(args[1]);
        int blockX = Integer.parseInt(args[2]);
        int blockZ = Integer.parseInt(args[3]);
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        Chunk chunk1 = CompareChunks.loadChunk(levelDatFile1, chunkX, chunkZ);
        Chunk chunk2 = CompareChunks.loadChunk(levelDatFile2, chunkX, chunkZ);
        if (chunk1.getMaxHeight() != chunk2.getMaxHeight()) {
            throw new IllegalArgumentException("Map heights not equal");
        }
        for (int y = 0; y < chunk1.getMaxHeight(); ++y) {
            boolean block1Found = false;
            boolean block2Found = false;
            block1: for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk1.getMaterial(x, y, z) != Material.AIR) {
                        block1Found = true;
                        if (block2Found) break block1;
                    }
                    if (chunk2.getMaterial(x, y, z) == Material.AIR) continue;
                    block2Found = true;
                    if (block1Found) break block1;
                }
            }
            if (!block1Found && !block2Found) continue;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Material material2;
                    Material material1 = chunk1.getMaterial(x, y, z);
                    if (material1.equals(material2 = chunk2.getMaterial(x, y, z))) continue;
                    System.out.printf("Difference @ %d,%d,%d%nMaterial in chunk 1: %s%nMaterial in chunk 2: %s%n", x, y, z, material1.toFullString(), material2.toFullString());
                }
            }
        }
    }

    public static Chunk loadChunk(File levelDatFile, int chunkX, int chunkZ) throws IOException {
        CompoundTag chunkTag;
        JavaLevel level;
        block25: {
            level = JavaLevel.load(levelDatFile);
            try (DataInputStream chunkIn = RegionFileCache.getChunkDataInputStream(levelDatFile.getParentFile(), chunkX, chunkZ, level.getVersion());){
                if (chunkIn != null) {
                    try (NBTInputStream in = new NBTInputStream((InputStream)chunkIn);){
                        chunkTag = (CompoundTag)in.readTag();
                        break block25;
                    }
                }
                throw new IllegalArgumentException(String.format("Chunk %d,%d not present!%n", chunkX, chunkZ));
            }
        }
        return level.getVersion() == 19132 ? new MCRegionChunk(chunkTag, level.getMaxHeight()) : (level.getDataVersion() <= 1343 || level.getDataVersion() == 0 ? new MC12AnvilChunk(chunkTag, level.getMaxHeight()) : new MC115AnvilChunk(chunkTag, level.getMaxHeight()));
    }
}

