/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.fancy;

import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.themes.impl.fancy.FancyTheme;

public class FancyPostGenerationTheme
extends FancyTheme {
    private final Dimension dimension;

    public FancyPostGenerationTheme(Dimension dimension, Terrain baseTerrain) {
        super(dimension.getMinHeight(), dimension.getMaxHeight(), ((HeightMapTileFactory)dimension.getTileFactory()).getWaterHeight(), null, baseTerrain);
        this.dimension = dimension;
    }

    @Override
    protected float getHeight(int x, int y) {
        return this.dimension.getHeightAt(x, y);
    }

    public void install() {
        int i;
        Terrain terrain;
        int n;
        this.snowLayer = null;
        for (CustomLayer layer : this.dimension.getCustomLayers()) {
            if (!(layer instanceof GroundCoverLayer) || !layer.getName().equals("Mountain Snow")) continue;
            this.snowLayer = (GroundCoverLayer)layer;
            break;
        }
        if (this.snowLayer == null) {
            this.snowLayer = new GroundCoverLayer("Mountain Snow", MixedMaterial.create("Deep Snow", Material.SNOW_BLOCK), 0xFFFFFF);
            this.snowLayer.setThickness(5);
            this.snowLayer.setEdgeWidth(15);
            this.snowLayer.setEdgeShape(GroundCoverLayer.EdgeShape.SMOOTH);
            this.dimension.getCustomLayers().add(this.snowLayer);
        }
        this.terrainDirtAndGravel = null;
        Terrain[] terrainArray = Terrain.getConfiguredValues();
        int layer = terrainArray.length;
        for (n = 0; n < layer; ++n) {
            terrain = terrainArray[n];
            if (!terrain.getName().equals("Mountain Dirt/Gravel")) continue;
            this.terrainDirtAndGravel = terrain;
            break;
        }
        if (this.terrainDirtAndGravel == null) {
            MixedMaterial mixedMaterial = new MixedMaterial("Mountain Dirt/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.DIRT, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f);
            for (i = 0; i < 96; ++i) {
                if (Terrain.isCustomMaterialConfigured(i)) continue;
                Terrain.setCustomMaterial(i, mixedMaterial);
                this.terrainDirtAndGravel = Terrain.getCustomTerrain(i);
                break;
            }
            if (this.terrainDirtAndGravel == null) {
                throw new IllegalStateException("No empty custom terrain slots available");
            }
        }
        this.terrainStoneAndGravel = null;
        Terrain[] terrainArray2 = Terrain.getConfiguredValues();
        i = terrainArray2.length;
        for (n = 0; n < i; ++n) {
            terrain = terrainArray2[n];
            if (!terrain.getName().equals("Mountain Stone/Gravel")) continue;
            this.terrainStoneAndGravel = terrain;
            break;
        }
        if (this.terrainStoneAndGravel == null) {
            MixedMaterial mixedMaterial = new MixedMaterial("Mountain Stone/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.STONE, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f);
            for (i = 0; i < 96; ++i) {
                if (Terrain.isCustomMaterialConfigured(i)) continue;
                Terrain.setCustomMaterial(i, mixedMaterial);
                this.terrainStoneAndGravel = Terrain.getCustomTerrain(i);
                break;
            }
            if (this.terrainStoneAndGravel == null) {
                throw new IllegalStateException("No empty custom terrain slots available");
            }
        }
    }
}

