/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.HeightFilter;
import org.pepsoft.worldpainter.themes.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTheme
implements Theme,
Cloneable {
    private long seed;
    private int waterHeight;
    private int minHeight;
    private int maxHeight;
    private SortedMap<Integer, Terrain> terrainRanges;
    private boolean randomise;
    private boolean beaches;
    private Terrain[] terrainRangesTable;
    private Map<Filter, Layer> layerMap;
    private transient PerlinNoise perlinNoise = new PerlinNoise(0L);
    private Layer[] layerCache;
    private Layer[] bitLayerCache;
    private int[][] layerLevelCache;
    private int[][] bitLayerLevelCache;
    private Map<Layer, Integer> discreteValues;
    private static final Random random = new Random();
    private static final Logger logger = LoggerFactory.getLogger(SimpleTheme.class);
    private static final long serialVersionUID = 1L;

    @Deprecated
    public SimpleTheme(long seed, int waterHeight, Terrain[] terrainRangesTable, int minHeight, int maxHeight, boolean randomise, boolean beaches) {
        this.setSeed(seed);
        this.setWaterHeight(waterHeight);
        this.minHeight = minHeight;
        this.maxHeight = terrainRangesTable.length;
        this.terrainRangesTable = terrainRangesTable;
        this.fixTerrainRangesTable();
        this.setMinMaxHeight(minHeight, maxHeight, HeightTransform.IDENTITY);
        this.setRandomise(randomise);
        this.setBeaches(beaches);
    }

    public SimpleTheme(long seed, int waterHeight, SortedMap<Integer, Terrain> terrainRanges, Map<Filter, Layer> layerMap, int minHeight, int maxHeight, boolean randomise, boolean beaches) {
        this.setSeed(seed);
        this.setWaterHeight(waterHeight);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.terrainRangesTable = new Terrain[maxHeight - minHeight];
        this.setTerrainRanges(terrainRanges);
        this.setLayerMap(layerMap);
        this.setRandomise(randomise);
        this.setBeaches(beaches);
    }

    @Override
    public void apply(Tile tile, int x, int y) {
        int level;
        int i;
        int height = MathUtils.clamp((int)this.minHeight, (int)tile.getIntHeight(x, y), (int)(this.maxHeight - 1));
        Terrain terrain = this.getTerrain(x, y, height);
        if (terrain == null) {
            throw new NullPointerException("apply(" + tile + ", " + x + ", " + y + ": getTerrain() returned null for " + this);
        }
        if (tile.getTerrain(x, y) != terrain) {
            tile.setTerrain(x, y, terrain);
        }
        if (this.layerCache != null) {
            for (i = 0; i < this.layerCache.length; ++i) {
                level = this.layerLevelCache[i][height - this.minHeight];
                if (level == tile.getLayerValue(this.layerCache[i], x, y)) continue;
                tile.setLayerValue(this.layerCache[i], x, y, level);
            }
        }
        if (this.bitLayerCache != null) {
            for (i = 0; i < this.bitLayerCache.length; ++i) {
                boolean set;
                level = this.bitLayerLevelCache[i][height - this.minHeight];
                boolean bl = set = level > 0 && (level == 15 || random.nextInt(15) < level);
                if (set == tile.getBitLayerValue(this.bitLayerCache[i], x, y)) continue;
                tile.setBitLayerValue(this.bitLayerCache[i], x, y, set);
            }
        }
    }

    @Override
    public final long getSeed() {
        return this.seed;
    }

    @Override
    public final void setSeed(long seed) {
        this.seed = seed;
        this.perlinNoise = new PerlinNoise(seed);
    }

    public final SortedMap<Integer, Terrain> getTerrainRanges() {
        return this.terrainRanges;
    }

    public final void setTerrainRanges(SortedMap<Integer, Terrain> terrainRanges) {
        if (terrainRanges == null) {
            throw new NullPointerException("terrainRanges");
        }
        if (terrainRanges.isEmpty()) {
            throw new IllegalArgumentException("terrainRanges may not be empty");
        }
        for (Map.Entry<Integer, Terrain> entry : terrainRanges.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
            throw new IllegalArgumentException("terrainRanges may not contain null values: " + terrainRanges);
        }
        int lowestLevel = terrainRanges.firstKey();
        if (lowestLevel >= this.minHeight) {
            Terrain lowestTerrain = (Terrain)((Object)terrainRanges.get(lowestLevel));
            terrainRanges.remove(lowestLevel);
            terrainRanges.put(this.minHeight - 1, lowestTerrain);
        }
        this.terrainRanges = terrainRanges;
        this.updateTerrainRangesTable();
    }

    public final boolean isRandomise() {
        return this.randomise;
    }

    public final void setRandomise(boolean randomise) {
        this.randomise = randomise;
    }

    @Override
    public final int getWaterHeight() {
        return this.waterHeight;
    }

    @Override
    public final void setWaterHeight(int waterHeight) {
        this.waterHeight = waterHeight;
    }

    public final boolean isBeaches() {
        return this.beaches;
    }

    public final void setBeaches(boolean beaches) {
        this.beaches = beaches;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public final int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public final void setMinMaxHeight(int minHeight, int maxHeight, HeightTransform transform) {
        if (minHeight != this.minHeight || maxHeight != this.maxHeight || !transform.isIdentity()) {
            int oldMinHeight = this.minHeight;
            int oldMaxHeight = this.maxHeight;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.waterHeight = MathUtils.clamp((int)minHeight, (int)transform.transformHeight(this.waterHeight), (int)(maxHeight - 1));
            Terrain[] oldTerrainRangesTable = this.terrainRangesTable;
            this.terrainRangesTable = new Terrain[maxHeight - minHeight];
            if (this.terrainRanges != null) {
                SortedMap<Integer, Terrain> oldTerrainRanges = this.terrainRanges;
                this.terrainRanges = new TreeMap<Integer, Terrain>();
                for (Map.Entry<Integer, Terrain> oldEntry : oldTerrainRanges.entrySet()) {
                    this.terrainRanges.put(this.extendOrClamp(oldMinHeight, minHeight, oldEntry.getKey(), transform, maxHeight - 1, oldMaxHeight - 1), oldEntry.getValue());
                }
                int lowestLevel = this.terrainRanges.firstKey();
                if (lowestLevel >= minHeight) {
                    Terrain lowestTerrain = (Terrain)((Object)this.terrainRanges.get(lowestLevel));
                    this.terrainRanges.remove(lowestLevel);
                    this.terrainRanges.put(minHeight - 1, lowestTerrain);
                }
                this.updateTerrainRangesTable();
            } else {
                for (int i = 0; i < this.terrainRangesTable.length; ++i) {
                    int oldIndex = i + minHeight - oldMinHeight;
                    this.terrainRangesTable[i] = oldIndex < 0 ? oldTerrainRangesTable[0] : (oldIndex >= oldTerrainRangesTable.length ? oldTerrainRangesTable[oldTerrainRangesTable.length - 1] : oldTerrainRangesTable[oldIndex]);
                }
            }
            if (this.layerMap != null) {
                HashMap<Filter, Layer> newLayerMap = new HashMap<Filter, Layer>();
                for (Map.Entry<Filter, Layer> entry : this.layerMap.entrySet()) {
                    Filter filter = entry.getKey();
                    if (filter instanceof HeightFilter) {
                        HeightFilter heightFilter = (HeightFilter)filter;
                        filter = new HeightFilter(minHeight, maxHeight, this.extendOrClamp(oldMinHeight, minHeight, heightFilter.getStartHeight(), transform, maxHeight, oldMaxHeight), this.extendOrClamp(oldMinHeight, minHeight, heightFilter.getStopHeight(), transform, maxHeight, oldMaxHeight), heightFilter.isFeather());
                    }
                    newLayerMap.put(filter, entry.getValue());
                }
                this.layerMap = newLayerMap;
            }
            this.initCaches();
        }
    }

    public final Map<Filter, Layer> getLayerMap() {
        return this.layerMap;
    }

    public final void setLayerMap(Map<Filter, Layer> layerMap) {
        this.layerMap = layerMap;
        this.initCaches();
    }

    public final Map<Layer, Integer> getDiscreteValues() {
        return this.discreteValues;
    }

    public final void setDiscreteValues(Map<Layer, Integer> discreteValues) {
        this.discreteValues = discreteValues;
        this.initCaches();
    }

    @Override
    public Theme clone() {
        try {
            SimpleTheme clone = (SimpleTheme)super.clone();
            if (this.terrainRanges != null) {
                clone.terrainRanges = new TreeMap<Integer, Terrain>(this.terrainRanges);
            }
            clone.terrainRangesTable = (Terrain[])this.terrainRangesTable.clone();
            if (this.layerMap != null) {
                clone.setLayerMap(new HashMap<Filter, Layer>(this.layerMap));
            }
            clone.perlinNoise = (PerlinNoise)this.perlinNoise.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "SimpleTheme{seed=" + this.seed + ", waterHeight=" + this.waterHeight + ", minHeight=" + this.minHeight + ", maxHeight=" + this.maxHeight + ", terrainRanges=" + this.terrainRanges + ", randomise=" + this.randomise + ", beaches=" + this.beaches + ", layerMap=" + this.layerMap + ", discreteValues=" + this.discreteValues + '}';
    }

    protected Terrain getTerrain(int x, int y, int height) {
        if (this.beaches && height >= this.waterHeight - 2 && height <= this.waterHeight + 1) {
            return Terrain.BEACHES;
        }
        if (this.isRandomise()) {
            height = (int)((float)height + this.perlinNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)height / 16.411f)) * 5.0f);
            height = (int)((float)height + this.perlinNoise.getPerlinNoise((double)((float)x / 4.099f), (double)((float)y / 4.099f), (double)((float)height / 4.099f)) * 5.0f);
            return this.terrainRangesTable[MathUtils.clamp((int)this.minHeight, (int)height, (int)(this.maxHeight - 1)) - this.minHeight];
        }
        return this.terrainRangesTable[height - this.minHeight];
    }

    protected int extendOrClamp(int oldMin, int min, int value, HeightTransform transform, int max, int oldMax) {
        if (value < oldMin) {
            return min - 1;
        }
        if (value == oldMin) {
            return min;
        }
        if (value == oldMax) {
            return max;
        }
        if (value > oldMax) {
            return max + 1;
        }
        return MathUtils.clamp((int)min, (int)transform.transformHeight(value), (int)max);
    }

    private void updateTerrainRangesTable() {
        for (int i = this.minHeight; i < this.maxHeight; ++i) {
            this.terrainRangesTable[i - this.minHeight] = (Terrain)((Object)this.terrainRanges.get(this.terrainRanges.headMap(i).lastKey()));
        }
    }

    private void initCaches() {
        if (this.layerMap != null) {
            ArrayList<Layer> layers = new ArrayList<Layer>(this.layerMap.size());
            ArrayList<Layer> bitLayers = new ArrayList<Layer>(this.layerMap.size());
            ArrayList<int[]> layerLevels = new ArrayList<int[]>(this.layerMap.size());
            ArrayList<int[]> bitLayerLevels = new ArrayList<int[]>(this.layerMap.size());
            this.layerLevelCache = new int[this.layerMap.size()][this.maxHeight - this.minHeight];
            block5: for (Map.Entry<Filter, Layer> entry : this.layerMap.entrySet()) {
                Layer layer = entry.getValue();
                Filter filter = entry.getKey();
                int[] levels = new int[this.maxHeight - this.minHeight];
                for (int z = this.minHeight; z < this.maxHeight; ++z) {
                    int filterLevel = filter.getLevel(0, 0, z, 15);
                    levels[z - this.minHeight] = this.discreteValues != null && this.discreteValues.containsKey(layer) ? ((double)filterLevel >= 0.5 ? this.discreteValues.get(layer).intValue() : layer.getDefaultValue()) : filterLevel;
                }
                switch (layer.getDataSize()) {
                    case BIT: 
                    case BIT_PER_CHUNK: {
                        bitLayers.add(layer);
                        bitLayerLevels.add(levels);
                        continue block5;
                    }
                    case NIBBLE: {
                        layers.add(layer);
                        layerLevels.add(levels);
                        continue block5;
                    }
                    case BYTE: {
                        if (!layer.discrete) {
                            throw new IllegalArgumentException("Layer with unsupported data size " + (Object)((Object)layer.getDataSize()) + " encountered");
                        }
                        layers.add(layer);
                        layerLevels.add(levels);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Layer with unsupported data size " + (Object)((Object)layer.getDataSize()) + " encountered");
            }
            if (!layers.isEmpty()) {
                this.layerCache = layers.toArray(new Layer[layers.size()]);
                this.layerLevelCache = (int[][])layerLevels.toArray((T[])new int[layerLevels.size()][]);
            } else {
                this.layerCache = null;
                this.layerLevelCache = null;
            }
            if (!bitLayers.isEmpty()) {
                this.bitLayerCache = bitLayers.toArray(new Layer[bitLayers.size()]);
                this.bitLayerLevelCache = (int[][])bitLayerLevels.toArray((T[])new int[bitLayerLevels.size()][]);
            } else {
                this.bitLayerCache = null;
                this.bitLayerLevelCache = null;
            }
        } else {
            this.layerCache = null;
            this.bitLayerCache = null;
            this.layerLevelCache = null;
            this.bitLayerLevelCache = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.terrainRanges != null) {
            this.fixTerrainRanges();
        }
        this.fixTerrainRangesTable();
        this.perlinNoise = new PerlinNoise(this.seed);
        this.initCaches();
    }

    private void fixTerrainRanges() {
        boolean mapChanged = false;
        for (Map.Entry<Integer, Terrain> entry : this.terrainRanges.entrySet()) {
            if (entry.getValue() != null) continue;
            logger.warn("Fixing SimpleTheme.terrainRanges[{}]: null -> BARE_GRASS", (Object)entry.getKey());
            entry.setValue(Terrain.BARE_GRASS);
            mapChanged = true;
        }
        if (mapChanged) {
            this.updateTerrainRangesTable();
        }
    }

    private void fixTerrainRangesTable() {
        for (int i = 0; i < this.terrainRangesTable.length; ++i) {
            if (this.terrainRangesTable[i] != null) continue;
            logger.warn("Fixing SimpleTheme.terrainRangesTable[{}]: null -> BARE_GRASS", (Object)i);
            this.terrainRangesTable[i] = Terrain.BARE_GRASS;
        }
    }

    public static SimpleTheme createSingleTerrain(Terrain terrain, int minHeight, int maxHeight, int waterHeight) {
        return new SimpleTheme(0L, waterHeight, new TreeMap<Integer, Terrain>((Map<Integer, Terrain>)ImmutableMap.of((Object)(minHeight - 1), (Object)((Object)terrain))), null, minHeight, maxHeight, false, false);
    }

    public static SimpleTheme createDefault(Terrain topTerrain, int minHeight, int maxHeight, int waterHeight) {
        return SimpleTheme.createDefault(topTerrain, minHeight, maxHeight, waterHeight, false, true);
    }

    public static SimpleTheme createDefault(Terrain topTerrain, int minHeight, int maxHeight, int waterHeight, boolean randomise, boolean beaches) {
        if (topTerrain == null) {
            throw new NullPointerException("topTerrain");
        }
        TreeMap<Integer, Terrain> terrainRanges = new TreeMap<Integer, Terrain>();
        float factor = (float)Math.min(maxHeight, 320) / 128.0f;
        terrainRanges.put(minHeight - 1, topTerrain);
        terrainRanges.put((int)(32.0f * factor) + waterHeight, Terrain.PERMADIRT);
        terrainRanges.put((int)(48.0f * factor) + waterHeight, Terrain.STONE_MIX);
        terrainRanges.put((int)(80.0f * factor) + waterHeight, Terrain.DEEP_SNOW);
        HashMap<Filter, Layer> layerMap = new HashMap<Filter, Layer>();
        layerMap.put(new HeightFilter(minHeight, maxHeight, (int)(64.0f * factor) + waterHeight, maxHeight, true), Frost.INSTANCE);
        return new SimpleTheme(0L, waterHeight, terrainRanges, layerMap, minHeight, maxHeight, randomise, beaches);
    }
}

