/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.ramps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public interface ColourRamp {
    public int getColour(float var1);

    default public BufferedImage getPreview(int width, int height) {
        return this.getPreview(width, height, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public BufferedImage getPreview(int width, int height, float min, float max) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        try {
            if (width > height) {
                for (int x = 0; x < width; ++x) {
                    int colour = this.getColour((float)x / (float)(width - 1) * (max - min) + min);
                    g2.setColor(new Color(colour));
                    g2.drawLine(x, 0, x, height - 1);
                }
            } else {
                for (int y = 0; y < height; ++y) {
                    int colour = this.getColour((float)(height - y - 1) / (float)(width - 1) * (max - min) + min);
                    g2.setColor(new Color(colour));
                    g2.drawLine(0, y, width - 1, y);
                }
            }
        }
        finally {
            g2.dispose();
        }
        return image;
    }
}

