/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.ramps;

import java.io.Serializable;
import org.pepsoft.worldpainter.ramps.ColourRamp;

public class ColourGradient
implements ColourRamp,
Serializable {
    private final float n1;
    private final float n2;
    private final float \u03b4n;
    private final int colour1;
    private final int red1;
    private final int green1;
    private final int blue1;
    private final int colour2;
    private final int red2;
    private final int green2;
    private final int blue2;
    private final Transition transition;

    public ColourGradient(int colour1, int colour2) {
        this(0.0f, colour1, 1.0f, colour2, Transition.COSINE);
    }

    public ColourGradient(float n1, int colour1, float n2, int colour2) {
        this(n1, colour1, n2, colour2, Transition.COSINE);
    }

    public ColourGradient(float n1, int colour1, float n2, int colour2, Transition transition) {
        if (n1 >= n2) {
            throw new IllegalArgumentException("n1 (" + n1 + ") >= n2 (" + n2 + ")");
        }
        this.n1 = n1;
        this.colour1 = colour1;
        this.n2 = n2;
        this.colour2 = colour2;
        this.transition = transition;
        this.red1 = (colour1 & 0xFF0000) >> 16;
        this.green1 = (colour1 & 0xFF00) >> 8;
        this.blue1 = colour1 & 0xFF;
        this.red2 = (colour2 & 0xFF0000) >> 16;
        this.green2 = (colour2 & 0xFF00) >> 8;
        this.blue2 = colour2 & 0xFF;
        this.\u03b4n = n2 - n1;
    }

    @Override
    public int getColour(float n) {
        if (n < this.n1) {
            return this.colour1;
        }
        if (n <= this.n2) {
            float \u03b1;
            switch (this.transition) {
                case LINEAR: {
                    \u03b1 = (n - this.n1) / this.\u03b4n;
                    break;
                }
                case COSINE: {
                    \u03b1 = (float)(Math.cos((double)((n - this.n1) / this.\u03b4n) * Math.PI + Math.PI) / 2.0 + 0.5);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            return (int)((1.0f - \u03b1) * (float)this.red1 + \u03b1 * (float)this.red2) << 16 | (int)((1.0f - \u03b1) * (float)this.green1 + \u03b1 * (float)this.green2) << 8 | (int)((1.0f - \u03b1) * (float)this.blue1 + \u03b1 * (float)this.blue2);
        }
        return this.colour2;
    }

    public static enum Transition {
        LINEAR,
        COSINE;

    }
}

