/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pepsoft.worldpainter.plugins.Provider;
import org.pepsoft.worldpainter.plugins.WPPluginManager;

public abstract class AbstractProviderManager<K, P extends Provider<K>> {
    private final List<P> allImplementations;
    private final List<K> allKeys;
    private final Map<K, P> implementationsByKey;

    protected AbstractProviderManager(Class<P> providerClass) {
        ArrayList<Provider> allImplementations = new ArrayList<Provider>();
        ArrayList allKeys = new ArrayList();
        HashMap implementationsByKey = new HashMap();
        for (Provider implementation : WPPluginManager.getInstance().getPlugins(providerClass)) {
            Collection keys = implementation.getKeys();
            allImplementations.add(implementation);
            for (Object key : keys) {
                if (allKeys.contains(key)) {
                    throw new RuntimeException("Duplicate key encountered: " + key);
                }
                allKeys.add(key);
                implementationsByKey.put(key, implementation);
            }
        }
        this.allImplementations = ImmutableList.copyOf(allImplementations);
        this.allKeys = ImmutableList.copyOf(allKeys);
        this.implementationsByKey = ImmutableMap.copyOf(implementationsByKey);
    }

    protected final List<K> getKeys() {
        return this.allKeys;
    }

    protected final List<P> getImplementations() {
        return this.allImplementations;
    }

    protected final P getImplementation(K key) {
        return (P)((Provider)this.implementationsByKey.get(key));
    }
}

